/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.data.Greenhouse;
import world.bentobox.greenhouses.managers.GreenhouseManager;

public class GreenhouseMap {
    private final Greenhouses addon;
    private final Map<Island, List<Greenhouse>> greenhouses = new HashMap<Island, List<Greenhouse>>();

    public GreenhouseMap(Greenhouses addon) {
        this.addon = addon;
    }

    public GreenhouseManager.GreenhouseResult addGreenhouse(Greenhouse greenhouse) {
        if (greenhouse.getBiomeRecipe().getBiome() == null) {
            return GreenhouseManager.GreenhouseResult.FAIL_UNKNOWN_RECIPE;
        }
        if (greenhouse.getWorld() == null) {
            return GreenhouseManager.GreenhouseResult.FAIL_NO_WORLD;
        }
        if (greenhouse.getLocation() == null) {
            return GreenhouseManager.GreenhouseResult.NULL;
        }
        return this.addon.getIslands().getIslandAt(greenhouse.getLocation()).map(i -> {
            this.greenhouses.putIfAbsent((Island)i, new ArrayList());
            if (!this.isOverlapping(greenhouse)) {
                this.greenhouses.get(i).add(greenhouse);
                return GreenhouseManager.GreenhouseResult.SUCCESS;
            }
            return GreenhouseManager.GreenhouseResult.FAIL_OVERLAPPING;
        }).orElse(GreenhouseManager.GreenhouseResult.FAIL_NO_ISLAND);
    }

    public void clear() {
        this.greenhouses.clear();
    }

    public Optional<Greenhouse> getGreenhouse(Location location) {
        return this.getXZGreenhouse(location).filter(g -> location.getBlockY() <= g.getCeilingHeight() && location.getBlockY() >= g.getFloorHeight());
    }

    private Optional<Greenhouse> getXZGreenhouse(Location location) {
        return this.addon.getIslands().getIslandAt(location).filter(this.greenhouses::containsKey).flatMap(i -> this.greenhouses.get(i).stream().filter(g -> g.contains(location)).findFirst());
    }

    public boolean inGreenhouse(Location location) {
        return this.getGreenhouse(location).isPresent();
    }

    public boolean inGreenhouse(Greenhouse gh, Location location) {
        return this.getGreenhouse(location).map(gh::equals).orElse(false);
    }

    public boolean isAboveGreenhouse(Location location) {
        return this.getXZGreenhouse(location).map(g -> location.getBlockY() > g.getCeilingHeight()).orElse(false);
    }

    private boolean isOverlapping(Greenhouse greenhouse) {
        return greenhouse.getLocation() != null && this.addon.getIslands().getIslandAt(greenhouse.getLocation()).map(i -> {
            this.greenhouses.putIfAbsent((Island)i, new ArrayList());
            return this.greenhouses.get(i).stream().anyMatch(g -> g.getLocation().getWorld().equals((Object)greenhouse.getLocation().getWorld()) && g.getBoundingBox().overlaps(greenhouse.getBoundingBox()));
        }).orElse(false) != false;
    }

    protected void removeGreenhouse(Greenhouse greenhouse) {
        if (greenhouse.getLocation() != null) {
            this.addon.getIslands().getIslandAt(greenhouse.getLocation()).ifPresent(i -> {
                if (this.greenhouses.containsKey(i)) {
                    this.greenhouses.get(i).remove(greenhouse);
                }
            });
        }
    }

    public void removeGreenhouses(Island island) {
        this.greenhouses.remove(island);
    }

    public List<Greenhouse> getGreenhouses() {
        return this.greenhouses.values().stream().flatMap(Collection::stream).toList();
    }

    public List<Greenhouse> getGreenhouses(Island island) {
        return this.greenhouses.getOrDefault(island, Collections.emptyList());
    }

    public int getSize() {
        return this.greenhouses.values().stream().mapToInt(List::size).sum();
    }
}

