/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.util.BoundingBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.events.BentoBoxReadyEvent;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.data.Greenhouse;
import world.bentobox.greenhouses.greenhouse.BiomeRecipe;
import world.bentobox.greenhouses.listeners.GreenhouseEvents;
import world.bentobox.greenhouses.listeners.GreenhouseGuard;
import world.bentobox.greenhouses.listeners.IslandChangeEvents;
import world.bentobox.greenhouses.listeners.SnowTracker;
import world.bentobox.greenhouses.managers.EcoSystemManager;
import world.bentobox.greenhouses.managers.GreenhouseFinder;
import world.bentobox.greenhouses.managers.GreenhouseMap;

public class GreenhouseManager
implements Listener {
    private final Greenhouses addon;
    private final GreenhouseMap map;
    private final Database<Greenhouse> handler;
    private EcoSystemManager ecoMgr;

    public GreenhouseManager(Greenhouses addon) {
        this.addon = addon;
        this.handler = new Database((Addon)addon, Greenhouse.class);
        this.map = new GreenhouseMap(addon);
    }

    @EventHandler
    public void startManager(BentoBoxReadyEvent e) {
        this.loadGreenhouses();
        this.ecoMgr = new EcoSystemManager(this.addon, this);
        this.ecoMgr.setup();
        this.addon.registerListener(new SnowTracker(this.addon));
        this.addon.registerListener(new GreenhouseEvents(this.addon));
        this.addon.registerListener(new GreenhouseGuard(this.addon));
        this.addon.registerListener(new IslandChangeEvents(this.addon));
    }

    public GreenhouseMap getMap() {
        return this.map;
    }

    private void loadGreenhouses() {
        this.map.clear();
        this.addon.log("Loading greenhouses...");
        ArrayList toBeRemoved = new ArrayList();
        this.handler.loadObjects().forEach(g -> {
            GreenhouseResult result = this.map.addGreenhouse((Greenhouse)g);
            switch (result.ordinal()) {
                case 16: {
                    toBeRemoved.add(g);
                    break;
                }
                case 17: {
                    this.addon.logError("Greenhouse overlaps with another greenhouse. Skipping...");
                    break;
                }
                case 18: {
                    this.addon.logError("Null location of greenhouse. Cannot load. Skipping...");
                    break;
                }
                case 19: {
                    this.activateGreenhouse((Greenhouse)g);
                    break;
                }
                case 22: {
                    this.addon.logError("Database contains greenhouse for a non-loaded world. Skipping...");
                    break;
                }
                case 23: {
                    this.addon.logError("Greenhouse uses a recipe that does not exist in the biomes.yml. Skipping...");
                    this.addon.logError("Greenhouse Id " + g.getUniqueId());
                    break;
                }
            }
        });
        this.addon.log("Loaded " + this.map.getSize() + " greenhouses.");
        toBeRemoved.forEach(arg_0 -> this.handler.deleteObject(arg_0));
    }

    public void removeGreenhouse(Greenhouse gh) {
        this.handler.deleteObject((Object)gh);
        this.map.removeGreenhouse(gh);
        if (gh.getOriginalBiome() == null) {
            this.addon.logError("Greenhouse had no original biome: " + String.valueOf(gh.getLocation()));
            return;
        }
        if (gh.getLocation() == null || gh.getLocation().getWorld() == null) {
            return;
        }
        this.addon.log("Returning biome to original state: " + gh.getOriginalBiome().toString());
        BoundingBox bb = gh.getBoundingBox();
        for (int x = (int)bb.getMinX(); x <= (int)bb.getMaxX(); x += 4) {
            for (int z = (int)bb.getMinZ(); z <= (int)bb.getMaxZ(); z += 4) {
                for (int y = (int)bb.getMinY(); y <= (int)bb.getMaxY(); y += 4) {
                    gh.getLocation().getWorld().setBiome(x, y, z, gh.getOriginalBiome());
                }
            }
        }
    }

    public CompletableFuture<GhResult> tryToMakeGreenhouse(Location location, BiomeRecipe greenhouseRecipe) {
        CompletableFuture<GhResult> r = new CompletableFuture<GhResult>();
        GreenhouseFinder finder = new GreenhouseFinder(this.addon);
        finder.find(location).thenAccept(resultSet -> {
            if (!resultSet.isEmpty()) {
                r.complete(new GhResult().setFinder(finder).setResults((Set<GreenhouseResult>)resultSet));
                return;
            }
            if (greenhouseRecipe != null) {
                this.checkRecipe(finder, greenhouseRecipe, (Set<GreenhouseResult>)resultSet).thenAccept(r::complete);
                return;
            }
            this.findRecipe(finder).thenAccept(rs -> {
                resultSet.addAll(rs);
                r.complete(new GhResult().setFinder(finder).setResults((Set<GreenhouseResult>)resultSet));
            });
        });
        return r;
    }

    private CompletableFuture<Set<GreenhouseResult>> findRecipe(GreenhouseFinder finder) {
        CompletableFuture<Set<GreenhouseResult>> r = new CompletableFuture<Set<GreenhouseResult>>();
        List<BiomeRecipe> list = this.addon.getRecipes().getBiomeRecipes().stream().sorted().collect(Collectors.toList());
        this.findRecipe(r, list, finder);
        return r;
    }

    private void findRecipe(CompletableFuture<Set<GreenhouseResult>> r, List<BiomeRecipe> list, GreenhouseFinder finder) {
        if (list.isEmpty()) {
            r.complete(Collections.singleton(GreenhouseResult.FAIL_NO_RECIPE_FOUND));
            return;
        }
        BiomeRecipe br = list.get(0);
        list.remove(0);
        br.checkRecipe(finder.getGh()).thenAccept(results -> {
            if (results.isEmpty()) {
                r.complete(Collections.singleton(GreenhouseResult.SUCCESS));
            } else {
                this.findRecipe(r, list, finder);
            }
        });
    }

    CompletableFuture<GhResult> checkRecipe(GreenhouseFinder finder, BiomeRecipe greenhouseRecipe, Set<GreenhouseResult> resultSet) {
        CompletableFuture<GhResult> r = new CompletableFuture<GhResult>();
        greenhouseRecipe.checkRecipe(finder.getGh()).thenAccept(rs -> {
            if (rs.isEmpty()) {
                finder.getGh().setBiomeRecipe(greenhouseRecipe);
                resultSet.add(this.map.addGreenhouse(finder.getGh()));
                this.activateGreenhouse(finder.getGh());
                this.handler.saveObjectAsync((Object)finder.getGh());
                rs.addAll(resultSet);
            }
            GhResult recipe = new GhResult().setFinder(finder).setResults((Set<GreenhouseResult>)rs);
            r.complete(recipe);
        });
        return r;
    }

    private void activateGreenhouse(Greenhouse gh) {
        Biome ghBiome = gh.getBiomeRecipe().getBiome();
        if (ghBiome == null) {
            this.addon.logError("Biome recipe error - no such biome for " + gh.getBiomeRecipe().getName());
            return;
        }
        BoundingBox bb = gh.getBoundingBox();
        int x = (int)bb.getMinX();
        while ((double)x < bb.getMaxX()) {
            int z = (int)bb.getMinZ();
            while ((double)z < bb.getMaxZ()) {
                int y = (int)bb.getMinY();
                while ((double)y < bb.getMaxY()) {
                    Objects.requireNonNull(gh.getWorld()).setBiome(x, y, z, ghBiome);
                    y += 4;
                }
                z += 4;
            }
            x += 4;
        }
    }

    public EcoSystemManager getEcoMgr() {
        return this.ecoMgr;
    }

    public void removeGreenhouses(Island island) {
        this.map.getGreenhouses(island).forEach(arg_0 -> this.handler.deleteObject(arg_0));
        this.map.removeGreenhouses(island);
    }

    public static enum GreenhouseResult {
        FAIL_NO_ROOF,
        FAIL_BELOW,
        FAIL_BLOCKS_ABOVE,
        FAIL_HOLE_IN_WALL,
        FAIL_HOLE_IN_ROOF,
        FAIL_UNEVEN_WALLS,
        FAIL_BAD_ROOF_BLOCKS,
        FAIL_BAD_WALL_BLOCKS,
        FAIL_TOO_MANY_DOORS,
        FAIL_TOO_MANY_HOPPERS,
        FAIL_NO_WATER,
        FAIL_NO_LAVA,
        FAIL_NO_ICE,
        FAIL_INSUFFICIENT_WATER,
        FAIL_INSUFFICIENT_LAVA,
        FAIL_INSUFFICIENT_ICE,
        FAIL_NO_ISLAND,
        FAIL_OVERLAPPING,
        NULL,
        SUCCESS,
        FAIL_NO_RECIPE_FOUND,
        FAIL_INSUFFICIENT_BLOCKS,
        FAIL_NO_WORLD,
        FAIL_UNKNOWN_RECIPE;

    }

    public static class GhResult {
        private Set<GreenhouseResult> results;
        private GreenhouseFinder finder;

        public Set<GreenhouseResult> getResults() {
            return this.results;
        }

        public GreenhouseFinder getFinder() {
            return this.finder;
        }

        GhResult setResults(Set<GreenhouseResult> results) {
            this.results = results;
            return this;
        }

        GhResult setFinder(GreenhouseFinder finder) {
            this.finder = finder;
            return this;
        }

        public String toString() {
            return "GhResult [results=" + String.valueOf(this.results) + ", finder=" + String.valueOf(this.finder) + "]";
        }
    }
}

