/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.managers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.data.Greenhouse;
import world.bentobox.greenhouses.greenhouse.Roof;
import world.bentobox.greenhouses.greenhouse.Walls;
import world.bentobox.greenhouses.managers.GreenhouseManager;
import world.bentobox.greenhouses.world.AsyncWorldCache;

public class GreenhouseFinder {
    private Greenhouse gh;
    private final Set<Vector> redGlass = new HashSet<Vector>();
    private boolean inCeiling = false;
    private int otherBlockLayer = -1;
    private int wallBlockCount;
    private final Greenhouses addon;
    private CounterCheck counterCheck = new CounterCheck();

    public GreenhouseFinder(Greenhouses addon) {
        this.addon = addon;
    }

    public CompletableFuture<Set<GreenhouseManager.GreenhouseResult>> find(Location location) {
        CompletableFuture<Set<GreenhouseManager.GreenhouseResult>> r = new CompletableFuture<Set<GreenhouseManager.GreenhouseResult>>();
        HashSet result = new HashSet();
        this.redGlass.clear();
        AsyncWorldCache cache = new AsyncWorldCache(this.addon, location.getWorld());
        Roof roof = new Roof(cache, location, this.addon);
        roof.findRoof().thenAccept(found -> {
            if (Boolean.FALSE.equals(found)) {
                result.add(GreenhouseManager.GreenhouseResult.FAIL_NO_ROOF);
                r.complete(result);
                return;
            }
            new Walls(cache).findWalls(roof).thenAccept(walls -> {
                this.gh = new Greenhouse(location.getWorld(), (Walls)walls, roof.getHeight());
                this.gh.setOriginalBiome(location.getBlock().getBiome());
                this.checkGreenhouse(cache, roof, (Walls)walls).thenAccept(c -> {
                    result.addAll(c);
                    r.complete(result);
                });
            });
        });
        return r;
    }

    CompletableFuture<Set<GreenhouseManager.GreenhouseResult>> checkGreenhouse(AsyncWorldCache cache, Roof roof, Walls walls) {
        CompletableFuture<Set<GreenhouseManager.GreenhouseResult>> r = new CompletableFuture<Set<GreenhouseManager.GreenhouseResult>>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BentoBox.getInstance(), () -> this.checkGreenhouseAsync(r, cache, roof, walls));
        return r;
    }

    private Set<GreenhouseManager.GreenhouseResult> checkGreenhouseAsync(CompletableFuture<Set<GreenhouseManager.GreenhouseResult>> r, AsyncWorldCache cache, Roof roof, Walls walls) {
        int y;
        this.counterCheck = new CounterCheck();
        for (y = roof.getHeight(); y > walls.getFloor(); --y) {
            this.wallBlockCount = 0;
            for (int x = walls.getMinX(); x <= walls.getMaxX(); ++x) {
                for (int z = walls.getMinZ(); z <= walls.getMaxZ(); ++z) {
                    this.checkBlock(this.counterCheck, cache.getBlockType(x, y, z), roof, walls, new Vector(x, y, z));
                }
            }
            if (this.wallBlockCount == 0 && y < roof.getHeight()) break;
            if (!this.counterCheck.otherBlock || this.otherBlockLayer >= 0) continue;
            this.otherBlockLayer = y;
        }
        HashSet<GreenhouseManager.GreenhouseResult> result = new HashSet<GreenhouseManager.GreenhouseResult>(this.checkErrors(roof, y));
        Bukkit.getScheduler().runTask((Plugin)BentoBox.getInstance(), () -> r.complete(result));
        return result;
    }

    Collection<GreenhouseManager.GreenhouseResult> checkErrors(Roof roof, int y) {
        HashSet<GreenhouseManager.GreenhouseResult> result = new HashSet<GreenhouseManager.GreenhouseResult>();
        if (roof.getLocation().getBlockY() <= y) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_BELOW);
        }
        if (this.isAirHoles() && !this.inCeiling) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_HOLE_IN_WALL);
        } else if (this.isAirHoles() && this.inCeiling) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_HOLE_IN_ROOF);
        }
        if (this.isOtherBlocks() && this.otherBlockLayer == y + 1) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_UNEVEN_WALLS);
        } else if (this.isOtherBlocks() && this.otherBlockLayer == roof.getHeight()) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_BAD_ROOF_BLOCKS);
        } else if (this.isOtherBlocks()) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_BAD_WALL_BLOCKS);
        }
        if (this.getWallDoors() > 8) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_TOO_MANY_DOORS);
        }
        if (this.getGhHopper() > 1) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_TOO_MANY_HOPPERS);
        }
        return result;
    }

    boolean checkBlock(CounterCheck cc, Material m, Roof roof, Walls walls, Vector v) {
        int x = v.getBlockX();
        int y = v.getBlockY();
        int z = v.getBlockZ();
        if (y == roof.getHeight() || x == walls.getMinX() || x == walls.getMaxX() || z == walls.getMinZ() || z == walls.getMaxZ()) {
            if (y != roof.getHeight() && !this.addon.wallBlocks(m) || y == roof.getHeight() && !roof.roofBlocks(m)) {
                if (m.equals((Object)Material.AIR)) {
                    cc.airHole = true;
                    if (y == roof.getHeight()) {
                        this.inCeiling = true;
                    }
                } else {
                    cc.otherBlock = true;
                }
                this.redGlass.add(v);
                return false;
            }
            ++this.wallBlockCount;
            return this.checkDoorsHoppers(cc, m, v);
        }
        return true;
    }

    boolean checkDoorsHoppers(CounterCheck cc, Material m, Vector v) {
        if (Tag.TRAPDOORS.isTagged((Keyed)m) || Tag.DOORS.isTagged((Keyed)m)) {
            int n = cc.doorCount = Tag.TRAPDOORS.isTagged((Keyed)m) ? cc.doorCount + 2 : cc.doorCount + 1;
            if (cc.doorCount > 8) {
                this.redGlass.add(v);
                return false;
            }
        }
        if (m.equals((Object)Material.HOPPER)) {
            ++cc.hopperCount;
            if (cc.hopperCount > 1) {
                this.redGlass.add(v);
                return false;
            }
            this.gh.setRoofHopperLocation(v);
        }
        return true;
    }

    public Greenhouse getGh() {
        return this.gh;
    }

    public Set<Vector> getRedGlass() {
        return this.redGlass;
    }

    int getWallDoors() {
        return this.counterCheck.doorCount;
    }

    int getGhHopper() {
        return this.counterCheck.hopperCount;
    }

    boolean isAirHoles() {
        return this.counterCheck.airHole;
    }

    boolean isOtherBlocks() {
        return this.counterCheck.otherBlock;
    }

    boolean isInCeiling() {
        return this.inCeiling;
    }

    int getOtherBlockLayer() {
        return this.otherBlockLayer;
    }

    int getWallBlockCount() {
        return this.wallBlockCount;
    }

    void setInCeiling(boolean inCeiling) {
        this.inCeiling = inCeiling;
    }

    void setOtherBlockLayer(int otherBlockLayer) {
        this.otherBlockLayer = otherBlockLayer;
    }

    void setWallBlockCount(int wallBlockCount) {
        this.wallBlockCount = wallBlockCount;
    }

    protected void setGh(Greenhouse gh) {
        this.gh = gh;
    }

    public void setGhHopper(int i) {
        this.counterCheck.hopperCount = i;
    }

    public void setWallDoors(int i) {
        this.counterCheck.doorCount = i;
    }

    public void setAirHoles(boolean b) {
        this.counterCheck.airHole = b;
    }

    public void setOtherBlocks(boolean b) {
        this.counterCheck.otherBlock = b;
    }

    static class CounterCheck {
        int doorCount;
        int hopperCount;
        boolean airHole;
        boolean otherBlock;

        CounterCheck() {
        }
    }
}

