/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.managers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Hopper;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.data.Greenhouse;
import world.bentobox.greenhouses.greenhouse.BiomeRecipe;
import world.bentobox.greenhouses.managers.GreenhouseManager;

public class EcoSystemManager {
    private static final int PLANTS_PER_BONEMEAL = 6;
    private static final String MINUTES = " minutes";
    private final Greenhouses addon;
    private final GreenhouseManager g;
    private BukkitTask plantTask;
    private BukkitTask mobTask;
    private BukkitTask blockTask;
    private BukkitTask ecoTask;

    public EcoSystemManager(Greenhouses addon, GreenhouseManager greenhouseManager) {
        this.addon = addon;
        this.g = greenhouseManager;
    }

    void setup() {
        long plantTick = (long)(this.addon.getSettings().getPlantTick() * 60) * 20L;
        if (plantTick > 0L) {
            this.addon.log("Kicking off flower growing scheduler every " + this.addon.getSettings().getPlantTick() + MINUTES);
            this.plantTask = this.addon.getServer().getScheduler().runTaskTimer((Plugin)this.addon.getPlugin(), () -> this.g.getMap().getGreenhouses().forEach(this::growPlants), 80L, plantTick);
        } else {
            this.addon.log("Flower growth disabled.");
        }
        long blockTick = (long)(this.addon.getSettings().getBlockTick() * 60) * 20L;
        if (blockTick > 0L) {
            this.addon.log("Kicking off block conversion scheduler every " + this.addon.getSettings().getBlockTick() + MINUTES);
            this.blockTask = this.addon.getServer().getScheduler().runTaskTimer((Plugin)this.addon.getPlugin(), () -> this.g.getMap().getGreenhouses().forEach(this::convertBlocks), 60L, blockTick);
        } else {
            this.addon.log("Block conversion disabled.");
        }
        long ecoTick = (long)(this.addon.getSettings().getEcoTick() * 60) * 20L;
        if (ecoTick > 0L) {
            this.addon.log("Kicking off greenhouse verify scheduler every " + this.addon.getSettings().getEcoTick() + MINUTES);
            this.ecoTask = this.addon.getServer().getScheduler().runTaskTimer((Plugin)this.addon.getPlugin(), () -> this.g.getMap().getGreenhouses().forEach(this::verify), ecoTick, ecoTick);
        } else {
            this.addon.log("Greenhouse verification disabled.");
        }
        long mobTick = (long)(this.addon.getSettings().getMobTick() * 60) * 20L;
        if (mobTick > 0L) {
            this.addon.log("Kicking off mob populator scheduler every " + this.addon.getSettings().getMobTick() + MINUTES);
            this.mobTask = this.addon.getServer().getScheduler().runTaskTimer((Plugin)this.addon.getPlugin(), () -> this.g.getMap().getGreenhouses().forEach(this::addMobs), 120L, mobTick);
        } else {
            this.addon.log("Mob disabled.");
        }
    }

    private void convertBlocks(Greenhouse gh) {
        World world = gh.getWorld();
        BoundingBox bb = gh.getBoundingBox();
        if (world == null || gh.getLocation() == null || gh.getLocation().getWorld() == null || !gh.getLocation().getWorld().isChunkLoaded((int)bb.getMaxX() >> 4, (int)bb.getMaxZ() >> 4) || !gh.getLocation().getWorld().isChunkLoaded((int)bb.getMinX() >> 4, (int)bb.getMinZ() >> 4)) {
            return;
        }
        BoundingBox ibb = gh.getInternalBoundingBox();
        int ghMinX = NumberConversions.floor((double)ibb.getMinX());
        int ghMaxX = NumberConversions.floor((double)ibb.getMaxX());
        int ghMinY = NumberConversions.floor((double)gh.getBoundingBox().getMinY());
        int ghMaxY = NumberConversions.floor((double)ibb.getMaxY());
        int ghMinZ = NumberConversions.floor((double)ibb.getMinZ());
        int ghMaxZ = NumberConversions.floor((double)ibb.getMaxZ());
        BiomeRecipe biomeRecipe = gh.getBiomeRecipe();
        for (int x = ghMinX; x < ghMaxX; ++x) {
            for (int z = ghMinZ; z < ghMaxZ; ++z) {
                for (int y = ghMinY; y < ghMaxY; ++y) {
                    Block b = world.getBlockAt(x, y, z);
                    if (b.isEmpty()) continue;
                    biomeRecipe.convertBlock(b);
                }
            }
        }
    }

    private void verify(Greenhouse gh) {
        if (gh.getLocation() == null || gh.getLocation().getWorld() == null || !gh.getLocation().getWorld().isChunkLoaded((int)gh.getBoundingBox().getMaxX() >> 4, (int)gh.getBoundingBox().getMaxZ() >> 4) || !gh.getLocation().getWorld().isChunkLoaded((int)gh.getBoundingBox().getMinX() >> 4, (int)gh.getBoundingBox().getMinZ() >> 4)) {
            return;
        }
        gh.getBiomeRecipe().checkRecipe(gh).thenAccept(rs -> {
            if (!rs.isEmpty()) {
                this.addon.log("Greenhouse failed verification at " + String.valueOf(gh.getLocation()));
                this.g.removeGreenhouse(gh);
            }
        });
    }

    boolean addMobs(Greenhouse gh) {
        BoundingBox bb = gh.getBoundingBox();
        if (gh.getLocation() == null || gh.getLocation().getWorld() == null || gh.getWorld() == null || !gh.getLocation().getWorld().isChunkLoaded((int)bb.getMaxX() >> 4, (int)bb.getMaxZ() >> 4) || !gh.getLocation().getWorld().isChunkLoaded((int)bb.getMinX() >> 4, (int)bb.getMinZ() >> 4)) {
            return false;
        }
        if (gh.getBiomeRecipe().noMobs()) {
            return false;
        }
        for (double blockX = bb.getMinX(); blockX < bb.getMaxX(); blockX += 16.0) {
            for (double blockZ = bb.getMinZ(); blockZ < bb.getMaxZ(); blockZ += 16.0) {
                int chunkX = (int)(blockX / 16.0);
                int chunkZ = (int)(blockZ / 16.0);
                if (gh.getWorld().isChunkLoaded(chunkX, chunkZ)) continue;
                return false;
            }
        }
        long sum = gh.getWorld().getEntities().stream().filter(e -> gh.getBiomeRecipe().getMobTypes().contains(e.getType())).filter(e -> gh.contains(e.getLocation())).count();
        ArrayList<GrowthBlock> list = new ArrayList<GrowthBlock>(this.getAvailableBlocks(gh, false));
        Collections.shuffle(list, new Random(System.currentTimeMillis()));
        Iterator it = list.iterator();
        if (gh.getBiomeRecipe().getMaxMob() > -1 && sum >= (long)gh.getBiomeRecipe().getMaxMob()) {
            return false;
        }
        while (it.hasNext() && (sum == 0L || (long)gh.getArea() / sum >= (long)gh.getBiomeRecipe().getMobLimit())) {
            if (!gh.getBiomeRecipe().spawnMob(((GrowthBlock)it.next()).block())) continue;
            ++sum;
        }
        return sum > 0L;
    }

    private void growPlants(Greenhouse gh) {
        BoundingBox bb = gh.getBoundingBox();
        if (gh.getLocation() == null || gh.getLocation().getWorld() == null || !gh.getLocation().getWorld().isChunkLoaded((int)bb.getMaxX() >> 4, (int)bb.getMaxZ() >> 4) || !gh.getLocation().getWorld().isChunkLoaded((int)bb.getMinX() >> 4, (int)bb.getMinZ() >> 4)) {
            return;
        }
        int bonemeal = this.getBoneMeal(gh);
        if (bonemeal > 0) {
            List<GrowthBlock> list = this.getAvailableBlocks(gh, false);
            Collections.shuffle(list);
            int plantsGrown = list.stream().limit(bonemeal).mapToInt(bl -> gh.getBiomeRecipe().growPlant((GrowthBlock)bl, false) ? 1 : 0).sum();
            list = this.getAvailableBlocks(gh, true);
            Collections.shuffle(list);
            if ((plantsGrown += list.stream().limit(bonemeal).mapToInt(bl -> gh.getBiomeRecipe().growPlant((GrowthBlock)bl, true) ? 1 : 0).sum()) > 0) {
                this.setBoneMeal(gh, bonemeal - (int)Math.ceil((double)plantsGrown / 6.0));
            }
        }
    }

    private void setBoneMeal(Greenhouse gh, int value) {
        Hopper hopper = this.getHopper(gh);
        if (hopper != null) {
            hopper.getInventory().remove(Material.BONE_MEAL);
            hopper.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BONE_MEAL, value)});
        }
    }

    protected List<GrowthBlock> getAvailableBlocks(Greenhouse gh, boolean ignoreLiquid) {
        BoundingBox bb = gh.getBoundingBox();
        BoundingBox ibb = gh.getInternalBoundingBox();
        ArrayList<GrowthBlock> result = new ArrayList<GrowthBlock>();
        if (gh.getWorld() == null) {
            return result;
        }
        for (double x = ibb.getMinX(); x < ibb.getMaxX(); x += 1.0) {
            for (double z = ibb.getMinZ(); z < ibb.getMaxZ(); z += 1.0) {
                for (double y = ibb.getMaxY() - 1.0; y >= bb.getMinY(); y -= 1.0) {
                    Block b = gh.getWorld().getBlockAt(NumberConversions.floor((double)x), NumberConversions.floor((double)y), NumberConversions.floor((double)z));
                    this.checkBlock(result, b, ignoreLiquid);
                }
            }
        }
        return result;
    }

    private void checkBlock(List<GrowthBlock> result, Block b, boolean ignoreLiquid) {
        if (!ignoreLiquid) {
            if (b.isEmpty() && !b.getRelative(BlockFace.UP).isEmpty()) {
                result.add(new GrowthBlock(b, false));
            }
            if (!b.isEmpty() && !Tag.LEAVES.isTagged((Keyed)b.getType()) && (b.getRelative(BlockFace.UP).isEmpty() || b.getRelative(BlockFace.UP).isPassable() || Tag.LEAVES.isTagged((Keyed)b.getRelative(BlockFace.UP).getType()))) {
                result.add(new GrowthBlock(b.getRelative(BlockFace.UP), true));
            }
        } else if (!b.isEmpty() && !b.isLiquid() && b.getRelative(BlockFace.UP).isLiquid()) {
            result.add(new GrowthBlock(b.getRelative(BlockFace.UP), true));
        }
    }

    private int getBoneMeal(Greenhouse gh) {
        Hopper hopper = this.getHopper(gh);
        if (hopper == null || !hopper.getInventory().contains(Material.BONE_MEAL)) {
            return 0;
        }
        return Arrays.stream(hopper.getInventory().getContents()).filter(Objects::nonNull).filter(i -> i.getType().equals((Object)Material.BONE_MEAL)).mapToInt(ItemStack::getAmount).sum();
    }

    private Hopper getHopper(Greenhouse gh) {
        if (gh.getRoofHopperLocation() == null || !gh.getRoofHopperLocation().getBlock().getType().equals((Object)Material.HOPPER)) {
            gh.setRoofHopperLocation(null);
            return null;
        }
        return (Hopper)gh.getRoofHopperLocation().getBlock().getState();
    }

    public void cancel() {
        this.plantTask.cancel();
        this.mobTask.cancel();
        this.blockTask.cancel();
        this.ecoTask.cancel();
    }

    public record GrowthBlock(Block block, Boolean floor) {
    }
}

