/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.listeners;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Hopper;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Snow;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import world.bentobox.bentobox.util.Util;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.data.Greenhouse;

public class SnowTracker
implements Listener {
    private final Greenhouses addon;
    private final Map<World, BukkitTask> snowTasks;

    public SnowTracker(Greenhouses addon) {
        this.addon = addon;
        this.snowTasks = new HashMap<World, BukkitTask>();
        addon.getActiveWorlds().stream().filter(World::isThundering).forEach(w -> this.snowTasks.putIfAbsent((World)w, Bukkit.getScheduler().runTaskTimer((Plugin)addon.getPlugin(), () -> this.shakeGlobes((World)w), 0L, 100L)));
    }

    private boolean getAirBlocks(Greenhouse gh) {
        if (gh.getLocation() == null) {
            return false;
        }
        boolean createdSnow = false;
        ArrayList<Block> waterBlocks = new ArrayList<Block>();
        BoundingBox bb = gh.getBoundingBox();
        for (int x = (int)bb.getMinX() + 1; x < (int)bb.getMaxX() - 1; ++x) {
            block1: for (int z = (int)bb.getMinZ() + 1; z < (int)bb.getMaxZ() - 1; ++z) {
                for (int y = (int)bb.getMaxY() - 2; y >= (int)bb.getMinY(); --y) {
                    Block b = Objects.requireNonNull(gh.getLocation().getWorld()).getBlockAt(x, y, z);
                    Material type = b.getType();
                    if (!type.equals((Object)Material.AIR) && !type.equals((Object)Material.SNOW)) {
                        if (type.equals((Object)Material.WATER)) {
                            waterBlocks.add(b);
                            continue block1;
                        }
                        if (!(Math.random() < this.addon.getSettings().getSnowDensity()) || b.isLiquid() || !b.getRelative(BlockFace.UP).getType().equals((Object)Material.AIR) && !b.getRelative(BlockFace.UP).getType().equals((Object)Material.SNOW)) continue block1;
                        createdSnow = this.placeSnow(b);
                        continue block1;
                    }
                    b.getWorld().spawnParticle(Particle.SNOWFLAKE, b.getLocation(), 5);
                }
            }
        }
        return createdSnow;
    }

    private boolean placeSnow(Block b) {
        Optional snowCauldron = Enums.getIfPresent(Material.class, (String)"POWDER_SNOW_CAULDRON").toJavaUtil();
        if (snowCauldron.isPresent()) {
            if (b.getType().equals((Object)Material.CAULDRON)) {
                b.setType((Material)snowCauldron.get());
                return true;
            }
            if (b.getType().equals(snowCauldron.get())) {
                return this.incrementLevel(b);
            }
        }
        if (b.getRelative(BlockFace.UP).getType().equals((Object)Material.SNOW)) {
            return this.incrementLevel(b.getRelative(BlockFace.UP));
        }
        b.getRelative(BlockFace.UP).setType(Material.SNOW);
        return true;
    }

    private boolean incrementLevel(Block b) {
        BlockData max2;
        Levelled data;
        BlockData blockData = b.getBlockData();
        if (blockData instanceof Levelled) {
            data = (Levelled)blockData;
            int max2 = data.getMaximumLevel();
            if (data.getLevel() < max2) {
                data.setLevel(data.getLevel() + 1);
                b.setBlockData((BlockData)data);
                return true;
            }
        }
        if ((max2 = b.getBlockData()) instanceof Snow) {
            data = (Snow)max2;
            int max3 = data.getMaximumLayers();
            if (data.getLayers() < max3) {
                data.setLayers(data.getLayers() + 1);
                b.setBlockData((BlockData)data);
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void onBlockFormEvent(BlockFormEvent e) {
        if (e.getNewState().getType().equals((Object)Material.SNOW) && this.addon.getManager().getMap().isAboveGreenhouse(e.getBlock().getLocation())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onWeatherChangeEvent(WeatherChangeEvent e) {
        if (!this.addon.getActiveWorlds().contains(e.getWorld())) {
            return;
        }
        if (e.toWeatherState()) {
            this.startSnow(e.getWorld());
        } else {
            this.stopSnow(e.getWorld());
        }
    }

    private void removeWaterBucketAndShake(Greenhouse g) {
        if (this.getAirBlocks(g) && g.getRoofHopperLocation() != null) {
            Hopper h = (Hopper)g.getRoofHopperLocation().getBlock().getState();
            h.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.WATER_BUCKET)});
            h.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
        }
    }

    private void shakeGlobes(World world) {
        this.addon.getManager().getMap().getGreenhouses().stream().filter(g -> g.getBiomeRecipe().getIceCoverage() > 0).filter(g -> Objects.requireNonNull(Objects.requireNonNull(g.getLocation()).getWorld()).isChunkLoaded((int)g.getBoundingBox().getMaxX() >> 4, (int)g.getBoundingBox().getMaxZ() >> 4) && g.getLocation().getWorld().isChunkLoaded((int)g.getBoundingBox().getMinX() >> 4, (int)g.getBoundingBox().getMinZ() >> 4)).filter(g -> g.getLocation().getWorld().equals((Object)world)).filter(g -> !g.isBroken()).filter(g -> g.getRoofHopperLocation() != null).forEach(g -> Util.getChunkAtAsync((Location)g.getRoofHopperLocation()).thenRun(() -> {
            if (g.getRoofHopperLocation().getBlock().getType().equals((Object)Material.HOPPER) && ((Hopper)g.getRoofHopperLocation().getBlock().getState()).getInventory().contains(Material.WATER_BUCKET)) {
                this.removeWaterBucketAndShake((Greenhouse)g);
            }
        }));
    }

    private void startSnow(World world) {
        this.snowTasks.putIfAbsent(world, Bukkit.getScheduler().runTaskTimer((Plugin)this.addon.getPlugin(), () -> this.shakeGlobes(world), 0L, 100L));
    }

    private void stopSnow(World world) {
        if (this.snowTasks.containsKey(world)) {
            this.snowTasks.get(world).cancel();
            this.snowTasks.remove(world);
        }
    }
}

