/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.listeners;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.data.Greenhouse;

public class GreenhouseGuard
implements Listener {
    private final Greenhouses addon;

    public GreenhouseGuard(Greenhouses addon) {
        this.addon = addon;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFlow(BlockFromToEvent e) {
        if (this.addon.getSettings().isAllowFlowIn() && this.addon.getSettings().isAllowFlowOut()) {
            return;
        }
        if (!this.addon.getActiveWorlds().contains(e.getBlock().getWorld())) {
            return;
        }
        Optional<Greenhouse> to = this.addon.getManager().getMap().getGreenhouse(e.getToBlock().getLocation());
        Optional<Greenhouse> from = this.addon.getManager().getMap().getGreenhouse(e.getBlock().getLocation());
        if (to.isEmpty() && from.isEmpty()) {
            return;
        }
        if (to.isPresent() && from.isPresent() && to.equals(from)) {
            return;
        }
        if (to.isPresent() && this.addon.getSettings().isAllowFlowIn()) {
            return;
        }
        if (from.isPresent() && this.addon.getSettings().isAllowFlowOut()) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPistonPush(BlockPistonExtendEvent e) {
        e.setCancelled(e.getBlocks().stream().map(Block::getLocation).anyMatch(this::inGreenhouse));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPistonPull(BlockPistonRetractEvent e) {
        e.setCancelled(e.getBlocks().stream().map(Block::getLocation).anyMatch(this::inGreenhouse));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent spawnEvent) {
        if (CreatureSpawnEvent.SpawnReason.NATURAL == spawnEvent.getSpawnReason()) {
            spawnEvent.setCancelled(this.inGreenhouse(spawnEvent.getLocation()));
        }
    }

    private boolean inGreenhouse(Location l) {
        return this.addon.getManager().getMap().getGreenhouse(l).map(g -> g.isRoofOrWallBlock(l)).orElse(false);
    }
}

