/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.listeners;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.data.Greenhouse;

public class GreenhouseEvents
implements Listener {
    private static final String BIOME = "[biome]";
    private static List<Biome> NETHER_BIOMES;
    private final Greenhouses addon;

    public GreenhouseEvents(Greenhouses addon) {
        this.addon = addon;
        NETHER_BIOMES = Arrays.asList(Biome.NETHER_WASTES, Biome.WARPED_FOREST, Biome.CRIMSON_FOREST, Biome.SOUL_SAND_VALLEY, Biome.BASALT_DELTAS);
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteractInNether(PlayerBucketEmptyEvent e) {
        if (!e.getBucket().equals((Object)Material.WATER_BUCKET)) {
            return;
        }
        BlockData blockData = e.getBlockClicked().getBlockData();
        Block b = e.getBlockClicked().getRelative(e.getBlockFace());
        if (e.getPlayer().getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            if (!this.addon.getManager().getMap().getGreenhouse(b.getLocation()).map(gh -> gh.getBiomeRecipe().getBiome()).map(NETHER_BIOMES::contains).orElse(true).booleanValue()) {
                if (blockData instanceof Waterlogged) {
                    Waterlogged w = (Waterlogged)blockData;
                    w.setWaterlogged(true);
                    e.getBlockClicked().setBlockData((BlockData)w);
                    return;
                }
                b.setType(Material.WATER);
                return;
            }
        }
        if (e.getPlayer().getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) return;
        if (this.addon.getManager().getMap().getGreenhouse(b.getLocation()).map(gh -> gh.getBiomeRecipe().getBiome()).map(NETHER_BIOMES::contains).orElse(false) == false) return;
        e.setCancelled(true);
        if (e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.WATER_BUCKET)) {
            e.getPlayer().getInventory().getItemInMainHand().setType(Material.BUCKET);
        } else if (e.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)Material.WATER_BUCKET)) {
            e.getPlayer().getInventory().getItemInOffHand().setType(Material.BUCKET);
        }
        b.getWorld().spawnParticle(Particle.SMOKE, b.getLocation(), 10);
        b.getWorld().playSound(b.getLocation(), Sound.ENTITY_GENERIC_EXTINGUISH_FIRE, 1.0f, 5.0f);
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onIceBreak(BlockBreakEvent e) {
        if (!Tag.ICE.isTagged((Keyed)e.getBlock().getType())) {
            return;
        }
        Block b = e.getBlock();
        if (b.getWorld().getEnvironment() == World.Environment.NETHER) {
            if (!this.addon.getManager().getMap().getGreenhouse(b.getLocation()).map(gh -> gh.getBiomeRecipe().getBiome()).map(NETHER_BIOMES::contains).orElse(true).booleanValue()) {
                e.setCancelled(true);
                b.setType(Material.WATER);
                return;
            }
        }
        if (e.getPlayer().getWorld().getEnvironment() == World.Environment.NETHER) return;
        if (this.addon.getManager().getMap().getGreenhouse(b.getLocation()).map(gh -> gh.getBiomeRecipe().getBiome()).map(NETHER_BIOMES::contains).orElse(false) == false) return;
        e.setCancelled(true);
        b.setType(Material.AIR);
        b.getWorld().playSound(b.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        this.handleTransition(User.getInstance((Player)e.getPlayer()), e.getTo(), e.getFrom());
    }

    private void handleTransition(User user, Location toLoc, Location fromLoc) {
        if (user == null) {
            return;
        }
        Optional<Greenhouse> to = this.addon.getManager().getMap().getGreenhouse(toLoc);
        Optional<Greenhouse> from = this.addon.getManager().getMap().getGreenhouse(fromLoc);
        if (to.isEmpty() && from.isEmpty()) {
            return;
        }
        if (to.isPresent() && from.isPresent()) {
            if (!to.get().equals(from.get())) {
                user.sendMessage("greenhouses.event.leaving", new String[]{BIOME, from.get().getBiomeRecipe().getFriendlyName()});
                user.sendMessage("greenhouses.event.entering", new String[]{BIOME, to.get().getBiomeRecipe().getFriendlyName()});
            }
            return;
        }
        if (from.isPresent()) {
            user.sendMessage("greenhouses.event.leaving", new String[]{BIOME, from.get().getBiomeRecipe().getFriendlyName()});
            return;
        }
        user.sendMessage("greenhouses.event.entering", new String[]{BIOME, to.get().getBiomeRecipe().getFriendlyName()});
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        if (e.getFrom() == null || e.getTo() == null) {
            return;
        }
        this.handleTransition(User.getInstance((Player)e.getPlayer()), e.getTo(), e.getFrom());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        User user = User.getInstance((Player)e.getPlayer());
        this.addon.getManager().getMap().getGreenhouse(e.getBlock().getLocation()).filter(g -> g.isRoofOrWallBlock(e.getBlock().getLocation())).ifPresent(g -> {
            if (g.getOriginalBiome() != null) {
                user.sendMessage("greenhouses.event.broke", new String[]{BIOME, Util.prettifyText((String)g.getOriginalBiome().name())});
            }
            this.addon.getManager().removeGreenhouse((Greenhouse)g);
        });
    }
}

