/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.greenhouse;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.greenhouses.greenhouse.MinMaxXZ;
import world.bentobox.greenhouses.greenhouse.Roof;
import world.bentobox.greenhouses.world.AsyncWorldCache;

public class Walls
extends MinMaxXZ {
    public static final List<Material> WALL_BLOCKS = Registry.MATERIAL.stream().filter(Material::isBlock).filter(m -> !m.name().contains("TRAPDOOR")).filter(m -> m.name().contains("DOOR") || m.name().contains("GLASS") && !m.name().contains("GLASS_PANE") || m.equals((Object)Material.HOPPER)).toList();
    private int floor;
    private final AsyncWorldCache cache;

    public Walls(AsyncWorldCache cache) {
        this.cache = cache;
    }

    public CompletableFuture<Walls> findWalls(Roof roof) {
        CompletableFuture<Walls> r = new CompletableFuture<Walls>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BentoBox.getInstance(), () -> this.findWalls(r, roof));
        return r;
    }

    Walls findWalls(CompletableFuture<Walls> r, Roof roof) {
        Location loc = roof.getLocation();
        this.floor = this.getFloorY(roof.getHeight(), roof.getMinX(), roof.getMaxX(), roof.getMinZ(), roof.getMaxZ(), loc.getWorld().getMinHeight());
        WallFinder wf = new WallFinder();
        this.minX = loc.getBlockX();
        this.maxX = loc.getBlockX();
        this.minZ = loc.getBlockZ();
        this.maxZ = loc.getBlockZ();
        do {
            this.lookAround(loc, wf, roof);
        } while (wf.isSearching());
        --this.minX;
        ++this.maxX;
        --this.minZ;
        ++this.maxZ;
        this.floor = this.getFloorY(roof.getHeight(), this.minX, this.maxX, this.minZ, this.maxZ, loc.getWorld().getMinHeight());
        Bukkit.getScheduler().runTask((Plugin)BentoBox.getInstance(), () -> r.complete(this));
        return this;
    }

    void lookAround(Location loc, WallFinder wf, Roof roof) {
        this.minX = loc.getBlockX() - wf.radiusMinX;
        this.maxX = loc.getBlockX() + wf.radiusMaxX;
        this.minZ = loc.getBlockZ() - wf.radiusMinZ;
        this.maxZ = loc.getBlockZ() + wf.radiusMaxZ;
        for (int y = roof.getHeight() - 1; y > this.floor; --y) {
            for (int x = this.minX; x <= this.maxX; ++x) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    if (x > this.minX && x < this.maxX && z > this.minZ && z < this.maxZ) continue;
                    this.lookAtBlockFaces(wf, x, y, z);
                }
            }
        }
        this.analyzeFindings(wf, roof);
    }

    void analyzeFindings(WallFinder wf, Roof roof) {
        if (this.minX < roof.getMinX()) {
            wf.stopMinX = true;
        }
        if (this.maxX > roof.getMaxX()) {
            wf.stopMaxX = true;
        }
        if (this.minZ < roof.getMinZ()) {
            wf.stopMinZ = true;
        }
        if (this.maxZ > roof.getMaxZ()) {
            wf.stopMaxZ = true;
        }
        if (!wf.stopMinX) {
            ++wf.radiusMinX;
        }
        if (!wf.stopMaxX) {
            ++wf.radiusMaxX;
        }
        if (!wf.stopMinZ) {
            ++wf.radiusMinZ;
        }
        if (!wf.stopMaxZ) {
            ++wf.radiusMaxZ;
        }
    }

    void lookAtBlockFaces(WallFinder wf, int x, int y, int z) {
        if (WALL_BLOCKS.contains(this.cache.getBlockType(x + 1, y, z))) {
            wf.stopMaxX = true;
        }
        if (WALL_BLOCKS.contains(this.cache.getBlockType(x - 1, y, z))) {
            wf.stopMinX = true;
        }
        if (WALL_BLOCKS.contains(this.cache.getBlockType(x, y, z - 1))) {
            wf.stopMinZ = true;
        }
        if (WALL_BLOCKS.contains(this.cache.getBlockType(x, y, z + 1))) {
            wf.stopMaxZ = true;
        }
    }

    int getFloorY(int y, int minX, int maxX, int minZ, int maxZ, int minY) {
        int wallBlockCount;
        do {
            wallBlockCount = 0;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!WALL_BLOCKS.contains(this.cache.getBlockType(x, y, z))) continue;
                    ++wallBlockCount;
                }
            }
        } while (y-- > minY && wallBlockCount > 0);
        return y + 1;
    }

    public int getFloor() {
        return this.floor;
    }

    public int getWidth() {
        return Math.abs(this.maxX - this.minX);
    }

    public int getLength() {
        return Math.abs(this.maxZ - this.minZ);
    }

    @Override
    public String toString() {
        return "Walls [minX=" + this.minX + ", maxX=" + this.maxX + ", minZ=" + this.minZ + ", maxZ=" + this.maxZ + ", floor=" + this.floor + "]";
    }

    static class WallFinder {
        int radiusMinX;
        int radiusMaxX;
        int radiusMinZ;
        int radiusMaxZ;
        boolean stopMinX;
        boolean stopMaxX;
        boolean stopMinZ;
        boolean stopMaxZ;

        WallFinder() {
        }

        boolean isSearching() {
            return !this.stopMinX || !this.stopMaxX || !this.stopMinZ || !this.stopMaxZ;
        }

        public String toString() {
            return "WallFinder [radiusMinX=" + this.radiusMinX + ", radiusMaxX=" + this.radiusMaxX + ", radiusMinZ=" + this.radiusMinZ + ", radiusMaxZ=" + this.radiusMaxZ + ", stopMinX=" + this.stopMinX + ", stopMaxX=" + this.stopMaxX + ", stopMinZ=" + this.stopMinZ + ", stopMaxZ=" + this.stopMaxZ + "]";
        }
    }
}

