/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.greenhouse;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.greenhouse.MinMaxXZ;
import world.bentobox.greenhouses.world.AsyncWorldCache;

public class Roof
extends MinMaxXZ {
    private static final List<Material> ROOF_BLOCKS = Registry.MATERIAL.stream().filter(Material::isBlock).filter(m -> Tag.TRAPDOORS.isTagged((Keyed)m) || m.name().contains("GLASS") && !m.name().contains("GLASS_PANE") || m.equals((Object)Material.HOPPER)).toList();
    private final AsyncWorldCache cache;
    private int height;
    private final Location location;
    private boolean roofFound;
    private final Greenhouses addon;
    private final World world;

    public Roof(AsyncWorldCache cache, Location loc, Greenhouses addon) {
        this.cache = cache;
        this.location = loc;
        this.addon = addon;
        this.world = loc.getWorld();
    }

    public boolean roofBlocks(@NonNull Material m) {
        return ROOF_BLOCKS.contains(Objects.requireNonNull(m)) || m.equals((Object)Material.GLOWSTONE) && this.addon.getSettings().isAllowGlowstone() || m.name().endsWith("GLASS_PANE") && this.addon.getSettings().isAllowPanes();
    }

    private void expandCoords(Vector vector) {
        int limit;
        Vector maxx = vector.clone();
        Vector minx = vector.clone();
        Vector maxz = vector.clone();
        Vector minz = vector.clone();
        for (limit = 0; this.roofBlocks(this.cache.getBlockType(maxx)) && limit < 100; ++limit) {
            maxx.add(new Vector(1, 0, 0));
        }
        if (maxx.getBlockX() - 1 > this.maxX) {
            this.maxX = maxx.getBlockX() - 1;
        }
        for (limit = 0; this.roofBlocks(this.cache.getBlockType(minx)) && limit < 100; ++limit) {
            minx.subtract(new Vector(1, 0, 0));
        }
        if (minx.getBlockX() + 1 < this.minX) {
            this.minX = minx.getBlockX() + 1;
        }
        for (limit = 0; this.roofBlocks(this.cache.getBlockType(maxz)) && limit < 100; ++limit) {
            maxz.add(new Vector(0, 0, 1));
        }
        if (maxz.getBlockZ() - 1 > this.maxZ) {
            this.maxZ = maxz.getBlockZ() - 1;
        }
        for (limit = 0; this.roofBlocks(this.cache.getBlockType(minz)) && limit < 100; ++limit) {
            minz.subtract(new Vector(0, 0, 1));
        }
        if (minz.getBlockZ() + 1 < this.minZ) {
            this.minZ = minz.getBlockZ() + 1;
        }
    }

    public CompletableFuture<Boolean> findRoof() {
        CompletableFuture<Boolean> r = new CompletableFuture<Boolean>();
        Vector loc = this.location.toVector();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BentoBox.getInstance(), () -> {
            boolean found = this.findRoof(loc);
            Bukkit.getScheduler().runTask((Plugin)BentoBox.getInstance(), () -> r.complete(found));
        });
        return r;
    }

    boolean findRoof(Vector loc) {
        int maxz;
        int minz;
        int maxx;
        int minx;
        int startY;
        for (int y = startY = loc.getBlockY(); y < this.world.getMaxHeight(); ++y) {
            Vector v = new Vector(loc.getBlockX(), y, loc.getBlockZ());
            if (!this.roofBlocks(this.cache.getBlockType(v))) continue;
            this.roofFound = true;
            loc = v;
            break;
        }
        if (!this.roofFound) {
            loc = this.spiralSearch(loc, startY);
            if (!this.roofFound) {
                return false;
            }
        }
        this.height = loc.getBlockY();
        this.minX = loc.getBlockX();
        this.maxX = loc.getBlockX();
        this.minZ = loc.getBlockZ();
        this.maxZ = loc.getBlockZ();
        this.expandCoords(loc);
        do {
            minx = this.minX;
            maxx = this.maxX;
            minz = this.minZ;
            maxz = this.maxZ;
            for (int x = minx; x <= maxx; ++x) {
                for (int z = minz; z <= maxz; ++z) {
                    this.expandCoords(new Vector(x, loc.getBlockY(), z));
                }
            }
        } while (minx != this.minX || maxx != this.maxX || minz != this.minZ || maxz != this.maxZ);
        return true;
    }

    public int getHeight() {
        return this.height;
    }

    public Location getLocation() {
        return this.location;
    }

    private Vector spiralSearch(Vector v, int startY) {
        for (int radius = 0; radius < 3; ++radius) {
            for (int x = v.getBlockX() - radius; x <= v.getBlockX() + radius; ++x) {
                for (int z = v.getBlockZ() - radius; z <= v.getBlockZ() + radius; ++z) {
                    Optional<Vector> r;
                    if (x > v.getBlockX() - radius && x < v.getBlockX() + radius && z > v.getBlockZ() - radius && z < v.getBlockZ() + radius || !(r = this.checkVertically(x, startY, z)).isPresent()) continue;
                    return r.get();
                }
            }
        }
        return v;
    }

    private Optional<Vector> checkVertically(int x, int startY, int z) {
        if (!this.addon.wallBlocks(this.cache.getBlockType(x, startY, z))) {
            for (int y = startY; y < this.world.getMaxHeight() && !this.roofFound; ++y) {
                if (!this.roofBlocks(this.cache.getBlockType(x, y, z))) continue;
                this.roofFound = true;
                return Optional.of(new Vector(x, y, z));
            }
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return "Roof [height=" + this.height + ", roofFound=" + this.roofFound + ", minX=" + this.minX + ", maxX=" + this.maxX + ", minZ=" + this.minZ + ", maxZ=" + this.maxZ + "]";
    }
}

