/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.greenhouse;

import com.google.common.base.Enums;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Cocoa;
import org.bukkit.block.data.type.GlowLichen;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Piglin;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.util.Util;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.data.Greenhouse;
import world.bentobox.greenhouses.greenhouse.GreenhouseBlockConversions;
import world.bentobox.greenhouses.greenhouse.GreenhouseMob;
import world.bentobox.greenhouses.greenhouse.GreenhousePlant;
import world.bentobox.greenhouses.managers.EcoSystemManager;
import world.bentobox.greenhouses.managers.GreenhouseManager;
import world.bentobox.greenhouses.world.AsyncWorldCache;

public class BiomeRecipe
implements Comparable<BiomeRecipe> {
    private static final String CHANCE_FOR = "% chance for ";
    private Greenhouses addon;
    private Biome type;
    private Material icon;
    private int priority;
    private String name;
    private String friendlyName;
    private static final List<Material> CEILING_PLANTS = new ArrayList<Material>();
    private static final List<BlockFace> ADJ_BLOCKS;
    private static final List<BlockFace> SIDE_BLOCKS;
    private static final List<Material> UNDERWATER_PLANTS;
    private final Map<Material, Integer> requiredBlocks = new EnumMap<Material, Integer>(Material.class);
    private final TreeMap<Double, GreenhousePlant> plantTree = new TreeMap();
    private final TreeMap<Double, GreenhousePlant> underwaterPlants = new TreeMap();
    private final TreeMap<Double, GreenhouseMob> mobTree = new TreeMap();
    private final Multimap<Material, GreenhouseBlockConversions> conversionBlocks = ArrayListMultimap.create();
    private int mobLimit;
    private int waterCoverage;
    private int iceCoverage;
    private int lavaCoverage;
    private String permission = "";
    private final Random random = new Random();
    private int maxMob;

    public BiomeRecipe() {
    }

    public BiomeRecipe(Greenhouses addon, Biome type, int priority) {
        this.addon = addon;
        this.type = type;
        this.priority = priority;
        this.mobLimit = 9;
    }

    private void startupLog(String message) {
        if (this.addon.getSettings().isStartupLog()) {
            this.addon.log(message);
        }
    }

    public void addConvBlocks(Material oldMaterial, Material newMaterial, double convChance, Material localMaterial) {
        double probability = Math.min(convChance / 100.0, 1.0);
        this.conversionBlocks.put((Object)oldMaterial, (Object)new GreenhouseBlockConversions(oldMaterial, newMaterial, probability, localMaterial));
        this.startupLog("   " + convChance + CHANCE_FOR + Util.prettifyText((String)oldMaterial.toString()) + " to convert to " + Util.prettifyText((String)newMaterial.toString()));
    }

    public boolean addMobs(EntityType mobType, double mobProbability, Material mobSpawnOn, @Nullable Consumer<Entity> customizer) {
        double lastProb;
        this.startupLog("   " + mobProbability + CHANCE_FOR + Util.prettifyText((String)mobType.toString()) + " to spawn on " + Util.prettifyText((String)mobSpawnOn.toString()) + ".");
        double probability = mobProbability / 100.0;
        double d = lastProb = this.mobTree.isEmpty() ? 0.0 : this.mobTree.lastKey();
        if (1.0 - lastProb >= probability) {
            this.mobTree.put(lastProb + probability, new GreenhouseMob(mobType, mobSpawnOn, customizer));
            return true;
        }
        this.addon.logError("Mob chances add up to > 100% in " + this.type.name() + " biome recipe! Skipping " + String.valueOf(mobType));
        return false;
    }

    public boolean addMobs(EntityType mobType, double mobProbability, Material mobSpawnOn) {
        return this.addMobs(mobType, mobProbability, mobSpawnOn, null);
    }

    public boolean addPlants(Material plantMaterial, double plantProbability, Material plantGrowOn) {
        double lastProb;
        double probability = plantProbability / 100.0;
        TreeMap<Double, GreenhousePlant> map = UNDERWATER_PLANTS.contains(plantMaterial) ? this.underwaterPlants : this.plantTree;
        double d = lastProb = map.isEmpty() ? 0.0 : map.lastKey();
        if (!(1.0 - lastProb >= probability)) {
            this.addon.logError("Plant chances add up to > 100% in " + this.type.name() + " biome recipe! Skipping " + plantMaterial.toString());
            return false;
        }
        map.put(lastProb + probability, new GreenhousePlant(plantMaterial, plantGrowOn));
        this.startupLog("   " + plantProbability + CHANCE_FOR + Util.prettifyText((String)plantMaterial.toString()) + " to grow on " + Util.prettifyText((String)plantGrowOn.toString()));
        return true;
    }

    public void addReqBlocks(Material blockMaterial, int blockQty) {
        this.requiredBlocks.put(blockMaterial, blockQty);
        this.startupLog("   " + String.valueOf(blockMaterial) + " x " + blockQty);
    }

    public CompletableFuture<Set<GreenhouseManager.GreenhouseResult>> checkRecipe(Greenhouse gh) {
        CompletableFuture<Set<GreenhouseManager.GreenhouseResult>> r = new CompletableFuture<Set<GreenhouseManager.GreenhouseResult>>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.addon.getPlugin(), () -> this.checkRecipeAsync(r, gh));
        return r;
    }

    private Set<GreenhouseManager.GreenhouseResult> checkRecipeAsync(CompletableFuture<Set<GreenhouseManager.GreenhouseResult>> r, Greenhouse gh) {
        AsyncWorldCache cache = new AsyncWorldCache(this.addon, gh.getWorld());
        long area = gh.getArea();
        Map<Material, Integer> blockCount = this.countBlocks(gh, cache);
        Set<GreenhouseManager.GreenhouseResult> result = this.checkRatios(blockCount, area);
        Map<Material, Integer> missingBlocks = this.requiredBlocks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() - blockCount.getOrDefault(e.getKey(), 0)));
        missingBlocks.values().removeIf(v -> v <= 0);
        if (!missingBlocks.isEmpty()) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_INSUFFICIENT_BLOCKS);
            gh.setMissingBlocks(missingBlocks);
        }
        Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> r.complete(result));
        return result;
    }

    private Set<GreenhouseManager.GreenhouseResult> checkRatios(Map<Material, Integer> blockCount, long area) {
        HashSet<GreenhouseManager.GreenhouseResult> result = new HashSet<GreenhouseManager.GreenhouseResult>();
        int water = blockCount.entrySet().stream().filter(en -> ((Material)en.getKey()).equals((Object)Material.WATER) || ((Material)en.getKey()).equals((Object)Material.BUBBLE_COLUMN)).mapToInt(Map.Entry::getValue).sum();
        double waterRatio = (double)water / (double)area * 100.0;
        double lavaRatio = (double)blockCount.getOrDefault(Material.LAVA, 0).intValue() / (double)area * 100.0;
        int ice = blockCount.entrySet().stream().filter(en -> ((Material)en.getKey()).equals((Object)Material.ICE) || ((Material)en.getKey()).equals((Object)Material.BLUE_ICE) || ((Material)en.getKey()).equals((Object)Material.PACKED_ICE)).mapToInt(Map.Entry::getValue).sum();
        double iceRatio = (double)ice / (double)area * 100.0;
        if (this.waterCoverage == 0 && waterRatio > 0.0) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_NO_WATER);
        }
        if (this.lavaCoverage == 0 && lavaRatio > 0.0) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_NO_LAVA);
        }
        if (this.iceCoverage == 0 && iceRatio > 0.0) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_NO_ICE);
        }
        if (this.waterCoverage > 0 && waterRatio < (double)this.waterCoverage) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_INSUFFICIENT_WATER);
        }
        if (this.lavaCoverage > 0 && lavaRatio < (double)this.lavaCoverage) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_INSUFFICIENT_LAVA);
        }
        if (this.iceCoverage > 0 && iceRatio < (double)this.iceCoverage) {
            result.add(GreenhouseManager.GreenhouseResult.FAIL_INSUFFICIENT_ICE);
        }
        return result;
    }

    private Map<Material, Integer> countBlocks(Greenhouse gh, AsyncWorldCache cache) {
        EnumMap<Material, Integer> blockCount = new EnumMap<Material, Integer>(Material.class);
        for (int y = gh.getFloorHeight(); y < gh.getCeilingHeight(); ++y) {
            int x = (int)(gh.getBoundingBox().getMinX() + 1.0);
            while ((double)x < gh.getBoundingBox().getMaxX()) {
                int z = (int)(gh.getBoundingBox().getMinZ() + 1.0);
                while ((double)z < gh.getBoundingBox().getMaxZ()) {
                    Material t = cache.getBlockType(x, y, z);
                    if (!t.equals((Object)Material.AIR)) {
                        blockCount.putIfAbsent(t, 0);
                        blockCount.merge(t, 1, Integer::sum);
                    }
                    ++z;
                }
                ++x;
            }
        }
        return blockCount;
    }

    public void convertBlock(Block b) {
        Material bType = b.getType();
        if (this.conversionBlocks.keySet().contains(bType)) {
            for (GreenhouseBlockConversions conversionOption : this.conversionBlocks.get((Object)bType)) {
                this.rollTheDice(b, conversionOption);
            }
        }
    }

    private void rollTheDice(Block b, GreenhouseBlockConversions conversion_option) {
        if (ThreadLocalRandom.current().nextDouble() < conversion_option.probability()) {
            if (conversion_option.localMaterial() != null) {
                for (BlockFace adjacent_block : ADJ_BLOCKS) {
                    if (b.getRelative(adjacent_block).getType() != conversion_option.localMaterial()) continue;
                    b.setType(conversion_option.newMaterial());
                    break;
                }
            } else {
                b.setType(conversion_option.newMaterial());
            }
        }
    }

    public Biome getBiome() {
        return this.type;
    }

    public boolean getBlockConvert() {
        return !this.conversionBlocks.isEmpty();
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public int getIceCoverage() {
        return this.iceCoverage;
    }

    public Material getIcon() {
        return this.icon;
    }

    public int getLavaCoverage() {
        return this.lavaCoverage;
    }

    public int getMobLimit() {
        return this.mobLimit;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean spawnMob(Block b) {
        if (b.getY() == 0) {
            return false;
        }
        Location spawnLoc = b.getLocation().clone().add(new Vector(0.5, 0.0, 0.5));
        return this.getRandomMob().filter(m -> Optional.of(m.mobSpawnOn()).map(arg_0 -> this.getEffectiveBlock(b.getRelative(BlockFace.DOWN)).equals(arg_0)).orElse(true)).map(m -> {
            Entity entity = b.getWorld().spawnEntity(spawnLoc, m.mobType());
            if (m.customizer() != null) {
                m.customizer().accept(entity);
            }
            this.preventZombie(entity);
            return this.addon.getManager().getMap().getGreenhouse(b.getLocation()).map(gh -> {
                if (!gh.getInternalBoundingBox().contains(entity.getBoundingBox())) {
                    entity.remove();
                    return false;
                }
                return true;
            }).orElse(false);
        }).orElse(false);
    }

    private Material getEffectiveBlock(Block b) {
        if (b.getType() == Material.BUBBLE_COLUMN) {
            return Material.WATER;
        }
        return b.getType();
    }

    private void preventZombie(Entity entity) {
        if (!entity.getWorld().getEnvironment().equals((Object)World.Environment.NORMAL) || !Enums.getIfPresent(EntityType.class, (String)"PIGLIN").isPresent()) {
            return;
        }
        if (entity instanceof Piglin) {
            Piglin p = (Piglin)entity;
            p.setImmuneToZombification(true);
            return;
        }
        if (entity instanceof Hoglin) {
            Hoglin h = (Hoglin)entity;
            h.setImmuneToZombification(true);
        }
    }

    private Optional<GreenhouseMob> getRandomMob() {
        Double key = this.mobTree.ceilingKey(this.random.nextDouble());
        return key == null ? Optional.empty() : Optional.ofNullable(this.mobTree.get(key));
    }

    private Optional<GreenhousePlant> getRandomPlant(boolean underwater) {
        Double key;
        double r = this.random.nextDouble();
        Double d = key = underwater ? this.underwaterPlants.ceilingKey(r) : this.plantTree.ceilingKey(r);
        if (key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(underwater ? this.underwaterPlants.get(key) : this.plantTree.get(key));
    }

    public List<String> getRecipeBlocks() {
        return this.requiredBlocks.entrySet().stream().map(en -> Util.prettifyText((String)((Material)en.getKey()).toString()) + " x " + String.valueOf(en.getValue())).toList();
    }

    public int getWaterCoverage() {
        return this.waterCoverage;
    }

    public boolean growPlant(EcoSystemManager.GrowthBlock block, boolean underwater) {
        Block bl = block.block();
        return this.getRandomPlant(underwater).map(p -> {
            if (bl.getY() != 0 && this.canGrowOn(block, (GreenhousePlant)p) && this.plantIt(bl, (GreenhousePlant)p)) {
                bl.getWorld().spawnParticle(Particle.ASH, bl.getLocation(), 10, 2.0, 2.0, 2.0);
                return true;
            }
            return false;
        }).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean plantIt(Block bl, GreenhousePlant p) {
        boolean underwater = bl.getType().equals((Object)Material.WATER);
        BlockData dataBottom = p.plantMaterial().createBlockData();
        if (dataBottom instanceof Bisected) {
            Bisected bi = (Bisected)dataBottom;
            bi.setHalf(Bisected.Half.BOTTOM);
            BlockData dataTop = p.plantMaterial().createBlockData();
            ((Bisected)dataTop).setHalf(Bisected.Half.TOP);
            if (!bl.getRelative(BlockFace.UP).getType().equals((Object)Material.AIR)) return false;
            bl.setBlockData(dataBottom, false);
            bl.getRelative(BlockFace.UP).setBlockData(dataTop, false);
            return true;
        } else {
            if (p.plantMaterial().equals((Object)Material.GLOW_LICHEN)) {
                return this.placeLichen(bl);
            }
            if (p.plantMaterial().equals((Object)Material.COCOA)) {
                return this.placeCocoa(bl);
            }
            if (dataBottom instanceof Waterlogged) {
                Waterlogged wl = (Waterlogged)dataBottom;
                wl.setWaterlogged(underwater);
                bl.setBlockData((BlockData)wl, false);
                return true;
            } else {
                bl.setBlockData(dataBottom, false);
            }
        }
        return true;
    }

    private boolean placeCocoa(Block bl) {
        Block b = bl.getRelative(BlockFace.DOWN);
        if (!b.getType().equals((Object)Material.JUNGLE_LOG)) {
            return false;
        }
        BlockFace d = null;
        for (BlockFace adj : SIDE_BLOCKS) {
            if (!b.getRelative(adj).getType().equals((Object)Material.AIR)) continue;
            d = adj;
            break;
        }
        if (d == null) {
            return false;
        }
        Block bb = b.getRelative(d);
        bb.setType(Material.COCOA);
        BlockFace opp = d.getOppositeFace();
        BlockData blockData = bb.getBlockData();
        if (blockData instanceof Cocoa) {
            Cocoa v = (Cocoa)blockData;
            v.setFacing(opp);
            bb.setBlockData((BlockData)v);
            bb.getState().setBlockData((BlockData)v);
            bb.getState().update(true);
            return true;
        }
        return false;
    }

    private boolean placeLichen(Block bl) {
        Block b = bl.getRelative(BlockFace.DOWN);
        BlockFace d = null;
        boolean waterLogged = false;
        for (BlockFace adj : ADJ_BLOCKS) {
            Material type = b.getRelative(adj).getType();
            if (!type.equals((Object)Material.AIR) && !type.equals((Object)Material.WATER)) continue;
            d = adj;
            if (!type.equals((Object)Material.WATER)) break;
            waterLogged = true;
            break;
        }
        if (d == null) {
            return false;
        }
        Block bb = b.getRelative(d);
        bb.setType(Material.GLOW_LICHEN);
        BlockFace opp = d.getOppositeFace();
        BlockData blockData = bb.getBlockData();
        if (blockData instanceof GlowLichen) {
            GlowLichen v = (GlowLichen)blockData;
            for (BlockFace f : v.getAllowedFaces()) {
                v.setFace(f, false);
            }
            v.setFace(opp, true);
            v.setWaterlogged(waterLogged);
            bb.setBlockData((BlockData)v);
            bb.getState().setBlockData((BlockData)v);
            bb.getState().update(true);
            return true;
        }
        return false;
    }

    private boolean canGrowOn(EcoSystemManager.GrowthBlock block, GreenhousePlant p) {
        if (CEILING_PLANTS.contains(p.plantMaterial()) && Boolean.TRUE.equals(block.floor())) {
            return false;
        }
        if (block.block().getType().equals((Object)Material.WATER) ? !UNDERWATER_PLANTS.contains(p.plantMaterial()) : UNDERWATER_PLANTS.contains(p.plantMaterial())) {
            return false;
        }
        return p.plantGrownOn().equals((Object)block.block().getRelative(Boolean.TRUE.equals(block.floor()) ? BlockFace.DOWN : BlockFace.UP).getType());
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public void setIcecoverage(int iceCoverage) {
        if (iceCoverage == 0) {
            this.startupLog("   No Ice Allowed");
        } else if (iceCoverage > 0) {
            this.startupLog("   Ice > " + iceCoverage + "%");
        }
        this.iceCoverage = iceCoverage;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public void setLavacoverage(int lavaCoverage) {
        if (lavaCoverage == 0) {
            this.startupLog("   No Lava Allowed");
        } else if (lavaCoverage > 0) {
            this.startupLog("   Lava > " + lavaCoverage + "%");
        }
        this.lavaCoverage = lavaCoverage;
    }

    public void setMobLimit(int mobLimit) {
        this.mobLimit = mobLimit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setType(Biome type) {
        this.type = type;
    }

    public void setWatercoverage(int waterCoverage) {
        if (waterCoverage == 0) {
            this.startupLog("   No Water Allowed");
        } else if (waterCoverage > 0) {
            this.startupLog("   Water > " + waterCoverage + "%");
        }
        this.waterCoverage = waterCoverage;
    }

    @Override
    public int compareTo(BiomeRecipe o) {
        return Integer.compare(o.getPriority(), this.getPriority());
    }

    public boolean noMobs() {
        return this.mobTree.isEmpty();
    }

    public Set<EntityType> getMobTypes() {
        return this.mobTree.values().stream().map(GreenhouseMob::mobType).collect(Collectors.toSet());
    }

    public void setMaxMob(int maxMob) {
        this.maxMob = maxMob;
    }

    public int getMaxMob() {
        return this.maxMob;
    }

    static {
        CEILING_PLANTS.add(Material.VINE);
        Enums.getIfPresent(Material.class, (String)"SPORE_BLOSSOM").toJavaUtil().ifPresent(CEILING_PLANTS::add);
        Enums.getIfPresent(Material.class, (String)"CAVE_VINES_PLANT").toJavaUtil().ifPresent(CEILING_PLANTS::add);
        Enums.getIfPresent(Material.class, (String)"TWISTING_VINES_PLANT").toJavaUtil().ifPresent(CEILING_PLANTS::add);
        Enums.getIfPresent(Material.class, (String)"WEEPING_VINES_PLANT").toJavaUtil().ifPresent(CEILING_PLANTS::add);
        ADJ_BLOCKS = Arrays.asList(BlockFace.DOWN, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.UP, BlockFace.WEST);
        SIDE_BLOCKS = Arrays.asList(BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST);
        ArrayList<Material> m = new ArrayList<Material>();
        Arrays.stream(Material.values()).filter(c -> c.name().contains("CORAL")).forEach(m::add);
        m.add(Material.SEA_LANTERN);
        m.add(Material.SEA_PICKLE);
        m.add(Material.SEAGRASS);
        m.add(Material.KELP);
        m.add(Material.GLOW_LICHEN);
        UNDERWATER_PLANTS = Collections.unmodifiableList(m);
    }
}

