/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.data;

import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.objects.Table;
import world.bentobox.greenhouses.greenhouse.BiomeRecipe;
import world.bentobox.greenhouses.greenhouse.Walls;
import world.bentobox.greenhouses.managers.RecipeManager;

@Table(name="Greenhouses")
public class Greenhouse
implements DataObject {
    @Expose
    private String uniqueId = UUID.randomUUID().toString();
    @Expose
    private Location location;
    @Expose
    private BoundingBox boundingBox;
    @Expose
    private Biome originalBiome;
    @Expose
    private Location roofHopperLocation;
    @Expose
    private String biomeRecipeName;
    private boolean broken;
    private Map<Material, Integer> missingBlocks;

    public Greenhouse() {
    }

    public Greenhouse(World world, Walls walls, int ceilingHeight) {
        this.location = new Location(world, (double)walls.getMinX(), (double)walls.getFloor(), (double)walls.getMinZ());
        Location location2 = new Location(world, (double)walls.getMaxX() + 1.0, (double)ceilingHeight + 1.0, (double)walls.getMaxZ() + 1.0);
        this.boundingBox = BoundingBox.of((Location)this.location, (Location)location2);
    }

    public @Nullable String getBiomeRecipeName() {
        return this.biomeRecipeName;
    }

    public int getCeilingHeight() {
        return (int)this.boundingBox.getMaxY();
    }

    public int getFloorHeight() {
        return this.location.getBlockY();
    }

    public @Nullable Location getLocation() {
        return this.location;
    }

    public @Nullable Biome getOriginalBiome() {
        return this.originalBiome;
    }

    public @Nullable Location getRoofHopperLocation() {
        return this.roofHopperLocation;
    }

    public @NonNull String getUniqueId() {
        return this.uniqueId;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBiomeRecipeName(String biomeRecipeName) {
        this.biomeRecipeName = biomeRecipeName;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setOriginalBiome(Biome originalBiome) {
        this.originalBiome = originalBiome;
    }

    public void setRoofHopperLocation(@Nullable Vector v) {
        this.roofHopperLocation = v == null || this.getWorld() == null ? null : v.toLocation(this.getWorld());
    }

    public @NonNull BoundingBox getBoundingBox() {
        return Objects.requireNonNull(this.boundingBox);
    }

    public @NonNull BoundingBox getInternalBoundingBox() {
        return this.getBoundingBox().clone().expand(-1.0);
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public int getArea() {
        return ((int)this.boundingBox.getWidthX() - 2) * ((int)this.boundingBox.getWidthZ() - 2);
    }

    public @Nullable World getWorld() {
        return this.getLocation() == null ? null : this.getLocation().getWorld();
    }

    public boolean contains(Location location2) {
        return this.getLocation() != null && this.getLocation().getWorld() != null && this.getLocation().getWorld().equals((Object)location2.getWorld()) && this.getBoundingBox().contains(location2.toVector());
    }

    public void setBiomeRecipe(BiomeRecipe greenhouseRecipe) {
        this.biomeRecipeName = greenhouseRecipe.getName();
    }

    public @NonNull BiomeRecipe getBiomeRecipe() {
        return RecipeManager.getBiomeRecipies(this.biomeRecipeName).orElse(new BiomeRecipe());
    }

    public void setMissingBlocks(Map<Material, Integer> missingBlocks) {
        this.missingBlocks = missingBlocks;
    }

    public @NonNull Map<Material, Integer> getMissingBlocks() {
        return Objects.requireNonNullElseGet(this.missingBlocks, HashMap::new);
    }

    public boolean isRoofOrWallBlock(Location l) {
        BoundingBox bb = this.getBoundingBox();
        return l.getBlockY() > this.getFloorHeight() && (l.getBlockY() == this.getCeilingHeight() - 1 || l.getBlockX() == (int)bb.getMinX() || l.getBlockX() == (int)bb.getMaxX() - 1 || l.getBlockZ() == (int)bb.getMinZ() || l.getBlockZ() == (int)bb.getMaxZ() - 1);
    }
}

