/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.World;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.configuration.Config;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.greenhouses.Settings;
import world.bentobox.greenhouses.greenhouse.Walls;
import world.bentobox.greenhouses.managers.GreenhouseManager;
import world.bentobox.greenhouses.managers.RecipeManager;
import world.bentobox.greenhouses.ui.user.UserCommand;

public class Greenhouses
extends Addon {
    private GreenhouseManager manager;
    private Settings settings;
    private RecipeManager recipes;
    private final List<World> activeWorlds = new ArrayList<World>();
    public static final Flag GREENHOUSES = new Flag.Builder("GREENHOUSE", Material.GREEN_STAINED_GLASS).mode(Flag.Mode.BASIC).type(Flag.Type.PROTECTION).build();
    private final Config<Settings> config = new Config((Addon)this, Settings.class);

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveResource("biomes.yml", false);
        this.settings = (Settings)this.config.loadConfigObject();
        if (this.settings == null) {
            this.logError("Settings did not load correctly - disabling Greenhouses - please check config.yml");
            this.setState(Addon.State.DISABLED);
            return;
        }
        this.config.saveConfigObject((Object)this.settings);
        this.recipes = new RecipeManager(this);
        this.manager = new GreenhouseManager(this);
        this.activeWorlds.clear();
        this.getPlugin().getAddonsManager().getGameModeAddons().stream().filter(gm -> this.settings.getGameModes().stream().anyMatch(gm.getDescription().getName()::equalsIgnoreCase)).forEach(gm -> {
            gm.getPlayerCommand().ifPresent(playerCmd -> new UserCommand(this, (CompositeCommand)playerCmd));
            this.log("Hooking into " + gm.getDescription().getName());
            this.activeWorlds.add(gm.getOverWorld());
        });
        if (this.activeWorlds.isEmpty()) {
            this.logError("Greenhouses could not hook into any game modes! Check config.yml");
            this.setState(Addon.State.DISABLED);
        } else {
            this.registerListener(this.manager);
            this.getPlugin().getFlagsManager().registerFlag((Addon)this, GREENHOUSES);
        }
    }

    public void onDisable() {
        if (this.manager != null && this.manager.getEcoMgr() != null) {
            this.manager.getEcoMgr().cancel();
        }
    }

    public GreenhouseManager getManager() {
        return this.manager;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public RecipeManager getRecipes() {
        return this.recipes;
    }

    public List<World> getActiveWorlds() {
        return this.activeWorlds;
    }

    public boolean wallBlocks(Material m) {
        return Walls.WALL_BLOCKS.contains(m) || m.equals((Object)Material.GLOWSTONE) && this.getSettings().isAllowGlowstone() || m.name().endsWith("GLASS_PANE") && this.getSettings().isAllowPanes();
    }
}

