/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.border.listeners;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;
import world.bentobox.border.Border;
import world.bentobox.border.listeners.BorderShower;

public class ShowVirtualWorldBorder
implements BorderShower {
    private final Border addon;

    public ShowVirtualWorldBorder(Border addon) {
        this.addon = addon;
    }

    @Override
    public void showBorder(Player player, Island island) {
        if (this.addon.getSettings().getDisabledGameModes().contains(island.getGameMode()) || !Objects.requireNonNull(User.getInstance((Player)player)).getMetaData("Border_state").map(MetaDataValue::asBoolean).orElse(this.addon.getSettings().isShowByDefault()).booleanValue()) {
            return;
        }
        if (player.getWorld().getEnvironment() == World.Environment.NETHER && !this.addon.getPlugin().getIWM().isIslandNether(player.getWorld())) {
            return;
        }
        Location l = island.getProtectionCenter().toVector().toLocation(player.getWorld());
        WorldBorder wb = Bukkit.createWorldBorder();
        wb.setCenter(l);
        double size = Math.min((double)island.getRange() * 2.0, (double)(island.getProtectionRange() + this.addon.getSettings().getBarrierOffset()) * 2.0);
        wb.setSize(size);
        wb.setWarningDistance(0);
        player.setWorldBorder(wb);
    }

    @Override
    public void hideBorder(User user) {
        user.getPlayer().setWorldBorder(null);
    }

    @Override
    public void teleportPlayer(Player p) {
        this.addon.getIslands().getIslandAt(p.getLocation()).ifPresent(i -> {
            Vector unitVector = i.getCenter().toVector().subtract(p.getLocation().toVector()).normalize().multiply(new Vector(1, 0, 1));
            Location to = p.getLocation().toVector().add(unitVector).toLocation(p.getWorld());
            to.setPitch(p.getLocation().getPitch());
            to.setYaw(p.getLocation().getYaw());
            Util.teleportAsync((Entity)p, (Location)to, (PlayerTeleportEvent.TeleportCause)PlayerTeleportEvent.TeleportCause.PLUGIN);
        });
    }
}

