/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.border.commands;

import java.util.List;
import org.bukkit.World;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;
import world.bentobox.border.Border;
import world.bentobox.border.commands.BorderTypeCommand;

public class IslandBorderCommand
extends CompositeCommand {
    public static final String BORDER_COMMAND_PERM = "border.toggle";
    private Border addon;
    private Island island;

    public IslandBorderCommand(Border addon, CompositeCommand parent, String label) {
        super((Addon)addon, parent, label, new String[0]);
        this.addon = addon;
    }

    public void setup() {
        this.setPermission(BORDER_COMMAND_PERM);
        this.setDescription("border.toggle.description");
        this.setOnlyPlayer(true);
        this.setConfigurableRankCommand();
        new BorderTypeCommand((Border)this.getAddon(), this, "type");
    }

    public boolean canExecute(User user, String label, List<String> args) {
        if (!this.getWorld().equals((Object)Util.getWorld((World)user.getWorld()))) {
            user.sendMessage("general.errors.wrong-world", new String[0]);
            return false;
        }
        this.island = this.addon.getIslands().getIslandAt(user.getLocation()).orElse(null);
        return this.island != null;
    }

    public boolean execute(User user, String label, List<String> args) {
        boolean on = user.getMetaData("Border_state").map(MetaDataValue::asBoolean).orElse(this.addon.getSettings().isShowByDefault());
        if (on) {
            user.sendMessage("border.toggle.border-off", new String[0]);
            user.putMetaData("Border_state", new MetaDataValue((Object)false));
            this.addon.getPlayers().savePlayer(user.getUniqueId());
            this.addon.getBorderShower().hideBorder(user);
        } else {
            user.sendMessage("border.toggle.border-on", new String[0]);
            user.putMetaData("Border_state", new MetaDataValue((Object)true));
            this.addon.getPlayers().savePlayer(user.getUniqueId());
            if (this.island != null) {
                this.addon.getBorderShower().showBorder(user.getPlayer(), this.island);
            }
        }
        return true;
    }
}

