/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.border.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.World;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;
import world.bentobox.border.Border;
import world.bentobox.border.BorderType;

public final class BorderTypeCommand
extends CompositeCommand {
    private final Border addon;
    private Island island;
    private final List<String> availableTypes;

    public BorderTypeCommand(Border addon, CompositeCommand parent, String commandLabel) {
        super((Addon)addon, parent, commandLabel, new String[0]);
        this.addon = addon;
        this.availableTypes = addon.getAvailableBorderTypesView().stream().map(BorderType::getCommandLabel).toList();
    }

    public void setup() {
        this.setPermission("border." + this.getLabel());
        this.setDescription("border.set-type.description");
        this.setOnlyPlayer(true);
    }

    public boolean canExecute(User user, String label, List<String> args) {
        if (!this.getWorld().equals((Object)Util.getWorld((World)user.getWorld()))) {
            user.sendMessage("general.errors.wrong-world", new String[0]);
            return false;
        }
        this.island = this.getIslands().getIsland(this.getWorld(), user);
        return this.island != null;
    }

    public boolean execute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            this.toggleBorderType(user);
            return true;
        }
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        if (this.availableTypes.stream().anyMatch(args.get(0)::equalsIgnoreCase)) {
            this.changeBorderTypeTo(user, args.get(0));
            return true;
        }
        user.sendMessage("border.set-type.error-unavailable-type", new String[0]);
        return false;
    }

    private void toggleBorderType(User user) {
        MetaDataValue metaDataValue = user.getMetaData("Border_bordertype").orElse(new MetaDataValue((Object)this.addon.getSettings().getType().getId()));
        BorderType borderType = BorderType.fromId(metaDataValue.asByte()).orElse(this.addon.getSettings().getType());
        List<BorderType> borderTypes = Arrays.stream(BorderType.values()).toList();
        int index = borderTypes.indexOf((Object)borderType);
        if (index + 1 >= borderTypes.size()) {
            this.changeBorderTypeTo(user, borderTypes.get(0).getCommandLabel());
        } else {
            this.changeBorderTypeTo(user, borderTypes.get(index + 1).getCommandLabel());
        }
    }

    private void changeBorderTypeTo(User user, String newBorderType) {
        BorderType.fromCommandLabel(newBorderType).map(BorderType::getId).map(MetaDataValue::new).ifPresentOrElse(newTypeId -> {
            this.addon.getBorderShower().hideBorder(user);
            user.putMetaData("Border_bordertype", newTypeId);
            this.addon.getBorderShower().showBorder(user.getPlayer(), this.island);
            user.sendMessage("border.set-type.changed", new String[]{"[type]", newBorderType});
        }, () -> this.addon.logError("Unknown newBorderType " + newBorderType));
    }

    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        return Optional.of(this.availableTypes);
    }
}

