/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.border;

import java.util.HashSet;
import java.util.Set;
import world.bentobox.bentobox.api.configuration.ConfigComment;
import world.bentobox.bentobox.api.configuration.ConfigEntry;
import world.bentobox.bentobox.api.configuration.ConfigObject;
import world.bentobox.bentobox.api.configuration.StoreAt;
import world.bentobox.border.BorderType;

@StoreAt(filename="config.yml", path="addons/Border")
public class Settings
implements ConfigObject {
    @ConfigComment.Line(value={@ConfigComment(value="Border addon configuration file"), @ConfigComment(value="See the documentation at https://docs.bentobox.world/en/latest/addons/Border/"), @ConfigComment(value=""), @ConfigComment(value="This list stores GameModes in which Border addon should not work."), @ConfigComment(value="To disable addon it is necessary to write its name in new line that starts with -. Example:"), @ConfigComment(value="disabled-gamemodes:"), @ConfigComment(value=" - BSkyBlock")})
    @ConfigEntry(path="disabled-gamemodes")
    private Set<String> disabledGameModes = new HashSet<String>();
    @ConfigComment.Line(value={@ConfigComment(value=""), @ConfigComment(value="Border type. Options are VANILLA, which uses the vanillia-style board or BARRIER,"), @ConfigComment(value="which uses particles and barrier blocks. If players have permission to use the barrier type"), @ConfigComment(value="they may override this option. If they do not have permission or lose the permission"), @ConfigComment(value="then this setting will be used.")})
    @ConfigEntry(path="type")
    private BorderType type = BorderType.VANILLA;
    @ConfigComment.Line(value={@ConfigComment(value=""), @ConfigComment(value="Teleport players back inside the border if they somehow get outside."), @ConfigComment(value="This will teleport players back inside if they toggle the border with a command.")})
    @ConfigEntry(path="return-teleport")
    private boolean returnTeleport = true;
    @ConfigComment.Line(value={@ConfigComment(value=""), @ConfigComment(value="Place a safety block under the player if they get teleported back into a non-safe spot.")})
    @ConfigEntry(path="return-teleport-safety-block")
    private boolean returnTeleportBlock = true;
    @ConfigComment.Line(value={@ConfigComment(value=""), @ConfigComment(value="Barrier blocks on/off. Only applies if the border type is BARRIER."), @ConfigComment(value="If false, the border is indicated by particles only.")})
    @ConfigEntry(path="use-barrier-blocks")
    private boolean useBarrierBlocks = true;
    @ConfigComment.Line(value={@ConfigComment(value=""), @ConfigComment(value="Turn on barrier by default.")})
    @ConfigEntry(path="show-by-default")
    private boolean showByDefault = true;
    @ConfigComment.Line(value={@ConfigComment(value=""), @ConfigComment(value="Only applies if VANILLA type isn't used."), @ConfigComment(value="Show max-protection range border. This is a visual border only and not a barrier."), @ConfigComment(value="This setting is useful for game modes where the protection range can move around, like Boxed")})
    @ConfigEntry(path="show-max-border")
    private boolean showMaxBorder = true;
    @ConfigComment.Line(value={@ConfigComment(value=""), @ConfigComment(value="Only applies if VANILLA type isn't used."), @ConfigComment(value="Enables/disables all types of wall particles shown by the addon")})
    @ConfigEntry(path="show-particles")
    private boolean showParticles = true;
    @ConfigComment.Line(value={@ConfigComment(value=""), @ConfigComment(value="Barrier offset."), @ConfigComment(value="The barrier normally occurs at the protection range limit but this value extends it outwards."), @ConfigComment(value="This does not extend the protection range, but will enable players to go outside their protected area."), @ConfigComment(value="The barrier will not go further than the island distance. Minimum and default value is 0.")})
    @ConfigEntry(path="barrier-offset")
    private int barrierOffset = 0;

    public void setDisabledGameModes(Set<String> disabledGameModes) {
        this.disabledGameModes = disabledGameModes;
    }

    public Set<String> getDisabledGameModes() {
        return this.disabledGameModes;
    }

    public boolean isUseBarrierBlocks() {
        return this.useBarrierBlocks;
    }

    public void setUseBarrierBlocks(boolean useBarrierBlocks) {
        this.useBarrierBlocks = useBarrierBlocks;
    }

    public boolean isShowByDefault() {
        return this.showByDefault;
    }

    public void setShowByDefault(boolean showByDefault) {
        this.showByDefault = showByDefault;
    }

    public boolean isShowMaxBorder() {
        return this.showMaxBorder;
    }

    public void setShowMaxBorder(boolean showMaxBorder) {
        this.showMaxBorder = showMaxBorder;
    }

    public boolean isReturnTeleport() {
        return this.returnTeleport;
    }

    public void setReturnTeleport(boolean returnTeleport) {
        this.returnTeleport = returnTeleport;
    }

    public boolean isShowParticles() {
        return this.showParticles;
    }

    public void setShowParticles(boolean showParticles) {
        this.showParticles = showParticles;
    }

    public BorderType getType() {
        if (this.type == null) {
            this.type = BorderType.VANILLA;
        }
        return this.type;
    }

    public void setType(BorderType type) {
        this.type = type;
    }

    public int getBarrierOffset() {
        if (this.barrierOffset < 0) {
            this.barrierOffset = 0;
        }
        return this.barrierOffset;
    }

    public void setBarrierOffset(int barrierOffset) {
        this.barrierOffset = barrierOffset;
        this.getBarrierOffset();
    }

    public boolean isReturnTeleportBlock() {
        return this.returnTeleportBlock;
    }

    public void setReturnTeleportBlock(boolean returnTeleportBlock) {
        this.returnTeleportBlock = returnTeleportBlock;
    }
}

