/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.border;

import java.util.Optional;
import org.bukkit.entity.Player;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.border.Border;
import world.bentobox.border.BorderType;
import world.bentobox.border.listeners.BorderShower;

public final class PerPlayerBorderProxy
implements BorderShower {
    public static final String BORDER_BORDERTYPE_META_DATA = "Border_bordertype";
    private final Border addon;
    private final BorderShower customBorder;
    private final BorderShower vanillaBorder;

    public PerPlayerBorderProxy(Border addon, BorderShower customBorder, BorderShower vanillaBorder) {
        this.addon = addon;
        this.customBorder = customBorder;
        this.vanillaBorder = vanillaBorder;
    }

    @Override
    public void showBorder(Player player, Island island) {
        User user = User.getInstance((Player)player);
        BorderShower border = this.getBorder(user);
        border.showBorder(player, island);
    }

    @Override
    public void hideBorder(User user) {
        BorderShower border = this.getBorder(user);
        border.hideBorder(user);
    }

    @Override
    public void clearUser(User user) {
        BorderShower border = this.getBorder(user);
        border.clearUser(user);
    }

    @Override
    public void refreshView(User user, Island island) {
        BorderShower border = this.getBorder(user);
        border.refreshView(user, island);
    }

    private BorderShower getBorder(User user) {
        BorderType borderType = this.getBorderType(user);
        return switch (borderType) {
            default -> throw new MatchException(null, null);
            case BorderType.BARRIER -> this.customBorder;
            case BorderType.VANILLA -> this.vanillaBorder;
        };
    }

    private BorderType getBorderType(User user) {
        Optional<Byte> userTypeId = user.getMetaData(BORDER_BORDERTYPE_META_DATA).map(MetaDataValue::asByte);
        if (userTypeId.isEmpty()) {
            return this.getDefaultBorderType();
        }
        Optional<BorderType> borderType = BorderType.fromId(userTypeId.get());
        if (borderType.isEmpty() || !this.addon.getAvailableBorderTypesView().contains((Object)borderType.get())) {
            return this.getDefaultBorderType();
        }
        return borderType.get();
    }

    private BorderType getDefaultBorderType() {
        return this.addon.getSettings().getType();
    }

    @Override
    public void teleportPlayer(Player player) {
        if (this.getBorderType(User.getInstance((Player)player)) == BorderType.BARRIER) {
            this.customBorder.teleportPlayer(player);
        } else {
            this.vanillaBorder.teleportPlayer(player);
        }
    }
}

