/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.border;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.bukkit.World;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.configuration.Config;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.util.Util;
import world.bentobox.border.BorderType;
import world.bentobox.border.PerPlayerBorderProxy;
import world.bentobox.border.Settings;
import world.bentobox.border.commands.BorderTypeCommand;
import world.bentobox.border.commands.IslandBorderCommand;
import world.bentobox.border.listeners.BorderShower;
import world.bentobox.border.listeners.PlayerListener;
import world.bentobox.border.listeners.ShowBarrier;
import world.bentobox.border.listeners.ShowVirtualWorldBorder;

public class Border
extends Addon {
    private BorderShower borderShower;
    private Settings settings;
    private Config<Settings> config = new Config((Addon)this, Settings.class);
    private @NonNull List<GameModeAddon> gameModes = new ArrayList<GameModeAddon>();
    private final Set<BorderType> availableBorderTypes = EnumSet.of(BorderType.VANILLA, BorderType.BARRIER);

    public void onLoad() {
        this.saveDefaultConfig();
        this.loadSettings();
    }

    public void onEnable() {
        this.gameModes.clear();
        this.getPlugin().getAddonsManager().getGameModeAddons().forEach(gameModeAddon -> {
            if (!this.settings.getDisabledGameModes().contains(gameModeAddon.getDescription().getName())) {
                this.gameModes.add((GameModeAddon)gameModeAddon);
                this.log("Border hooking into " + gameModeAddon.getDescription().getName());
                gameModeAddon.getPlayerCommand().ifPresent(c -> new IslandBorderCommand(this, (CompositeCommand)c, "border"));
                gameModeAddon.getPlayerCommand().ifPresent(c -> new BorderTypeCommand(this, (CompositeCommand)c, "bordertype"));
            }
        });
        if (!this.gameModes.isEmpty()) {
            this.borderShower = this.createBorder();
            this.registerListener(new PlayerListener(this));
            this.registerPlaceholders();
        }
    }

    public void onDisable() {
    }

    private BorderShower createBorder() {
        ShowBarrier customBorder = new ShowBarrier(this);
        ShowVirtualWorldBorder wbapiBorder = new ShowVirtualWorldBorder(this);
        return new PerPlayerBorderProxy(this, customBorder, wbapiBorder);
    }

    public BorderShower getBorderShower() {
        return this.borderShower;
    }

    private void loadSettings() {
        this.settings = (Settings)this.config.loadConfigObject();
        if (this.settings == null) {
            this.logError("Border settings could not load! Addon disabled.");
            this.setState(Addon.State.DISABLED);
            return;
        }
        this.config.saveConfigObject((Object)this.settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean inGameWorld(World world) {
        return this.gameModes.stream().anyMatch(gm -> gm.inWorld(Util.getWorld((World)world)));
    }

    public Set<BorderType> getAvailableBorderTypesView() {
        return Collections.unmodifiableSet(this.availableBorderTypes);
    }

    private void registerPlaceholders() {
        if (this.getPlugin().getPlaceholdersManager() == null) {
            return;
        }
        this.getPlugin().getPlaceholdersManager().registerPlaceholder((Addon)this, "type", user -> BorderType.fromId(user.getMetaData("Border_bordertype").orElse(new MetaDataValue((Object)this.getSettings().getType().getId())).asByte()).orElse(this.getSettings().getType()).getCommandLabel());
    }
}

