/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.acidisland.world;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.Vector;
import org.bukkit.util.noise.PerlinOctaveGenerator;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.acidisland.AcidIsland;

public class ChunkGeneratorWorld
extends ChunkGenerator {
    private final AcidIsland addon;
    private final Random rand = new Random();
    private final Map<World.Environment, WorldConfig> seaHeight = new EnumMap<World.Environment, WorldConfig>(World.Environment.class);
    private final Map<Vector, Material> roofChunk = new HashMap<Vector, Material>();
    private static final Map<World.Environment, FloorMats> floorMats = Map.of(World.Environment.NETHER, new FloorMats(Material.NETHERRACK, Material.SOUL_SAND), World.Environment.NORMAL, new FloorMats(Material.SANDSTONE, Material.SAND), World.Environment.THE_END, new FloorMats(Material.END_STONE, Material.END_STONE));
    private PerlinOctaveGenerator gen;

    public ChunkGeneratorWorld(AcidIsland addon) {
        this.addon = addon;
        this.seaHeight.put(World.Environment.NORMAL, new WorldConfig(addon.getSettings().getSeaHeight(), addon.getSettings().getWaterBlock()));
        this.seaHeight.put(World.Environment.NETHER, new WorldConfig(addon.getSettings().getNetherSeaHeight(), addon.getSettings().getNetherWaterBlock()));
        this.seaHeight.put(World.Environment.THE_END, new WorldConfig(addon.getSettings().getEndSeaHeight(), addon.getSettings().getEndWaterBlock()));
        this.rand.setSeed(System.currentTimeMillis());
        this.gen = new PerlinOctaveGenerator((long)((double)this.rand.nextLong() * this.rand.nextGaussian()), 8);
        this.gen.setScale(0.03333333333333333);
        this.makeNetherRoof();
    }

    public void generateNoise(@NonNull WorldInfo worldInfo, @NonNull Random random, int chunkX, int chunkZ, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ChunkGenerator.ChunkData chunkData) {
        WorldConfig wc = this.seaHeight.get(worldInfo.getEnvironment());
        int sh = wc.seaHeight();
        if (sh > worldInfo.getMinHeight()) {
            chunkData.setRegion(0, worldInfo.getMinHeight() + 1, 0, 16, sh + 1, 16, wc.waterBlock());
            if (this.addon.getSettings().isOceanFloor()) {
                chunkData.setRegion(0, worldInfo.getMinHeight(), 0, 16, worldInfo.getMinHeight() + 1, 16, Material.BEDROCK);
                this.addNoise(worldInfo, chunkX, chunkZ, chunkData);
            }
        }
        if (worldInfo.getEnvironment().equals((Object)World.Environment.NETHER) && this.addon.getSettings().isNetherRoof()) {
            this.roofChunk.forEach((k, v) -> chunkData.setBlock(k.getBlockX(), worldInfo.getMaxHeight() + k.getBlockY(), k.getBlockZ(), v));
        }
    }

    private void addNoise(@NonNull WorldInfo worldInfo, int chunkX, int chunkZ, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ChunkGenerator.ChunkData chunkData) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int n = (int)(25.0 * this.gen.noise((double)(chunkX << 4) + (double)x, (double)(chunkZ << 4) + (double)z, 0.5, 0.5, true));
                for (int y = worldInfo.getMinHeight(); y < 25 + n; ++y) {
                    chunkData.setBlock(x, y, z, this.rand.nextBoolean() ? floorMats.get(worldInfo.getEnvironment()).top() : floorMats.get(worldInfo.getEnvironment()).base());
                }
            }
        }
        chunkData.setRegion(0, worldInfo.getMinHeight(), 0, 16, worldInfo.getMinHeight() + 1, 16, Material.BEDROCK);
    }

    public boolean shouldGenerateNoise() {
        return false;
    }

    public boolean shouldGenerateSurface() {
        return this.addon.getSettings().isOceanFloor();
    }

    public boolean shouldGenerateCaves() {
        return this.addon.getSettings().isMakeCaves();
    }

    public boolean shouldGenerateDecorations() {
        return this.addon.getSettings().isMakeDecorations();
    }

    public boolean shouldGenerateMobs() {
        return true;
    }

    public boolean shouldGenerateStructures() {
        return this.addon.getSettings().isMakeStructures();
    }

    public BiomeProvider getDefaultBiomeProvider(WorldInfo worldInfo) {
        return this.addon.getBiomeProvider();
    }

    public boolean canSpawn(World world, int x, int z) {
        return true;
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        return Collections.emptyList();
    }

    private void makeNetherRoof() {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double r;
                int y;
                this.setBlock(x, -1, z, Material.BEDROCK);
                for (y = 2; y < 5; ++y) {
                    r = this.gen.noise((double)x, (double)(-y), (double)z, 0.5, 0.5);
                    if (!(r > 0.0)) continue;
                    this.setBlock(x, -y, z, Material.BEDROCK);
                }
                for (y = 5; y < 8; ++y) {
                    r = this.gen.noise((double)x, (double)(-y), (double)z, 0.5, 0.5);
                    if (r > 0.0) {
                        this.setBlock(x, -y, z, Material.NETHERRACK);
                        continue;
                    }
                    this.setBlock(x, -y, z, Material.AIR);
                }
                double r2 = this.gen.noise((double)x, -8.0, (double)z, (double)this.rand.nextFloat(), (double)this.rand.nextFloat());
                if (r2 > 0.5) {
                    switch (this.rand.nextInt(4)) {
                        case 1: {
                            this.setBlock(x, -8, z, Material.GLOWSTONE);
                            if (x >= 14 || z >= 14) break;
                            this.setBlock(x + 1, -8, z + 1, Material.GLOWSTONE);
                            this.setBlock(x + 2, -8, z + 2, Material.GLOWSTONE);
                            this.setBlock(x + 1, -8, z + 2, Material.GLOWSTONE);
                            this.setBlock(x + 1, -8, z + 2, Material.GLOWSTONE);
                            break;
                        }
                        case 2: {
                            for (int i = 0; i < this.rand.nextInt(10); ++i) {
                                this.setBlock(x, -8 - i, z, Material.GLOWSTONE);
                            }
                            break;
                        }
                        case 3: {
                            this.setBlock(x, -8, z, Material.GLOWSTONE);
                            if (x <= 3 || z <= 3) break;
                            for (int xx = 0; xx < 3; ++xx) {
                                for (int zz = 0; zz < 3; ++zz) {
                                    this.setBlock(x - xx, -8 - this.rand.nextInt(2), z - xx, Material.GLOWSTONE);
                                }
                            }
                            break;
                        }
                        default: {
                            this.setBlock(x, -8, z, Material.GLOWSTONE);
                        }
                    }
                    this.setBlock(x, -8, z, Material.GLOWSTONE);
                    continue;
                }
                this.setBlock(x, -8, z, Material.AIR);
            }
        }
    }

    private void setBlock(int x, int y, int z, Material m) {
        this.roofChunk.put(new Vector(x, y, z), m);
    }

    private record WorldConfig(int seaHeight, Material waterBlock) {
    }

    private record FloorMats(Material base, Material top) {
    }
}

