/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.acidisland.world;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Monster;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import world.bentobox.acidisland.AcidIsland;
import world.bentobox.acidisland.events.EntityDamageByAcidEvent;
import world.bentobox.acidisland.events.ItemDestroyByAcidEvent;
import world.bentobox.acidisland.listeners.AcidEffect;

public class AcidTask {
    private final AcidIsland addon;
    private static final List<EntityType> IMMUNE;
    private Map<Entity, Long> itemsInWater = new ConcurrentHashMap<Entity, Long>();
    private final BukkitTask findMobsTask;

    public AcidTask(AcidIsland addon) {
        this.addon = addon;
        this.findMobsTask = Bukkit.getScheduler().runTaskTimer((Plugin)addon.getPlugin(), this::findEntities, 0L, 20L);
    }

    void findEntities() {
        WeakHashMap<Entity, Long> burnList = new WeakHashMap<Entity, Long>();
        for (Entity e : this.getEntityStream()) {
            if (!(e instanceof Item) && (IMMUNE.contains(e.getType()) || e instanceof WaterMob)) continue;
            int x = e.getLocation().getBlockX() >> 4;
            int z = e.getLocation().getBlockZ() >> 4;
            if (!e.getWorld().isChunkLoaded(x, z) || !e.getLocation().getBlock().getType().equals((Object)Material.WATER)) continue;
            if ((e instanceof Monster || e instanceof MagmaCube) && (double)this.addon.getSettings().getAcidDamageMonster() > 0.0) {
                burnList.put(e, Long.valueOf(this.addon.getSettings().getAcidDamageMonster()));
                continue;
            }
            if (e instanceof Animals && (double)this.addon.getSettings().getAcidDamageAnimal() > 0.0 && (!e.getType().equals((Object)EntityType.CHICKEN) || this.addon.getSettings().isAcidDamageChickens())) {
                burnList.put(e, Long.valueOf(this.addon.getSettings().getAcidDamageAnimal()));
                continue;
            }
            if (this.addon.getSettings().getAcidDestroyItemTime() <= 0L || !(e instanceof Item)) continue;
            burnList.put(e, System.currentTimeMillis());
        }
        this.itemsInWater.keySet().removeIf(i -> !burnList.containsKey(i));
        if (!burnList.isEmpty()) {
            Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> burnList.forEach(this::applyDamage));
        }
    }

    void applyDamage(Entity e, long damage) {
        if (e instanceof LivingEntity) {
            double actualDamage = Math.max(0.0, (double)damage - (double)damage * AcidEffect.getDamageReduced((LivingEntity)e));
            EntityDamageByAcidEvent event = new EntityDamageByAcidEvent(e, actualDamage, EntityDamageByAcidEvent.Acid.WATER);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                ((LivingEntity)e).damage(actualDamage);
            }
        } else if (this.addon.getSettings().getAcidDestroyItemTime() > 0L && e instanceof Item) {
            if (e.getLocation().getBlock().getType().equals((Object)Material.WATER)) {
                this.itemsInWater.putIfAbsent(e, damage + this.addon.getSettings().getAcidDestroyItemTime() * 1000L);
                if (System.currentTimeMillis() > this.itemsInWater.get(e)) {
                    e.getWorld().playSound(e.getLocation(), Sound.ENTITY_CREEPER_PRIMED, 3.0f, 3.0f);
                    e.remove();
                    this.itemsInWater.remove(e);
                    Bukkit.getPluginManager().callEvent((Event)new ItemDestroyByAcidEvent((Item)e));
                }
            } else {
                this.itemsInWater.remove(e);
            }
        }
    }

    List<Entity> getEntityStream() {
        ArrayList<Entity> entityStream = new ArrayList<Entity>(this.addon.getOverWorld().getEntities());
        if (this.addon.getSettings().isNetherGenerate() && this.addon.getSettings().isNetherIslands()) {
            entityStream.addAll(Objects.requireNonNull(this.addon.getNetherWorld()).getEntities());
        }
        if (this.addon.getSettings().isEndGenerate() && this.addon.getSettings().isEndIslands()) {
            entityStream.addAll(Objects.requireNonNull(this.addon.getEndWorld()).getEntities());
        }
        return entityStream;
    }

    public void cancelTasks() {
        if (this.findMobsTask != null) {
            this.findMobsTask.cancel();
        }
    }

    Map<Entity, Long> getItemsInWater() {
        return this.itemsInWater;
    }

    void setItemsInWater(Map<Entity, Long> itemsInWater) {
        this.itemsInWater = itemsInWater;
    }

    static {
        ArrayList<EntityType> i = new ArrayList<EntityType>();
        i.add(EntityType.POLAR_BEAR);
        i.add(EntityType.TURTLE);
        i.add(EntityType.DROWNED);
        i.add(EntityType.GUARDIAN);
        i.add(EntityType.ELDER_GUARDIAN);
        Enums.getIfPresent(EntityType.class, (String)"AXOLOTL").toJavaUtil().ifPresent(i::add);
        IMMUNE = Collections.unmodifiableList(i);
    }
}

