/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.acidisland;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.acidisland.AISettings;
import world.bentobox.acidisland.commands.IslandAboutCommand;
import world.bentobox.acidisland.listeners.AcidEffect;
import world.bentobox.acidisland.listeners.LavaCheck;
import world.bentobox.acidisland.world.AcidBiomeProvider;
import world.bentobox.acidisland.world.AcidTask;
import world.bentobox.acidisland.world.ChunkGeneratorWorld;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.DefaultAdminCommand;
import world.bentobox.bentobox.api.commands.island.DefaultPlayerCommand;
import world.bentobox.bentobox.api.configuration.Config;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.lists.Flags;

public class AcidIsland
extends GameModeAddon {
    private @Nullable AISettings settings;
    private @Nullable AcidTask acidTask;
    private @Nullable ChunkGenerator chunkGenerator;
    private final Config<AISettings> config = new Config((Addon)this, AISettings.class);
    private BiomeProvider biomeProvider;
    private static final String NETHER = "_nether";
    private static final String THE_END = "_the_end";

    public boolean isUsesNewChunkGeneration() {
        return true;
    }

    public void onLoad() {
        this.saveDefaultConfig();
        this.loadSettings();
        this.biomeProvider = new AcidBiomeProvider(this);
        this.chunkGenerator = this.settings.isUseOwnGenerator() ? null : new ChunkGeneratorWorld(this);
        this.playerCommand = new DefaultPlayerCommand(this, this){

            public void setup() {
                super.setup();
                new IslandAboutCommand((CompositeCommand)this);
            }
        };
        this.adminCommand = new DefaultAdminCommand(this, this){};
    }

    private boolean loadSettings() {
        this.settings = (AISettings)this.config.loadConfigObject();
        if (this.settings == null) {
            this.logError("AcidIsland settings could not load! Addon disabled.");
            this.setState(Addon.State.DISABLED);
            if (this.acidTask != null) {
                this.acidTask.cancelTasks();
            }
            return false;
        }
        return true;
    }

    public void onEnable() {
        if (this.settings == null) {
            return;
        }
        Flags.BOAT.setDefaultSetting(this.islandWorld, true);
        if (this.netherWorld != null) {
            Flags.BOAT.setDefaultSetting(this.netherWorld, true);
        }
        if (this.endWorld != null) {
            Flags.BOAT.setDefaultSetting(this.endWorld, true);
        }
        this.registerListener(new AcidEffect(this));
        this.registerListener(new LavaCheck(this));
        this.acidTask = new AcidTask(this);
    }

    public void onDisable() {
        if (this.acidTask != null) {
            this.acidTask.cancelTasks();
        }
    }

    public @NonNull AISettings getSettings() {
        return Objects.requireNonNull(this.settings);
    }

    public void createWorlds() {
        String worldName = this.settings.getWorldName().toLowerCase();
        if (Bukkit.getWorld((String)worldName) == null) {
            this.log("Creating AcidIsland...");
        }
        this.chunkGenerator = new ChunkGeneratorWorld(this);
        this.islandWorld = this.getWorld(worldName, World.Environment.NORMAL, this.chunkGenerator);
        if (this.settings.isNetherGenerate()) {
            if (Bukkit.getWorld((String)(worldName + NETHER)) == null) {
                this.log("Creating AcidIsland's Nether...");
            }
            World world = this.netherWorld = this.settings.isNetherIslands() ? this.getWorld(worldName, World.Environment.NETHER, this.chunkGenerator) : this.getWorld(worldName, World.Environment.NETHER, null);
        }
        if (this.settings.isEndGenerate()) {
            if (Bukkit.getWorld((String)(worldName + THE_END)) == null) {
                this.log("Creating AcidIsland's End World...");
            }
            this.endWorld = this.settings.isEndIslands() ? this.getWorld(worldName, World.Environment.THE_END, this.chunkGenerator) : this.getWorld(worldName, World.Environment.THE_END, null);
        }
    }

    private World getWorld(String worldName2, World.Environment env, @Nullable ChunkGenerator chunkGenerator2) {
        World w;
        worldName2 = env.equals((Object)World.Environment.NETHER) ? (String)worldName2 + NETHER : worldName2;
        worldName2 = env.equals((Object)World.Environment.THE_END) ? (String)worldName2 + THE_END : worldName2;
        WorldCreator wc = WorldCreator.name((String)worldName2).environment(env).type(WorldType.NORMAL);
        World world = w = this.settings.isUseOwnGenerator() ? wc.createWorld() : wc.generator(chunkGenerator2).createWorld();
        if (w != null && this.getSettings() != null) {
            if (this.getSettings().getSpawnLimitMonsters() > 0) {
                w.setSpawnLimit(SpawnCategory.MONSTER, this.getSettings().getSpawnLimitMonsters());
            }
            if (this.getSettings().getSpawnLimitAmbient() > 0) {
                w.setSpawnLimit(SpawnCategory.AMBIENT, this.getSettings().getSpawnLimitAmbient());
            }
            if (this.getSettings().getSpawnLimitAnimals() > 0) {
                w.setSpawnLimit(SpawnCategory.ANIMAL, this.getSettings().getSpawnLimitAnimals());
            }
            if (this.getSettings().getSpawnLimitWaterAnimals() > 0) {
                w.setSpawnLimit(SpawnCategory.WATER_ANIMAL, this.getSettings().getSpawnLimitWaterAnimals());
            }
            if (this.getSettings().getTicksPerAnimalSpawns() > 0) {
                w.setTicksPerSpawns(SpawnCategory.ANIMAL, this.getSettings().getTicksPerAnimalSpawns());
            }
            if (this.getSettings().getTicksPerMonsterSpawns() > 0) {
                w.setTicksPerSpawns(SpawnCategory.MONSTER, this.getSettings().getTicksPerMonsterSpawns());
            }
        }
        return w;
    }

    public WorldSettings getWorldSettings() {
        return this.getSettings();
    }

    public void onReload() {
        if (this.loadSettings()) {
            this.log("Reloaded AcidIsland settings");
        }
    }

    public @NonNull ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return this.chunkGenerator;
    }

    public void saveWorldSettings() {
        if (this.settings != null) {
            this.config.saveConfigObject((Object)this.settings);
        }
    }

    public void allLoaded() {
        this.saveWorldSettings();
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }
}

