/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.oneblocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.oneblocks.OneBlockCustomBlock;
import world.bentobox.aoneblock.oneblocks.OneBlockObject;
import world.bentobox.aoneblock.oneblocks.Requirement;

public class OneBlockPhase {
    protected static final SortedMap<Double, OneBlockObject.Rarity> CHEST_CHANCES = new TreeMap<Double, OneBlockObject.Rarity>();
    private final TreeMap<Integer, OneBlockObject> probMap = new TreeMap();
    private int total = 0;
    private String phaseName;
    private Biome phaseBiome;
    private World.Environment environment;
    private OneBlockObject firstBlock;
    private ItemStack iconBlock;
    private final Map<OneBlockObject.Rarity, List<OneBlockObject>> chests = new EnumMap<OneBlockObject.Rarity, List<OneBlockObject>>(OneBlockObject.Rarity.class);
    private final Random blockRandom;
    private final Random chestRandom;
    private final String blockNumber;
    private Integer gotoBlock;
    private int blockTotal = 0;
    private int entityTotal = 0;
    private List<String> startCommands;
    private List<String> endCommands;
    private List<String> firstTimeEndCommands;
    private List<Requirement> requirements;
    private Map<Integer, OneBlockObject> fixedBlocks;
    private Map<Integer, String> holograms;

    public OneBlockPhase(String blockNumber) {
        this.blockNumber = blockNumber;
        this.startCommands = new ArrayList<String>();
        this.endCommands = new ArrayList<String>();
        this.firstTimeEndCommands = new ArrayList<String>();
        this.requirements = new ArrayList<Requirement>();
        this.fixedBlocks = new HashMap<Integer, OneBlockObject>();
        this.holograms = new HashMap<Integer, String>();
        this.blockRandom = new Random();
        this.chestRandom = new Random();
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public int getBlockNumberValue() {
        return Integer.parseInt(this.blockNumber);
    }

    public @Nullable String getHologramLine(Integer block) {
        return this.holograms.getOrDefault(block, null);
    }

    public Map<Integer, String> getHologramLines() {
        return this.holograms;
    }

    public @Nullable String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public @Nullable Biome getPhaseBiome() {
        return this.phaseBiome;
    }

    public void setPhaseBiome(Biome phaseBiome) {
        this.phaseBiome = phaseBiome;
    }

    public void addBlock(Material material, int prob) {
        this.total += prob;
        this.blockTotal += prob;
        this.probMap.put(this.total, new OneBlockObject(material, prob));
    }

    public void addCustomBlock(OneBlockCustomBlock customBlock, int prob) {
        this.total += prob;
        this.blockTotal += prob;
        this.probMap.put(this.total, new OneBlockObject(customBlock, prob));
    }

    public void addMob(EntityType entityType, int prob) {
        this.total += prob;
        this.entityTotal += prob;
        this.probMap.put(this.total, new OneBlockObject(entityType, prob));
    }

    public void addChest(Map<Integer, ItemStack> items, OneBlockObject.Rarity rarity) {
        this.chests.computeIfAbsent(rarity, k -> new ArrayList()).add(new OneBlockObject(items, rarity));
    }

    public OneBlockObject getNextBlock(AOneBlock addon, int blockNumber) {
        if (this.total < 1) {
            addon.logError("Phase " + this.getPhaseName() + " has zero probability of generating blocks. Check config file. Is the block section missing?");
            return this.getFirstBlock() != null ? this.getFirstBlock() : new OneBlockObject(Material.GRASS_BLOCK, 1);
        }
        if (blockNumber == 0 && this.getFirstBlock() != null) {
            return this.getResult(this.getFirstBlock());
        }
        if (this.getFixedBlocks().containsKey(blockNumber)) {
            return this.getResult(this.getFixedBlocks().get(blockNumber));
        }
        OneBlockObject block = this.getRandomBlock(this.probMap, this.total);
        if (block.isEntity()) {
            return block;
        }
        return this.getResult(block);
    }

    private OneBlockObject getResult(OneBlockObject block) {
        if (block.isMaterial()) {
            return block.getMaterial().equals((Object)Material.CHEST) && !this.chests.isEmpty() ? this.getRandomChest() : block;
        }
        return block;
    }

    private OneBlockObject getRandomChest() {
        OneBlockObject.Rarity r = CHEST_CHANCES.getOrDefault(((TreeMap)CHEST_CHANCES).ceilingKey(this.chestRandom.nextDouble()), OneBlockObject.Rarity.COMMON);
        if (!this.chests.containsKey((Object)r) && !this.chests.containsKey((Object)OneBlockObject.Rarity.COMMON)) {
            return new OneBlockObject(Material.CHEST, 0);
        }
        List<OneBlockObject> list = this.chests.containsKey((Object)r) ? this.chests.get((Object)r) : this.chests.get((Object)OneBlockObject.Rarity.COMMON);
        return list.isEmpty() ? new OneBlockObject(Material.CHEST, 0) : list.get(this.chestRandom.nextInt(list.size()));
    }

    private OneBlockObject getRandomBlock(TreeMap<Integer, OneBlockObject> probMap2, int total2) {
        int randomValue = this.blockRandom.nextInt(total2 + 1);
        OneBlockObject temp = probMap2.get(randomValue);
        if (temp == null) {
            temp = probMap2.ceilingEntry(randomValue).getValue();
        }
        if (temp == null) {
            temp = probMap2.firstEntry().getValue();
        }
        return new OneBlockObject(temp);
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(World.Environment environment) {
        this.environment = environment;
    }

    public @Nullable OneBlockObject getFirstBlock() {
        return this.firstBlock;
    }

    public @Nullable ItemStack getIconBlock() {
        return this.iconBlock;
    }

    public void setFirstBlock(OneBlockObject firstBlock) {
        this.firstBlock = firstBlock;
    }

    public void setIconBlock(ItemStack iconBlock) {
        this.iconBlock = iconBlock;
    }

    public Collection<OneBlockObject> getChests() {
        return this.chests.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<OneBlockObject.Rarity, List<OneBlockObject>> getChestsMap() {
        return this.chests;
    }

    public Map<EntityType, Integer> getMobs() {
        return this.probMap.values().stream().filter(OneBlockObject::isEntity).collect(Collectors.toMap(OneBlockObject::getEntityType, OneBlockObject::getProb));
    }

    public Map<Material, Integer> getBlocks() {
        return this.probMap.values().stream().filter(OneBlockObject::isMaterial).collect(Collectors.toMap(OneBlockObject::getMaterial, OneBlockObject::getProb));
    }

    public Integer getGotoBlock() {
        return this.gotoBlock;
    }

    public void setGotoBlock(Integer gotoBlock) {
        this.gotoBlock = gotoBlock;
    }

    public int getTotal() {
        return this.total;
    }

    public int getBlockTotal() {
        return this.blockTotal;
    }

    public int getEntityTotal() {
        return this.entityTotal;
    }

    public boolean isGotoPhase() {
        return this.gotoBlock != null;
    }

    public List<String> getStartCommands() {
        return this.startCommands;
    }

    public void setStartCommands(List<String> commands) {
        this.startCommands = commands;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(List<Requirement> requirements) {
        this.requirements = requirements;
    }

    public List<String> getEndCommands() {
        return this.endCommands;
    }

    public void setEndCommands(List<String> endCommands) {
        this.endCommands = endCommands;
    }

    public List<String> getFirstTimeEndCommands() {
        return this.firstTimeEndCommands;
    }

    public void setFirstTimeEndCommands(List<String> firstTimeEndCommands) {
        this.firstTimeEndCommands = firstTimeEndCommands;
    }

    public Map<Integer, OneBlockObject> getFixedBlocks() {
        return this.fixedBlocks;
    }

    public void setFixedBlocks(Map<Integer, OneBlockObject> fixedBlocks) {
        this.fixedBlocks = fixedBlocks;
    }

    public void setHologramLines(Map<Integer, String> hologramLines) {
        this.holograms = hologramLines;
    }

    public String toString() {
        return "OneBlockPhase [" + (String)(this.phaseName != null ? "phaseName=" + this.phaseName + ", " : "") + (String)(this.phaseBiome != null ? "phaseBiome=" + String.valueOf(this.phaseBiome) + ", " : "") + (String)(this.environment != null ? "environment=" + String.valueOf(this.environment) + ", " : "") + (String)(this.firstBlock != null ? "firstBlock=" + String.valueOf(this.firstBlock) + ", " : "") + (String)(this.iconBlock != null ? "iconBlock=" + String.valueOf(this.iconBlock) + ", " : "") + (String)(this.gotoBlock != null ? "gotoBlock=" + this.gotoBlock + ", " : "") + "blockTotal=" + this.blockTotal + ", entityTotal=" + this.entityTotal + ", " + (String)(this.startCommands != null ? "startCommands=" + String.valueOf(this.startCommands) + ", " : "") + (String)(this.endCommands != null ? "endCommands=" + String.valueOf(this.endCommands) + ", " : "") + (String)(this.requirements != null ? "requirements=" + String.valueOf(this.requirements) + ", " : "") + (String)(this.fixedBlocks != null ? "fixedBlocks=" + String.valueOf(this.fixedBlocks) + ", " : "") + (String)(this.holograms != null ? "holograms=" + String.valueOf(this.holograms) : "") + "]";
    }

    static {
        CHEST_CHANCES.put(0.62, OneBlockObject.Rarity.COMMON);
        CHEST_CHANCES.put(0.87, OneBlockObject.Rarity.UNCOMMON);
        CHEST_CHANCES.put(0.96, OneBlockObject.Rarity.RARE);
        CHEST_CHANCES.put(1.0, OneBlockObject.Rarity.EPIC);
    }
}

