/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.oneblocks;

import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import world.bentobox.aoneblock.oneblocks.OneBlockCustomBlock;

public class OneBlockObject {
    private EntityType entityType;
    private Material material;
    private Map<Integer, ItemStack> chest;
    private Rarity rarity;
    private OneBlockCustomBlock customBlock;
    private int prob;

    public OneBlockObject(EntityType entityType, int prob) {
        this.entityType = entityType;
        this.prob = prob;
    }

    public OneBlockObject(Material material, int prob) {
        this.material = material;
        this.prob = prob;
    }

    public OneBlockObject(OneBlockCustomBlock customBlock, int prob) {
        this.customBlock = customBlock;
        this.prob = prob;
    }

    public OneBlockObject(Map<Integer, ItemStack> chest, Rarity rarity) {
        this.material = Material.CHEST;
        this.chest = chest;
        this.setRarity(rarity);
    }

    public OneBlockObject(OneBlockObject ob) {
        this.chest = ob.getChest();
        this.entityType = ob.getEntityType();
        this.material = ob.getMaterial();
        this.rarity = ob.getRarity();
        this.prob = ob.getProb();
        this.customBlock = ob.getCustomBlock();
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Map<Integer, ItemStack> getChest() {
        return this.chest;
    }

    public OneBlockCustomBlock getCustomBlock() {
        return this.customBlock;
    }

    public boolean isMaterial() {
        return this.material != null;
    }

    public boolean isEntity() {
        return this.entityType != null;
    }

    public boolean isCustomBlock() {
        return this.customBlock != null;
    }

    public Rarity getRarity() {
        return this.rarity == null ? Rarity.COMMON : this.rarity;
    }

    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    public int getProb() {
        return this.prob;
    }

    public void setProb(int prob) {
        this.prob = prob;
    }

    public String toString() {
        return "OneBlockObject [" + (String)(this.entityType != null ? "entityType=" + String.valueOf(this.entityType) + ", " : "") + (String)(this.material != null ? "material=" + String.valueOf(this.material) + ", " : "") + (String)(this.chest != null ? "chest=" + String.valueOf(this.chest) + ", " : "") + (String)(this.rarity != null ? "rarity=" + String.valueOf((Object)this.rarity) + ", " : "") + (String)(this.customBlock != null ? "customBlock=" + String.valueOf(this.customBlock) + ", " : "") + "prob=" + this.prob + "]";
    }

    public static enum Rarity {
        COMMON,
        UNCOMMON,
        RARE,
        EPIC;

    }
}

