/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.listeners;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.aoneblock.oneblocks.MobAspects;

public class WarningSounder {
    private final AOneBlock addon;
    private Map<EntityType, MobAspects> MOB_ASPECTS;

    public WarningSounder(AOneBlock addon) {
        this.addon = addon;
    }

    void play(@NonNull OneBlockIslands is, @NonNull Block block) {
        if (this.MOB_ASPECTS == null) {
            this.initialize();
        }
        List<EntityType> opMob = is.getNearestMob(this.addon.getSettings().getMobWarning());
        opMob.stream().filter(this.MOB_ASPECTS::containsKey).map(this.MOB_ASPECTS::get).forEach(s -> {
            block.getWorld().playSound(block.getLocation(), s.sound(), 1.0f, 1.0f);
            block.getWorld().spawnParticle(Particle.DUST, block.getLocation().add(new Vector(0.5, 1.0, 0.5)), 10, 0.5, 0.0, 0.5, 1.0, (Object)new Particle.DustOptions(s.color(), 1.0f));
        });
    }

    private void initialize() {
        EnumMap<EntityType, MobAspects> m = new EnumMap<EntityType, MobAspects>(EntityType.class);
        m.put(EntityType.BLAZE, new MobAspects(Sound.ENTITY_BLAZE_AMBIENT, Color.fromRGB((int)238, (int)211, (int)91)));
        m.put(EntityType.CAVE_SPIDER, new MobAspects(Sound.ENTITY_SPIDER_AMBIENT, Color.fromRGB((int)63, (int)37, (int)31)));
        m.put(EntityType.CREEPER, new MobAspects(Sound.ENTITY_CREEPER_PRIMED, Color.fromRGB((int)125, (int)255, (int)106)));
        m.put(EntityType.DROWNED, new MobAspects(Sound.ENTITY_DROWNED_AMBIENT, Color.fromRGB((int)109, (int)152, (int)144)));
        m.put(EntityType.ELDER_GUARDIAN, new MobAspects(Sound.ENTITY_ELDER_GUARDIAN_AMBIENT, Color.fromRGB((int)201, (int)143, (int)113)));
        m.put(EntityType.ENDERMAN, new MobAspects(Sound.ENTITY_ENDERMAN_AMBIENT, Color.fromRGB((int)0, (int)0, (int)0)));
        m.put(EntityType.ENDERMITE, new MobAspects(Sound.ENTITY_ENDERMITE_AMBIENT, Color.fromRGB((int)30, (int)30, (int)30)));
        m.put(EntityType.EVOKER, new MobAspects(Sound.ENTITY_EVOKER_AMBIENT, Color.fromRGB((int)144, (int)148, (int)148)));
        m.put(EntityType.GHAST, new MobAspects(Sound.ENTITY_GHAST_AMBIENT, Color.fromRGB((int)242, (int)242, (int)242)));
        m.put(EntityType.GUARDIAN, new MobAspects(Sound.ENTITY_GUARDIAN_AMBIENT, Color.fromRGB((int)201, (int)143, (int)113)));
        m.put(EntityType.HUSK, new MobAspects(Sound.ENTITY_HUSK_AMBIENT, Color.fromRGB((int)111, (int)104, (int)90)));
        m.put(EntityType.ILLUSIONER, new MobAspects(Sound.ENTITY_ILLUSIONER_AMBIENT, Color.fromRGB((int)144, (int)149, (int)149)));
        m.put(EntityType.PIGLIN, new MobAspects(Sound.ENTITY_PIGLIN_AMBIENT, Color.fromRGB((int)255, (int)215, (int)0)));
        m.put(EntityType.PIGLIN_BRUTE, new MobAspects(Sound.ENTITY_PIGLIN_BRUTE_AMBIENT, Color.fromRGB((int)255, (int)215, (int)0)));
        m.put(EntityType.ZOMBIFIED_PIGLIN, new MobAspects(Sound.ENTITY_ZOMBIFIED_PIGLIN_AMBIENT, Color.fromRGB((int)125, (int)100, (int)0)));
        m.put(EntityType.PILLAGER, new MobAspects(Sound.ENTITY_PILLAGER_AMBIENT, Color.fromRGB((int)74, (int)74, (int)53)));
        m.put(EntityType.RAVAGER, new MobAspects(Sound.ENTITY_RAVAGER_AMBIENT, Color.fromRGB((int)85, (int)78, (int)73)));
        m.put(EntityType.SHULKER, new MobAspects(Sound.ENTITY_SHULKER_AMBIENT, Color.fromRGB((int)142, (int)106, (int)146)));
        m.put(EntityType.SILVERFISH, new MobAspects(Sound.ENTITY_SILVERFISH_AMBIENT, Color.fromRGB((int)211, (int)211, (int)211)));
        m.put(EntityType.SKELETON, new MobAspects(Sound.ENTITY_SKELETON_AMBIENT, Color.fromRGB((int)211, (int)211, (int)211)));
        m.put(EntityType.SPIDER, new MobAspects(Sound.ENTITY_SPIDER_AMBIENT, Color.fromRGB((int)94, (int)84, (int)73)));
        m.put(EntityType.STRAY, new MobAspects(Sound.ENTITY_STRAY_AMBIENT, Color.fromRGB((int)118, (int)132, (int)135)));
        m.put(EntityType.VEX, new MobAspects(Sound.ENTITY_VEX_AMBIENT, Color.fromRGB((int)137, (int)156, (int)176)));
        m.put(EntityType.VINDICATOR, new MobAspects(Sound.ENTITY_VINDICATOR_AMBIENT, Color.fromRGB((int)137, (int)156, (int)166)));
        m.put(EntityType.WITCH, new MobAspects(Sound.ENTITY_WITCH_AMBIENT, Color.fromRGB((int)56, (int)39, (int)67)));
        m.put(EntityType.WITHER, new MobAspects(Sound.ENTITY_WITHER_AMBIENT, Color.fromRGB((int)80, (int)80, (int)80)));
        m.put(EntityType.WARDEN, new MobAspects(Sound.ENTITY_WARDEN_AMBIENT, Color.fromRGB((int)6, (int)72, (int)86)));
        m.put(EntityType.WITHER_SKELETON, new MobAspects(Sound.ENTITY_WITHER_SKELETON_AMBIENT, Color.fromRGB((int)100, (int)100, (int)100)));
        m.put(EntityType.ZOGLIN, new MobAspects(Sound.ENTITY_ZOGLIN_AMBIENT, Color.fromRGB((int)255, (int)192, (int)203)));
        m.put(EntityType.ZOMBIE, new MobAspects(Sound.ENTITY_ZOMBIE_AMBIENT, Color.fromRGB((int)74, (int)99, (int)53)));
        m.put(EntityType.ZOMBIE_VILLAGER, new MobAspects(Sound.ENTITY_ZOMBIE_VILLAGER_AMBIENT, Color.fromRGB((int)111, (int)104, (int)90)));
        this.MOB_ASPECTS = Collections.unmodifiableMap(m);
    }
}

