/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.listeners;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.aoneblock.listeners.BlockListener;
import world.bentobox.aoneblock.oneblocks.OneBlockPhase;
import world.bentobox.aoneblock.oneblocks.OneBlocksManager;
import world.bentobox.aoneblock.oneblocks.Requirement;
import world.bentobox.bank.Bank;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;
import world.bentobox.level.Level;

public class CheckPhase {
    private final AOneBlock addon;
    private final OneBlocksManager oneBlocksManager;
    private final BlockListener blockListener;

    public CheckPhase(AOneBlock addon, BlockListener blockListener) {
        this.addon = addon;
        this.oneBlocksManager = addon.getOneBlockManager();
        this.blockListener = blockListener;
    }

    void setNewPhase(@Nullable Player player, @NonNull Island i, @NonNull OneBlockIslands is, @NonNull OneBlockPhase phase) {
        User user = player == null || player.hasMetadata("NPC") ? this.addon.getPlayers().getUser(i.getOwner()) : User.getInstance((Player)player);
        String newPhaseName = Objects.requireNonNullElse(phase.getPhaseName(), "");
        this.oneBlocksManager.getPhase(is.getPhaseName()).ifPresent(oldPhase -> {
            String oldPhaseName = oldPhase.getPhaseName() == null ? "" : oldPhase.getPhaseName();
            Util.runCommands((User)user, this.replacePlaceholders(player, oldPhaseName, phase.getBlockNumber(), i, oldPhase.getEndCommands()), (String)("Commands run for end of " + oldPhaseName));
            if ((long)is.getBlockNumber() >= is.getLifetime()) {
                Util.runCommands((User)user, this.replacePlaceholders(player, oldPhaseName, phase.getBlockNumber(), i, oldPhase.getFirstTimeEndCommands()), (String)("Commands run for first time completing " + oldPhaseName));
            }
        });
        is.setPhaseName(newPhaseName);
        if (user.isPlayer() && user.isOnline() && this.addon.inWorld(user.getWorld())) {
            user.getPlayer().sendTitle(newPhaseName, null, -1, -1, -1);
        }
        Util.runCommands((User)user, this.replacePlaceholders(player, newPhaseName, phase.getBlockNumber(), i, phase.getStartCommands()), (String)("Commands run for start of " + newPhaseName));
        this.blockListener.saveIsland(i);
    }

    protected boolean phaseRequirementsFail(@Nullable Player player, @NonNull Island i, @NonNull OneBlockIslands is, OneBlockPhase phase, @NonNull World world) {
        if (phase.getRequirements().isEmpty()) {
            return false;
        }
        if (player == null) {
            return true;
        }
        return phase.getRequirements().stream().anyMatch(r -> this.checkRequirement((Requirement)r, User.getInstance((Player)player), i, is, world));
    }

    private boolean checkRequirement(Requirement r, User user, Island i, OneBlockIslands is, World world) {
        return switch (r.getType()) {
            default -> throw new MatchException(null, null);
            case Requirement.ReqType.LEVEL -> this.checkLevelRequirement(r, user, i, world);
            case Requirement.ReqType.BANK -> this.checkBankRequirement(r, user, i);
            case Requirement.ReqType.ECO -> this.checkEcoRequirement(r, user, world);
            case Requirement.ReqType.PERMISSION -> this.checkPermissionRequirement(r, user);
            case Requirement.ReqType.COOLDOWN -> this.checkCooldownRequirement(r, user, is);
        };
    }

    private boolean checkLevelRequirement(Requirement r, User user, Island i, World world) {
        return this.addon.getAddonByName("Level").map(l -> {
            if (((Level)l).getIslandLevel(world, i.getOwner()) < r.getLevel()) {
                user.sendMessage("aoneblock.phase.insufficient-level", new String[]{"[number]", String.valueOf(r.getLevel())});
                return true;
            }
            return false;
        }).orElse(false);
    }

    private boolean checkBankRequirement(Requirement r, User user, Island i) {
        return this.addon.getAddonByName("Bank").map(l -> {
            if (((Bank)l).getBankManager().getBalance(i).getValue() < r.getBank()) {
                user.sendMessage("aoneblock.phase.insufficient-bank-balance", new String[]{"[number]", String.valueOf(r.getBank())});
                return true;
            }
            return false;
        }).orElse(false);
    }

    private boolean checkEcoRequirement(Requirement r, User user, World world) {
        return this.addon.getPlugin().getVault().map(vaultHook -> {
            if (vaultHook.getBalance(user, world) < r.getEco()) {
                user.sendMessage("aoneblock.phase.insufficient-funds", new String[]{"[number]", vaultHook.format(r.getEco())});
                return true;
            }
            return false;
        }).orElse(false);
    }

    private boolean checkPermissionRequirement(Requirement r, User user) {
        if (user != null && !user.hasPermission(r.getPermission())) {
            user.sendMessage("aoneblock.phase.insufficient-permission", new String[]{"[name]", r.getPermission()});
            return true;
        }
        return false;
    }

    private boolean checkCooldownRequirement(Requirement r, User player, OneBlockIslands is) {
        long remainingTime = r.getCooldown() - (System.currentTimeMillis() - is.getLastPhaseChangeTime()) / 1000L;
        if (remainingTime > 0L) {
            player.sendMessage("aoneblock.phase.cooldown", new String[]{"[number]", String.valueOf(remainingTime)});
            return true;
        }
        return false;
    }

    @NonNull List<String> replacePlaceholders(@Nullable Player player, @NonNull String phaseName, @NonNull String phaseNumber, @NonNull Island i, List<String> commands) {
        return commands.stream().map(c -> {
            long level = this.addon.getAddonByName("Level").map(l -> ((Level)l).getIslandLevel(this.addon.getOverWorld(), i.getOwner())).orElse(0L);
            double balance = this.addon.getAddonByName("Bank").map(b -> ((Bank)b).getBankManager().getBalance(i).getValue()).orElse(0.0);
            double ecoBalance = player == null ? 0.0 : this.addon.getPlugin().getVault().map(v -> v.getBalance(User.getInstance((Player)player), this.addon.getOverWorld())).orElse(0.0);
            return c.replace("[island]", i.getName() == null ? "" : i.getName()).replace("[owner]", this.addon.getPlayers().getName(i.getOwner())).replace("[phase]", phaseName).replace("[blocks]", phaseNumber).replace("[level]", String.valueOf(level)).replace("[bank-balance]", String.valueOf(balance)).replace("[eco-balance]", String.valueOf(ecoBalance));
        }).map(c -> this.addon.getPlugin().getPlaceholdersManager().replacePlaceholders(player, c)).collect(Collectors.toList());
    }
}

