/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.dataobjects;

import com.google.gson.annotations.Expose;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.bukkit.entity.EntityType;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.aoneblock.oneblocks.OneBlockCustomBlock;
import world.bentobox.aoneblock.oneblocks.OneBlockObject;
import world.bentobox.aoneblock.oneblocks.customblock.MobCustomBlock;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.objects.Table;

@Table(name="OneBlockIslands")
public class OneBlockIslands
implements DataObject {
    @Expose
    private String uniqueId;
    @Expose
    private int blockNumber;
    @Expose
    private long lifetime;
    @Expose
    private String phaseName = "";
    @Expose
    private String hologram = "";
    @Expose
    private long lastPhaseChangeTime = 0L;
    private Queue<OneBlockObject> queue = new LinkedList<OneBlockObject>();

    public @NonNull String getPhaseName() {
        return this.phaseName == null ? "" : this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public OneBlockIslands(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(int blockNumber) {
        this.blockNumber = blockNumber;
    }

    public void incrementBlockNumber() {
        if (this.lifetime < (long)this.blockNumber) {
            this.lifetime = this.blockNumber;
        }
        ++this.blockNumber;
        ++this.lifetime;
    }

    public @NonNull String getHologram() {
        return this.hologram == null ? "" : this.hologram;
    }

    public void setHologram(String hologramLine) {
        this.hologram = hologramLine;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Queue<OneBlockObject> getQueue() {
        if (this.queue == null) {
            this.queue = new LinkedList<OneBlockObject>();
        }
        return this.queue;
    }

    public List<EntityType> getNearestMob(int i) {
        return this.getQueue().stream().limit(i).filter(obo -> obo.isEntity() || obo.isCustomBlock() && obo.getCustomBlock() instanceof MobCustomBlock).map(obo -> {
            OneBlockCustomBlock patt0$temp;
            if (obo.isCustomBlock() && (patt0$temp = obo.getCustomBlock()) instanceof MobCustomBlock) {
                MobCustomBlock mb = (MobCustomBlock)patt0$temp;
                return mb.getMob();
            }
            return obo.getEntityType();
        }).toList();
    }

    public void add(OneBlockObject nextBlock) {
        this.getQueue().add(nextBlock);
    }

    public OneBlockObject pollAndAdd(OneBlockObject toAdd) {
        this.getQueue();
        OneBlockObject b = this.queue.poll();
        this.queue.add(toAdd);
        return b;
    }

    public void clearQueue() {
        this.getQueue().clear();
    }

    public long getLifetime() {
        if (this.lifetime < (long)this.blockNumber) {
            this.lifetime = this.blockNumber;
        }
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public long getLastPhaseChangeTime() {
        return this.lastPhaseChangeTime;
    }

    public void setLastPhaseChangeTime(long lastPhaseChangeTime) {
        this.lastPhaseChangeTime = lastPhaseChangeTime;
    }
}

