/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.commands.island;

import java.util.List;
import java.util.Objects;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandSetCountCommand
extends CompositeCommand {
    private AOneBlock addon;

    public IslandSetCountCommand(CompositeCommand islandCommand, String label, String[] aliases) {
        super(islandCommand, label, aliases);
    }

    public void setup() {
        this.setOnlyPlayer(true);
        this.setParametersHelp("aoneblock.commands.island.setcount.parameters");
        this.setDescription("aoneblock.commands.island.setcount.description");
        this.setPermission("island.setcount");
        this.addon = (AOneBlock)this.getAddon();
        this.setConfigurableRankCommand();
    }

    public boolean canExecute(User user, String label, List<String> args) {
        return this.addon.getSettings().getSetCountCooldown() <= 0 || !this.checkCooldown(user);
    }

    public boolean execute(User user, String label, List<String> args) {
        OneBlockIslands i;
        long maxCount;
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        if (!this.getIslands().inTeam(this.getWorld(), user.getUniqueId()) && !this.getIslands().hasIsland(this.getWorld(), user.getUniqueId())) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        Island island = Objects.requireNonNull(this.getIslands().getIsland(this.getWorld(), user));
        int rank = island.getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", new String[]{"[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0])});
            return false;
        }
        if (!Util.isInteger((String)args.getFirst(), (boolean)true) || Integer.parseInt(args.getFirst()) < 0) {
            user.sendMessage("general.errors.must-be-positive-number", new String[]{"[number]", args.getFirst()});
            return false;
        }
        int count = Integer.parseInt(args.getFirst());
        if ((long)count > (maxCount = (i = this.addon.getBlockListener().getIsland(island)).getLifetime())) {
            user.sendMessage("aoneblock.commands.island.setcount.too-high", new String[]{"[number]", String.valueOf(maxCount)});
            return false;
        }
        i.setBlockNumber(count);
        i.clearQueue();
        user.sendMessage("aoneblock.commands.island.setcount.set", new String[]{"[number]", String.valueOf(i.getBlockNumber())});
        this.setCooldown(user.getUniqueId(), this.addon.getSettings().getSetCountCooldown() * 60);
        return true;
    }
}

