/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.commands.island;

import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.util.Vector;
import world.bentobox.aoneblock.listeners.BlockProtect;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class IslandRespawnBlockCommand
extends CompositeCommand {
    public IslandRespawnBlockCommand(CompositeCommand islandCommand, String label, String[] aliases) {
        super(islandCommand, label, aliases);
    }

    public void setup() {
        this.setDescription("aoneblock.commands.respawn-block.description");
        this.setOnlyPlayer(true);
        this.setPermission("respawn-block");
    }

    public boolean canExecute(User user, String label, List<String> args) {
        if (!Util.sameWorld((World)this.getWorld(), (World)user.getWorld())) {
            user.sendMessage("general.errors.wrong-world", new String[0]);
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        if (island == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        return true;
    }

    public boolean execute(User user, String label, List<String> args) {
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        Objects.requireNonNull(island);
        if (island.getCenter().getBlock().getType() == Material.BEDROCK || island.getCenter().getBlock().getType() == Material.AIR) {
            Bukkit.getServer().getPluginManager().callEvent((Event)new BlockBreakEvent(island.getCenter().getBlock(), user.getPlayer()));
            user.sendMessage("aoneblock.commands.respawn-block.block-respawned", new String[0]);
        } else {
            for (double x = 0.0; x <= 1.0; x += 0.5) {
                for (double y = 0.0; y <= 1.0; y += 0.5) {
                    for (double z = 0.0; z < 1.0; z += 0.5) {
                        island.getWorld().spawnParticle(Particle.DUST, island.getCenter().add(new Vector(x, y, z)), 5, 0.1, 0.0, 0.1, 1.0, (Object)new Particle.DustOptions(BlockProtect.GREEN, 1.0f));
                    }
                }
            }
            user.sendMessage("aoneblock.commands.respawn-block.block-exist", new String[0]);
        }
        return true;
    }
}

