/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.commands.admin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.inventory.ItemStack;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.oneblocks.OneBlockObject;
import world.bentobox.aoneblock.oneblocks.OneBlockPhase;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;

public class AdminSetChestCommand
extends CompositeCommand {
    private static final List<String> RARITY_LIST = Arrays.stream(OneBlockObject.Rarity.values()).map(Enum::name).toList();
    private AOneBlock addon;
    private OneBlockPhase phase;
    private OneBlockObject.Rarity rarity;
    private Chest chest;

    public AdminSetChestCommand(CompositeCommand islandCommand) {
        super(islandCommand, "setchest", new String[0]);
    }

    public void setup() {
        this.setParametersHelp("aoneblock.commands.admin.setchest.parameters");
        this.setDescription("aoneblock.commands.admin.setchest.description");
        this.setPermission("admin.setchest");
        this.setOnlyPlayer(true);
        this.addon = (AOneBlock)this.getAddon();
    }

    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 2) {
            this.showHelp(this, user);
            return false;
        }
        Optional<OneBlockPhase> opPhase = this.addon.getOneBlockManager().getPhase(args.get(0).toUpperCase());
        if (opPhase.isEmpty()) {
            user.sendMessage("aoneblock.commands.admin.setchest.unknown-phase", new String[0]);
            return false;
        }
        this.phase = opPhase.get();
        try {
            this.rarity = OneBlockObject.Rarity.valueOf(args.get(1).toUpperCase());
        }
        catch (Exception e) {
            user.sendMessage("aoneblock.commands.admin.setchest.unknown-rarity", new String[0]);
            return false;
        }
        Block target = user.getPlayer().getTargetBlock(null, 5);
        if (!target.getType().equals((Object)Material.CHEST)) {
            user.sendMessage("aoneblock.commands.admin.setchest.look-at-chest", new String[0]);
            return false;
        }
        this.chest = (Chest)target.getState();
        if (this.chest.getInventory().getHolder() instanceof DoubleChest) {
            user.sendMessage("aoneblock.commands.admin.setchest.only-single-chest", new String[0]);
            return false;
        }
        return true;
    }

    public boolean execute(User user, String label, List<String> args) {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        for (int slot = 0; slot < this.chest.getInventory().getSize(); ++slot) {
            ItemStack item;
            if (this.chest.getInventory().getItem(slot) == null || (item = this.chest.getInventory().getItem(slot)) == null || item.getType().equals((Object)Material.AIR)) continue;
            items.put(slot, item.clone());
        }
        if (items.isEmpty()) {
            user.sendMessage("aoneblock.commands.admin.setchest.chest-is-empty", new String[0]);
            return false;
        }
        this.phase.addChest(items, this.rarity);
        if (this.addon.getOneBlockManager().savePhase(this.phase)) {
            user.sendMessage("aoneblock.commands.admin.setchest.success", new String[0]);
        } else {
            user.sendMessage("aoneblock.commands.admin.setchest.failure", new String[0]);
        }
        return true;
    }

    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        if (args.size() == 2) {
            return Optional.of(this.addon.getOneBlockManager().getPhaseList());
        }
        if (args.size() == 3) {
            return Optional.of(RARITY_LIST);
        }
        return Optional.empty();
    }
}

