/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.querybuilder;

import java.util.StringJoiner;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class ValueNode
implements Node {
    private final Value[] values;
    private final String field;
    private final String joinString;

    public ValueNode(String field, String joinstr, Value ... values2) {
        this.field = field;
        this.values = values2;
        this.joinString = joinstr;
    }

    private static Value[] fromStrings(String[] values2) {
        Value[] objs = new Value[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            objs[i] = Values.value(values2[i]);
        }
        return objs;
    }

    public ValueNode(String field, String joinstr, String ... values2) {
        this(field, joinstr, ValueNode.fromStrings(values2));
    }

    private String formatField() {
        if (this.field == null || this.field.isEmpty()) {
            return "";
        }
        return '@' + this.field + ':';
    }

    private String toStringCombinable(Node.Parenthesize mode) {
        StringBuilder sb = new StringBuilder(this.formatField());
        if (this.values.length > 1 || mode == Node.Parenthesize.ALWAYS) {
            sb.append('(');
        }
        StringJoiner sj = new StringJoiner(this.joinString);
        for (Value v : this.values) {
            sj.add(v.toString());
        }
        sb.append(sj.toString());
        if (this.values.length > 1 || mode == Node.Parenthesize.ALWAYS) {
            sb.append(')');
        }
        return sb.toString();
    }

    private String toStringDefault(Node.Parenthesize mode) {
        boolean useParen;
        boolean bl = useParen = mode == Node.Parenthesize.ALWAYS;
        if (!useParen) {
            useParen = mode != Node.Parenthesize.NEVER && this.values.length > 1;
        }
        StringBuilder sb = new StringBuilder();
        if (useParen) {
            sb.append('(');
        }
        StringJoiner sj = new StringJoiner(this.joinString);
        for (Value v : this.values) {
            sj.add(this.formatField() + v.toString());
        }
        sb.append(sj.toString());
        if (useParen) {
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public String toString(Node.Parenthesize mode) {
        if (this.values[0].isCombinable()) {
            return this.toStringCombinable(mode);
        }
        return this.toStringDefault(mode);
    }
}

