/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.util.KeyValue;

public class FTSpellCheckParams
implements IParams {
    private Collection<Map.Entry<String, Rawable>> terms;
    private Integer distance;
    private Integer dialect;

    public static FTSpellCheckParams spellCheckParams() {
        return new FTSpellCheckParams();
    }

    public FTSpellCheckParams includeTerm(String dictionary) {
        return this.addTerm(dictionary, SearchProtocol.SearchKeyword.INCLUDE);
    }

    public FTSpellCheckParams excludeTerm(String dictionary) {
        return this.addTerm(dictionary, SearchProtocol.SearchKeyword.EXCLUDE);
    }

    private FTSpellCheckParams addTerm(String dictionary, Rawable type) {
        if (this.terms == null) {
            this.terms = new ArrayList<Map.Entry<String, Rawable>>();
        }
        this.terms.add(KeyValue.of(dictionary, type));
        return this;
    }

    public FTSpellCheckParams distance(int distance) {
        this.distance = distance;
        return this;
    }

    public FTSpellCheckParams dialect(int dialect) {
        this.dialect = dialect;
        return this;
    }

    public FTSpellCheckParams dialectOptional(int dialect) {
        if (dialect != 0 && this.dialect == null) {
            this.dialect = dialect;
        }
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.terms != null) {
            this.terms.forEach(kv -> args2.add(SearchProtocol.SearchKeyword.TERMS).add((Rawable)kv.getValue()).add((String)kv.getKey()));
        }
        if (this.distance != null) {
            args2.add(SearchProtocol.SearchKeyword.DISTANCE).add(this.distance);
        }
        if (this.dialect != null) {
            args2.add(SearchProtocol.SearchKeyword.DIALECT).add(this.dialect);
        }
    }
}

