/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;

public class ZAddParams
implements IParams {
    private Protocol.Keyword existence;
    private Protocol.Keyword comparison;
    private boolean change;

    public static ZAddParams zAddParams() {
        return new ZAddParams();
    }

    public ZAddParams nx() {
        this.existence = Protocol.Keyword.NX;
        return this;
    }

    public ZAddParams xx() {
        this.existence = Protocol.Keyword.XX;
        return this;
    }

    public ZAddParams gt() {
        this.comparison = Protocol.Keyword.GT;
        return this;
    }

    public ZAddParams lt() {
        this.comparison = Protocol.Keyword.LT;
        return this;
    }

    public ZAddParams ch() {
        this.change = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.existence != null) {
            args2.add(this.existence);
        }
        if (this.comparison != null) {
            args2.add(this.comparison);
        }
        if (this.change) {
            args2.add(Protocol.Keyword.CH);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZAddParams that = (ZAddParams)o;
        return this.change == that.change && this.existence == that.existence && this.comparison == that.comparison;
    }

    public int hashCode() {
        return Objects.hash(this.existence, this.comparison, this.change);
    }
}

