/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;

public class LCSParams
implements IParams {
    private boolean len = false;
    private boolean idx = false;
    private Long minMatchLen;
    private boolean withMatchLen = false;

    public static LCSParams LCSParams() {
        return new LCSParams();
    }

    public LCSParams len() {
        this.len = true;
        return this;
    }

    public LCSParams idx() {
        this.idx = true;
        return this;
    }

    public LCSParams minMatchLen(long minMatchLen) {
        this.minMatchLen = minMatchLen;
        return this;
    }

    public LCSParams withMatchLen() {
        this.withMatchLen = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.len) {
            args2.add(Protocol.Keyword.LEN);
        }
        if (this.idx) {
            args2.add(Protocol.Keyword.IDX);
        }
        if (this.minMatchLen != null) {
            args2.add(Protocol.Keyword.MINMATCHLEN).add(this.minMatchLen);
        }
        if (this.withMatchLen) {
            args2.add(Protocol.Keyword.WITHMATCHLEN);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LCSParams lcsParams = (LCSParams)o;
        return this.len == lcsParams.len && this.idx == lcsParams.idx && this.withMatchLen == lcsParams.withMatchLen && Objects.equals(this.minMatchLen, lcsParams.minMatchLen);
    }

    public int hashCode() {
        return Objects.hash(this.len, this.idx, this.minMatchLen, this.withMatchLen);
    }
}

