/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import redis.clients.jedis.Connection;
import redis.clients.jedis.JedisSafeAuthenticator;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.SafeEncoder;

public abstract class JedisPubSubBase<T> {
    private int subscribedChannels = 0;
    private final JedisSafeAuthenticator authenticator = new JedisSafeAuthenticator();
    private final Consumer<Object> pingResultHandler = this::processPingReply;

    public void onMessage(T channel, T message) {
    }

    public void onPMessage(T pattern, T channel, T message) {
    }

    public void onSubscribe(T channel, int subscribedChannels) {
    }

    public void onUnsubscribe(T channel, int subscribedChannels) {
    }

    public void onPUnsubscribe(T pattern, int subscribedChannels) {
    }

    public void onPSubscribe(T pattern, int subscribedChannels) {
    }

    public void onPong(T pattern) {
    }

    private void sendAndFlushCommand(Protocol.Command command, T ... args2) {
        this.authenticator.sendAndFlushCommand(command, args2);
    }

    public final void unsubscribe() {
        this.sendAndFlushCommand(Protocol.Command.UNSUBSCRIBE, new Object[0]);
    }

    public final void unsubscribe(T ... channels) {
        this.sendAndFlushCommand(Protocol.Command.UNSUBSCRIBE, channels);
    }

    public final void subscribe(T ... channels) {
        this.checkConnectionSuitableForPubSub();
        this.sendAndFlushCommand(Protocol.Command.SUBSCRIBE, channels);
    }

    public final void psubscribe(T ... patterns) {
        this.checkConnectionSuitableForPubSub();
        this.sendAndFlushCommand(Protocol.Command.PSUBSCRIBE, patterns);
    }

    private void checkConnectionSuitableForPubSub() {
        if (this.authenticator.client.protocol != RedisProtocol.RESP3 && this.authenticator.client.isTokenBasedAuthenticationEnabled()) {
            throw new JedisException("Blocking pub/sub operations are not supported on token-based authentication enabled connections with RESP2 protocol!");
        }
    }

    public final void punsubscribe() {
        this.sendAndFlushCommand(Protocol.Command.PUNSUBSCRIBE, new Object[0]);
    }

    public final void punsubscribe(T ... patterns) {
        this.sendAndFlushCommand(Protocol.Command.PUNSUBSCRIBE, patterns);
    }

    public final void ping() {
        this.authenticator.commandSync.lock();
        try {
            this.sendAndFlushCommand(Protocol.Command.PING, new Object[0]);
            this.authenticator.resultHandler.add(this.pingResultHandler);
        }
        finally {
            this.authenticator.commandSync.unlock();
        }
    }

    public final void ping(T argument) {
        this.authenticator.commandSync.lock();
        try {
            this.sendAndFlushCommand(Protocol.Command.PING, argument);
            this.authenticator.resultHandler.add(this.pingResultHandler);
        }
        finally {
            this.authenticator.commandSync.unlock();
        }
    }

    public final boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public final int getSubscribedChannels() {
        return this.subscribedChannels;
    }

    public final void proceed(Connection client, T ... channels) {
        this.authenticator.registerForAuthentication(client);
        this.authenticator.client.setTimeoutInfinite();
        try {
            this.subscribe(channels);
            this.process();
        }
        finally {
            this.authenticator.client.rollbackTimeout();
        }
    }

    public final void proceedWithPatterns(Connection client, T ... patterns) {
        this.authenticator.registerForAuthentication(client);
        this.authenticator.client.setTimeoutInfinite();
        try {
            this.psubscribe(patterns);
            this.process();
        }
        finally {
            this.authenticator.client.rollbackTimeout();
        }
    }

    protected abstract T encode(byte[] var1);

    private void process() {
        do {
            Object reply;
            if ((reply = this.authenticator.client.getUnflushedObject()) instanceof List) {
                T enpattern;
                byte[] bpattern;
                T enchannel;
                byte[] bchannel;
                List listReply = (List)reply;
                Object firstObj = listReply.get(0);
                if (!(firstObj instanceof byte[])) {
                    throw new JedisException("Unknown message type: " + firstObj);
                }
                byte[] resp = (byte[])firstObj;
                if (Arrays.equals(Protocol.ResponseKeyword.SUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bchannel = (byte[])listReply.get(1);
                    enchannel = bchannel == null ? null : (T)this.encode(bchannel);
                    this.onSubscribe(enchannel, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.UNSUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bchannel = (byte[])listReply.get(1);
                    enchannel = bchannel == null ? null : (T)this.encode(bchannel);
                    this.onUnsubscribe(enchannel, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.MESSAGE.getRaw(), resp)) {
                    T enchannel2;
                    bchannel = (byte[])listReply.get(1);
                    Object mesg = listReply.get(2);
                    T t = enchannel2 = bchannel == null ? null : (T)this.encode(bchannel);
                    if (mesg instanceof List) {
                        ((List)mesg).forEach(bmesg -> this.onMessage(enchannel2, this.encode((byte[])bmesg)));
                        continue;
                    }
                    this.onMessage(enchannel2, mesg == null ? null : (T)this.encode((byte[])mesg));
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.PMESSAGE.getRaw(), resp)) {
                    bpattern = (byte[])listReply.get(1);
                    byte[] bchannel2 = (byte[])listReply.get(2);
                    byte[] bmesg2 = (byte[])listReply.get(3);
                    T enpattern2 = bpattern == null ? null : (T)this.encode(bpattern);
                    T enchannel3 = bchannel2 == null ? null : (T)this.encode(bchannel2);
                    T enmesg = bmesg2 == null ? null : (T)this.encode(bmesg2);
                    this.onPMessage(enpattern2, enchannel3, enmesg);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.PSUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bpattern = (byte[])listReply.get(1);
                    enpattern = bpattern == null ? null : (T)this.encode(bpattern);
                    this.onPSubscribe(enpattern, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.PUNSUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bpattern = (byte[])listReply.get(1);
                    enpattern = bpattern == null ? null : (T)this.encode(bpattern);
                    this.onPUnsubscribe(enpattern, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.PONG.getRaw(), resp)) {
                    bpattern = (byte[])listReply.get(1);
                    enpattern = bpattern == null ? null : (T)this.encode(bpattern);
                    this.onPong(enpattern);
                    continue;
                }
                throw new JedisException("Unknown message type: " + firstObj);
            }
            if (reply instanceof byte[]) {
                Consumer<Object> resultHandler = this.authenticator.resultHandler.poll();
                if (resultHandler == null) {
                    throw new JedisException("Unexpected message : " + SafeEncoder.encode((byte[])reply));
                }
                resultHandler.accept(reply);
                continue;
            }
            throw new JedisException("Unknown message type: " + reply);
        } while (!Thread.currentThread().isInterrupted() && this.isSubscribed());
    }

    private void processPingReply(Object reply) {
        byte[] resp = (byte[])reply;
        if ("PONG".equals(SafeEncoder.encode(resp))) {
            this.onPong(null);
        } else {
            this.onPong(this.encode(resp));
        }
    }
}

