/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.utils;

import com.minecraftbangladesh.bmsproxycore.utils.ConfigManager;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public class MessageUtils {
    public static Component formatMessage(String message) {
        return LegacyComponentSerializer.legacyAmpersand().deserialize(message);
    }

    public static Component formatStaffChatMessage(Player player, String message, ConfigManager configManager, ProxyServer server) {
        String serverName = player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("Unknown");
        String prefix = configManager.getStaffChatPrefix();
        String format = configManager.getMessageFormat();
        format = format.replace("{prefix}", prefix).replace("{player}", player.getUsername()).replace("{server}", serverName).replace("{message}", message);
        return MessageUtils.formatMessage(format);
    }

    public static Component formatConsoleStaffChatMessage(String message, ConfigManager configManager) {
        String prefix = configManager.getStaffChatPrefix();
        String format = configManager.getMessageFormat();
        format = format.replace("{prefix}", prefix).replace("{player}", "Console").replace("{server}", "Console").replace("{message}", message);
        return MessageUtils.formatMessage(format);
    }

    public static Component formatStaffServerSwitchMessage(Player player, String fromServer, String toServer, ConfigManager configManager) {
        String prefix = configManager.getStaffChatPrefix();
        String format = configManager.getServerSwitchFormat();
        format = format.replace("{prefix}", prefix).replace("{player}", player.getUsername()).replace("{from_server}", fromServer).replace("{to_server}", toServer);
        return MessageUtils.formatMessage(format);
    }

    public static Component formatStaffConnectMessage(Player player, ConfigManager configManager) {
        String prefix = configManager.getStaffChatPrefix();
        String format = configManager.getConnectFormat();
        String serverName = player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("Unknown");
        format = format.replace("{prefix}", prefix).replace("{player}", player.getUsername()).replace("{server}", serverName);
        return MessageUtils.formatMessage(format);
    }

    public static Component formatStaffDisconnectMessage(Player player, ConfigManager configManager) {
        String prefix = configManager.getStaffChatPrefix();
        String format = configManager.getDisconnectFormat();
        String serverName = player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("Unknown");
        format = format.replace("{prefix}", prefix).replace("{player}", player.getUsername()).replace("{server}", serverName);
        return MessageUtils.formatMessage(format);
    }

    public static String stripColorCodes(String message) {
        return message.replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    public static String componentToPlainText(Component component) {
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    public static void broadcastToPermission(ProxyServer server, Component message, String permission) {
        for (Player player : server.getAllPlayers()) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(message);
        }
    }
}

