/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.utils;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.velocitypowered.api.proxy.Player;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class DiscordWebhook {
    private final BMSProxyCore plugin;
    private final OkHttpClient httpClient;
    private static final MediaType JSON = MediaType.parse("application/json; charset=utf-8");

    public DiscordWebhook(BMSProxyCore plugin) {
        this.plugin = plugin;
        this.httpClient = new OkHttpClient();
    }

    public void sendStaffChatMessage(Player player, String message, String server) {
        String avatarUrl;
        if (!this.plugin.getConfigManager().isDiscordEnabled()) {
            return;
        }
        String webhookUrl = this.plugin.getConfigManager().getDiscordWebhookUrl();
        if (webhookUrl.isEmpty() || webhookUrl.equals("https://discord.com/api/webhooks/your-webhook-url-here")) {
            this.plugin.getLogger().warn("Discord webhook URL is not configured properly.");
            return;
        }
        String formattedMessage = this.plugin.getConfigManager().getDiscordMessageFormat().replace("{player}", player.getUsername()).replace("{server}", server).replace("{message}", message);
        JSONObject json = new JSONObject();
        json.put("content", formattedMessage);
        String webhookName = this.plugin.getConfigManager().getDiscordWebhookName();
        if (!webhookName.isEmpty()) {
            json.put("username", webhookName);
        }
        if (this.plugin.getConfigManager().usePlayerAvatar() && !(avatarUrl = this.getCrafatarAvatarUrl(player.getUniqueId().toString())).isEmpty()) {
            json.put("avatar_url", avatarUrl);
        }
        this.sendWebhookRequest(webhookUrl, json);
    }

    public void sendConsoleStaffChatMessage(String message) {
        if (!this.plugin.getConfigManager().isDiscordEnabled()) {
            return;
        }
        String webhookUrl = this.plugin.getConfigManager().getDiscordWebhookUrl();
        if (webhookUrl.isEmpty() || webhookUrl.equals("https://discord.com/api/webhooks/your-webhook-url-here")) {
            this.plugin.getLogger().warn("Discord webhook URL is not configured properly.");
            return;
        }
        String formattedMessage = this.plugin.getConfigManager().getDiscordMessageFormat().replace("{player}", "Console").replace("{server}", "Console").replace("{message}", message);
        JSONObject json = new JSONObject();
        json.put("content", formattedMessage);
        String webhookName = this.plugin.getConfigManager().getDiscordWebhookName();
        if (!webhookName.isEmpty()) {
            json.put("username", webhookName);
        }
        this.sendWebhookRequest(webhookUrl, json);
    }

    public void sendStaffServerSwitchMessage(Player player, String fromServer, String toServer) {
        String avatarUrl;
        if (!this.plugin.getConfigManager().isDiscordEnabled()) {
            return;
        }
        String webhookUrl = this.plugin.getConfigManager().getDiscordWebhookUrl();
        if (webhookUrl.isEmpty() || webhookUrl.equals("https://discord.com/api/webhooks/your-webhook-url-here")) {
            this.plugin.getLogger().warn("Discord webhook URL is not configured properly.");
            return;
        }
        String formattedMessage = this.plugin.getConfigManager().getDiscordServerSwitchFormat().replace("{player}", player.getUsername()).replace("{from_server}", fromServer).replace("{to_server}", toServer);
        JSONObject json = new JSONObject();
        json.put("content", formattedMessage);
        String webhookName = this.plugin.getConfigManager().getDiscordWebhookName();
        if (!webhookName.isEmpty()) {
            json.put("username", webhookName);
        }
        if (this.plugin.getConfigManager().usePlayerAvatar() && !(avatarUrl = this.getCrafatarAvatarUrl(player.getUniqueId().toString())).isEmpty()) {
            json.put("avatar_url", avatarUrl);
        }
        this.sendWebhookRequest(webhookUrl, json);
    }

    public void sendStaffConnectMessage(Player player) {
        String avatarUrl;
        if (!this.plugin.getConfigManager().isDiscordEnabled()) {
            return;
        }
        String webhookUrl = this.plugin.getConfigManager().getDiscordWebhookUrl();
        if (webhookUrl.isEmpty() || webhookUrl.equals("https://discord.com/api/webhooks/your-webhook-url-here")) {
            this.plugin.getLogger().warn("Discord webhook URL is not configured properly.");
            return;
        }
        String serverName = player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("Unknown");
        String formattedMessage = this.plugin.getConfigManager().getDiscordConnectFormat().replace("{player}", player.getUsername()).replace("{server}", serverName);
        JSONObject json = new JSONObject();
        json.put("content", formattedMessage);
        String webhookName = this.plugin.getConfigManager().getDiscordWebhookName();
        if (!webhookName.isEmpty()) {
            json.put("username", webhookName);
        }
        if (this.plugin.getConfigManager().usePlayerAvatar() && !(avatarUrl = this.getCrafatarAvatarUrl(player.getUniqueId().toString())).isEmpty()) {
            json.put("avatar_url", avatarUrl);
        }
        this.sendWebhookRequest(webhookUrl, json);
    }

    public void sendStaffDisconnectMessage(Player player) {
        String avatarUrl;
        if (!this.plugin.getConfigManager().isDiscordEnabled()) {
            return;
        }
        String webhookUrl = this.plugin.getConfigManager().getDiscordWebhookUrl();
        if (webhookUrl.isEmpty() || webhookUrl.equals("https://discord.com/api/webhooks/your-webhook-url-here")) {
            this.plugin.getLogger().warn("Discord webhook URL is not configured properly.");
            return;
        }
        String serverName = player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("Unknown");
        String formattedMessage = this.plugin.getConfigManager().getDiscordDisconnectFormat().replace("{player}", player.getUsername()).replace("{server}", serverName);
        JSONObject json = new JSONObject();
        json.put("content", formattedMessage);
        String webhookName = this.plugin.getConfigManager().getDiscordWebhookName();
        if (!webhookName.isEmpty()) {
            json.put("username", webhookName);
        }
        if (this.plugin.getConfigManager().usePlayerAvatar() && !(avatarUrl = this.getCrafatarAvatarUrl(player.getUniqueId().toString())).isEmpty()) {
            json.put("avatar_url", avatarUrl);
        }
        this.sendWebhookRequest(webhookUrl, json);
    }

    private void sendWebhookRequest(String webhookUrl, JSONObject json) {
        RequestBody body = RequestBody.create(json.toString(), JSON);
        Request request = new Request.Builder().url(webhookUrl).post(body).build();
        this.httpClient.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                DiscordWebhook.this.plugin.getLogger().error("Failed to send Discord webhook", e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                response.close();
                if (!response.isSuccessful()) {
                    DiscordWebhook.this.plugin.getLogger().error("Discord webhook responded with non-OK status: " + response.code());
                }
            }
        });
    }

    private String getCrafatarAvatarUrl(String uuid) {
        StringBuilder urlBuilder = new StringBuilder("https://crafatar.com/avatars/");
        urlBuilder.append(uuid);
        boolean hasParams = false;
        int size = this.plugin.getConfigManager().getAvatarSize();
        if (size > 0 && size <= 512) {
            urlBuilder.append("?size=").append(size);
            hasParams = true;
        }
        if (this.plugin.getConfigManager().useAvatarOverlay()) {
            urlBuilder.append(hasParams ? "&" : "?").append("overlay");
        }
        return urlBuilder.toString();
    }
}

