/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class ConfigManager {
    private final Path dataDirectory;
    private final Path configFile;
    private final Path staffChatConfigFile;
    private final Path privateMessagesConfigFile;
    private final Path lobbyCommandConfigFile;
    private final Path announcementConfigFile;
    private final Path chatControlConfigFile;
    private Map<String, Object> config;
    private Map<String, Object> staffChatConfig;
    private Map<String, Object> privateMessagesConfig;
    private Map<String, Object> lobbyCommandConfig;
    private Map<String, Object> announcementConfig;
    private Map<String, Object> chatControlConfig;

    public ConfigManager(Path dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.configFile = dataDirectory.resolve("config.yml");
        this.staffChatConfigFile = dataDirectory.resolve("modules").resolve("staffchat.yml");
        this.privateMessagesConfigFile = dataDirectory.resolve("modules").resolve("privatemessages.yml");
        this.lobbyCommandConfigFile = dataDirectory.resolve("modules").resolve("lobbycommand.yml");
        this.announcementConfigFile = dataDirectory.resolve("modules").resolve("announcement.yml");
        this.chatControlConfigFile = dataDirectory.resolve("modules").resolve("chatcontrol.yml");
        this.config = new HashMap<String, Object>();
        this.staffChatConfig = new HashMap<String, Object>();
        this.privateMessagesConfig = new HashMap<String, Object>();
        this.lobbyCommandConfig = new HashMap<String, Object>();
        this.announcementConfig = new HashMap<String, Object>();
        this.chatControlConfig = new HashMap<String, Object>();
    }

    public void loadConfig() {
        try {
            if (!Files.exists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            this.loadMainConfig();
            if (this.isStaffChatEnabled()) {
                this.loadStaffChatConfig();
            }
            if (this.isPrivateMessagesEnabled()) {
                this.loadPrivateMessagesConfig();
            }
            if (this.isLobbyCommandEnabled()) {
                this.loadLobbyCommandConfig();
            }
            if (this.isAnnouncementEnabled()) {
                this.loadAnnouncementConfig();
            }
            if (this.isChatControlEnabled()) {
                this.loadChatControlConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadMainConfig() throws IOException {
        if (!Files.exists(this.configFile, new LinkOption[0])) {
            this.saveDefaultConfig();
        }
        try (InputStream inputStream2 = Files.newInputStream(this.configFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            this.config = (Map)yaml.load(inputStream2);
            if (this.config == null) {
                this.config = new HashMap<String, Object>();
            }
        }
    }

    private void loadStaffChatConfig() throws IOException {
        Path modulesDir = this.dataDirectory.resolve("modules");
        if (!Files.exists(modulesDir, new LinkOption[0])) {
            Files.createDirectories(modulesDir, new FileAttribute[0]);
        }
        if (!Files.exists(this.staffChatConfigFile, new LinkOption[0])) {
            this.saveDefaultStaffChatConfig();
        }
        try (InputStream inputStream2 = Files.newInputStream(this.staffChatConfigFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            this.staffChatConfig = (Map)yaml.load(inputStream2);
            if (this.staffChatConfig == null) {
                this.staffChatConfig = new HashMap<String, Object>();
            }
        }
    }

    private void loadPrivateMessagesConfig() throws IOException {
        Path modulesDir = this.dataDirectory.resolve("modules");
        if (!Files.exists(modulesDir, new LinkOption[0])) {
            Files.createDirectories(modulesDir, new FileAttribute[0]);
        }
        if (!Files.exists(this.privateMessagesConfigFile, new LinkOption[0])) {
            this.saveDefaultPrivateMessagesConfig();
        }
        try (InputStream inputStream2 = Files.newInputStream(this.privateMessagesConfigFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            this.privateMessagesConfig = (Map)yaml.load(inputStream2);
            if (this.privateMessagesConfig == null) {
                this.privateMessagesConfig = new HashMap<String, Object>();
            }
        }
    }

    public boolean isStaffChatEnabled() {
        Map<String, Object> modulesSection = this.getSection("modules");
        if (modulesSection == null) {
            return true;
        }
        Object staffChatObj = modulesSection.get("staffchat");
        if (!(staffChatObj instanceof Map)) {
            return true;
        }
        Map staffChatSection = (Map)staffChatObj;
        Object enabled = staffChatSection.get("enabled");
        return enabled instanceof Boolean ? (Boolean)enabled : true;
    }

    public boolean isPrivateMessagesEnabled() {
        Map<String, Object> modulesSection = this.getSection("modules");
        if (modulesSection == null) {
            return true;
        }
        Object privateMessagesObj = modulesSection.get("private_messages");
        if (!(privateMessagesObj instanceof Map)) {
            return true;
        }
        Map privateMessagesSection = (Map)privateMessagesObj;
        Object enabled = privateMessagesSection.get("enabled");
        return enabled instanceof Boolean ? (Boolean)enabled : true;
    }

    public boolean isLobbyCommandEnabled() {
        Map<String, Object> modulesSection = this.getSection("modules");
        if (modulesSection == null) {
            return true;
        }
        Object lobbyCommandObj = modulesSection.get("lobby_command");
        if (!(lobbyCommandObj instanceof Map)) {
            return true;
        }
        Map lobbyCommandSection = (Map)lobbyCommandObj;
        Object enabled = lobbyCommandSection.get("enabled");
        return enabled instanceof Boolean ? (Boolean)enabled : true;
    }

    public boolean isAnnouncementEnabled() {
        Map<String, Object> modulesSection = this.getSection("modules");
        if (modulesSection == null) {
            return true;
        }
        Object announcementObj = modulesSection.get("announcement");
        if (!(announcementObj instanceof Map)) {
            return true;
        }
        Map announcementSection = (Map)announcementObj;
        Object enabled = announcementSection.get("enabled");
        return enabled instanceof Boolean ? (Boolean)enabled : true;
    }

    public boolean isChatControlEnabled() {
        Map<String, Object> modulesSection = this.getSection("modules");
        if (modulesSection == null) {
            return true;
        }
        Object chatControlObj = modulesSection.get("chatcontrol");
        if (!(chatControlObj instanceof Map)) {
            return true;
        }
        Map chatControlSection = (Map)chatControlObj;
        Object enabled = chatControlSection.get("enabled");
        return enabled instanceof Boolean ? (Boolean)enabled : true;
    }

    private void saveDefaultStaffChatConfig() {
        try (InputStream inputStream2 = this.getClass().getClassLoader().getResourceAsStream("modules/staffchat.yml");
             OutputStream outputStream2 = Files.newOutputStream(this.staffChatConfigFile, new OpenOption[0]);){
            if (inputStream2 != null) {
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inputStream2.read(buffer)) > 0) {
                    outputStream2.write(buffer, 0, length);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDefaultPrivateMessagesConfig() {
        try (InputStream inputStream2 = this.getClass().getClassLoader().getResourceAsStream("modules/privatemessages.yml");
             OutputStream outputStream2 = Files.newOutputStream(this.privateMessagesConfigFile, new OpenOption[0]);){
            if (inputStream2 != null) {
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inputStream2.read(buffer)) > 0) {
                    outputStream2.write(buffer, 0, length);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadLobbyCommandConfig() throws IOException {
        Path modulesDir = this.dataDirectory.resolve("modules");
        if (!Files.exists(modulesDir, new LinkOption[0])) {
            Files.createDirectories(modulesDir, new FileAttribute[0]);
        }
        if (!Files.exists(this.lobbyCommandConfigFile, new LinkOption[0])) {
            this.saveDefaultLobbyCommandConfig();
        }
        try (InputStream inputStream2 = Files.newInputStream(this.lobbyCommandConfigFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            this.lobbyCommandConfig = (Map)yaml.load(inputStream2);
            if (this.lobbyCommandConfig == null) {
                this.lobbyCommandConfig = new HashMap<String, Object>();
            }
        }
    }

    private void loadAnnouncementConfig() throws IOException {
        Path modulesDir = this.dataDirectory.resolve("modules");
        if (!Files.exists(modulesDir, new LinkOption[0])) {
            Files.createDirectories(modulesDir, new FileAttribute[0]);
        }
        if (!Files.exists(this.announcementConfigFile, new LinkOption[0])) {
            this.saveDefaultAnnouncementConfig();
        }
        try (InputStream inputStream2 = Files.newInputStream(this.announcementConfigFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            this.announcementConfig = (Map)yaml.load(inputStream2);
            if (this.announcementConfig == null) {
                this.announcementConfig = new HashMap<String, Object>();
            }
        }
    }

    private void loadChatControlConfig() throws IOException {
        Path modulesDir = this.dataDirectory.resolve("modules");
        if (!Files.exists(modulesDir, new LinkOption[0])) {
            Files.createDirectories(modulesDir, new FileAttribute[0]);
        }
        if (!Files.exists(this.chatControlConfigFile, new LinkOption[0])) {
            this.saveDefaultChatControlConfig();
        }
        try (InputStream inputStream2 = Files.newInputStream(this.chatControlConfigFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            this.chatControlConfig = (Map)yaml.load(inputStream2);
            if (this.chatControlConfig == null) {
                this.chatControlConfig = new HashMap<String, Object>();
            }
        }
    }

    private void saveDefaultLobbyCommandConfig() {
        try (InputStream inputStream2 = this.getClass().getClassLoader().getResourceAsStream("modules/lobbycommand.yml");
             OutputStream outputStream2 = Files.newOutputStream(this.lobbyCommandConfigFile, new OpenOption[0]);){
            if (inputStream2 != null) {
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inputStream2.read(buffer)) > 0) {
                    outputStream2.write(buffer, 0, length);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDefaultAnnouncementConfig() {
        try (InputStream inputStream2 = this.getClass().getClassLoader().getResourceAsStream("modules/announcement.yml");
             OutputStream outputStream2 = Files.newOutputStream(this.announcementConfigFile, new OpenOption[0]);){
            if (inputStream2 != null) {
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inputStream2.read(buffer)) > 0) {
                    outputStream2.write(buffer, 0, length);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDefaultChatControlConfig() {
        try (InputStream inputStream2 = this.getClass().getClassLoader().getResourceAsStream("modules/chatcontrol.yml");
             OutputStream outputStream2 = Files.newOutputStream(this.chatControlConfigFile, new OpenOption[0]);){
            if (inputStream2 != null) {
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inputStream2.read(buffer)) > 0) {
                    outputStream2.write(buffer, 0, length);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDefaultConfig() {
        try (InputStream inputStream2 = this.getClass().getClassLoader().getResourceAsStream("config.yml");
             OutputStream outputStream2 = Files.newOutputStream(this.configFile, new OpenOption[0]);){
            if (inputStream2 != null) {
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inputStream2.read(buffer)) > 0) {
                    outputStream2.write(buffer, 0, length);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getString(String path, String defaultValue) {
        Object value = this.config.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    public String getString(String path) {
        return this.getString(path, "");
    }

    public Map<String, Object> getSection(String path) {
        Object value = this.config.get(path);
        return value instanceof Map ? (Map)value : new HashMap();
    }

    private String getStaffChatString(String path, String defaultValue) {
        if (!this.isStaffChatEnabled()) {
            return defaultValue;
        }
        Object value = this.staffChatConfig.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private Map<String, Object> getStaffChatSection(String path) {
        if (!this.isStaffChatEnabled()) {
            return new HashMap<String, Object>();
        }
        Object value = this.staffChatConfig.get(path);
        return value instanceof Map ? (Map)value : new HashMap();
    }

    private String getStaffChatNestedString(String section, String path, String defaultValue) {
        if (!this.isStaffChatEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getStaffChatSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private String getLobbyCommandNestedString(String section, String path, String defaultValue) {
        if (!this.isLobbyCommandEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getLobbyCommandSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private Map<String, Object> getLobbyCommandSection(String path) {
        if (!this.isLobbyCommandEnabled()) {
            return new HashMap<String, Object>();
        }
        Object value = this.lobbyCommandConfig.get(path);
        return value instanceof Map ? (Map)value : new HashMap();
    }

    private boolean getStaffChatNestedBoolean(String section, String path, boolean defaultValue) {
        if (!this.isStaffChatEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getStaffChatSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    private int getStaffChatNestedInt(String section, String path, int defaultValue) {
        if (!this.isStaffChatEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getStaffChatSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private String getStaffChatDoubleNestedString(String section, String subsection, String path, String defaultValue) {
        if (!this.isStaffChatEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getStaffChatSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object subsectionObj = sectionMap.get(subsection);
        if (!(subsectionObj instanceof Map)) {
            return defaultValue;
        }
        Map subsectionMap = (Map)subsectionObj;
        Object value = subsectionMap.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private int getStaffChatDoubleNestedInt(String section, String subsection, String path, int defaultValue) {
        if (!this.isStaffChatEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getStaffChatSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object subsectionObj = sectionMap.get(subsection);
        if (!(subsectionObj instanceof Map)) {
            return defaultValue;
        }
        Map subsectionMap = (Map)subsectionObj;
        Object value = subsectionMap.get(path);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private String getPrivateMessagesString(String path, String defaultValue) {
        if (!this.isPrivateMessagesEnabled()) {
            return defaultValue;
        }
        Object value = this.privateMessagesConfig.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private Map<String, Object> getPrivateMessagesSection(String section) {
        if (!this.isPrivateMessagesEnabled()) {
            return null;
        }
        Object sectionObj = this.privateMessagesConfig.get(section);
        return sectionObj instanceof Map ? (Map)sectionObj : null;
    }

    private String getPrivateMessagesNestedString(String section, String path, String defaultValue) {
        if (!this.isPrivateMessagesEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getPrivateMessagesSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private boolean getPrivateMessagesNestedBoolean(String section, String path, boolean defaultValue) {
        if (!this.isPrivateMessagesEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getPrivateMessagesSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    private int getPrivateMessagesNestedInt(String section, String path, int defaultValue) {
        if (!this.isPrivateMessagesEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getPrivateMessagesSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private String getPrivateMessagesDoubleNestedString(String section, String subsection, String path, String defaultValue) {
        if (!this.isPrivateMessagesEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getPrivateMessagesSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object subsectionObj = sectionMap.get(subsection);
        if (!(subsectionObj instanceof Map)) {
            return defaultValue;
        }
        Map subsectionMap = (Map)subsectionObj;
        Object value = subsectionMap.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private String getLobbyCommandString(String path, String defaultValue) {
        if (!this.isLobbyCommandEnabled()) {
            return defaultValue;
        }
        Object value = this.lobbyCommandConfig.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private int getLobbyCommandInt(String path, int defaultValue) {
        if (!this.isLobbyCommandEnabled()) {
            return defaultValue;
        }
        Object value = this.lobbyCommandConfig.get(path);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private List<String> getLobbyCommandStringList(String path, List<String> defaultValue) {
        if (!this.isLobbyCommandEnabled()) {
            return defaultValue;
        }
        Object value = this.lobbyCommandConfig.get(path);
        return value instanceof List ? (List)value : defaultValue;
    }

    public String getNestedString(String section, String path, String defaultValue) {
        Map<String, Object> sectionMap = this.getSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    public boolean getNestedBoolean(String section, String path, boolean defaultValue) {
        Map<String, Object> sectionMap = this.getSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public int getNestedInt(String section, String path, int defaultValue) {
        Map<String, Object> sectionMap = this.getSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String getStaffChatPrefix() {
        return this.getStaffChatString("staffchat-prefix", "&b&lStaff &8|");
    }

    public String getMessageFormat() {
        return this.getStaffChatString("message-format", "{prefix} &7[{server}] &f{player} &8\u00bb&r {message}");
    }

    public String getToggleOnMessage() {
        return this.getStaffChatString("toggle-on-message", "&aStaff chat mode &eenabled&a. Your messages will now go to staff chat.");
    }

    public String getToggleOffMessage() {
        return this.getStaffChatString("toggle-off-message", "&aStaff chat mode &cdisabled&a. Your messages will now go to public chat.");
    }

    public String getNoPermissionMessage() {
        return this.getNestedString("global", "no-permission-message", "&cYou don't have permission to use this command.");
    }

    public String getReloadSuccessMessage() {
        return this.getNestedString("global", "reload-success-message", "&aConfiguration successfully reloaded.");
    }

    public String getReloadFailMessage() {
        return this.getNestedString("global", "reload-fail-message", "&cFailed to reload configuration. Check console for errors.");
    }

    public String getModuleDisabledMessage() {
        return this.getNestedString("global", "module-disabled-message", "&cThis feature is currently disabled.");
    }

    public String getModuleConfigMissingMessage() {
        return this.getNestedString("global", "module-config-missing", "&cConfiguration file for {module} module is missing.");
    }

    public boolean isDiscordEnabled() {
        return this.getStaffChatNestedBoolean("discord", "enabled", false);
    }

    public String getDiscordWebhookUrl() {
        return this.getStaffChatNestedString("discord", "webhook-url", "");
    }

    public String getDiscordWebhookName() {
        return this.getStaffChatNestedString("discord", "webhook-name", "Staff Chat");
    }

    public String getDiscordMessageFormat() {
        return this.getStaffChatNestedString("discord", "message-format", "**[{server}] {player}**: {message}");
    }

    public boolean usePlayerAvatar() {
        return this.getStaffChatNestedBoolean("discord", "use-player-avatar", true);
    }

    public int getAvatarSize() {
        return this.getStaffChatNestedInt("discord", "avatar-size", 128);
    }

    public boolean useAvatarOverlay() {
        return this.getStaffChatNestedBoolean("discord", "avatar-overlay", true);
    }

    public String getServerSwitchFormat() {
        return this.getStaffChatString("server-switch-format", "{prefix} &e{player} &7switched from &6{from_server} &7to &6{to_server}");
    }

    public String getConnectFormat() {
        return this.getStaffChatString("connect-format", "{prefix} &e{player} &ajoined &7the network");
    }

    public String getDisconnectFormat() {
        return this.getStaffChatString("disconnect-format", "{prefix} &e{player} &cleft &7the network");
    }

    public String getDiscordServerSwitchFormat() {
        return this.getStaffChatNestedString("discord", "server-switch-format", "**{player}** switched from **{from_server}** to **{to_server}**");
    }

    public String getDiscordConnectFormat() {
        return this.getStaffChatNestedString("discord", "connect-format", "**{player}** joined the network");
    }

    public String getDiscordDisconnectFormat() {
        return this.getStaffChatNestedString("discord", "disconnect-format", "**{player}** left the network");
    }

    public String getMessagingSenderFormat() {
        return this.getPrivateMessagesString("sender-format", "&8[&7You &8\u2192 &7{receiver}&8] &f{message}");
    }

    public String getMessagingReceiverFormat() {
        return this.getPrivateMessagesString("receiver-format", "&8[&7{sender} &8\u2192 &7You&8] &f{message}");
    }

    public String getMessagingSocialSpyFormat() {
        return this.getPrivateMessagesString("socialspy-format", "&8[&cSPY&8] &7{sender} &8\u2192 &7{receiver}&8: &f{message}");
    }

    public String getMessagingErrorPlayerNotFound() {
        return this.getPrivateMessagesString("error-player-not-found", "&cPlayer not found.");
    }

    public String getMessagingErrorMessageSelf() {
        return this.getPrivateMessagesString("error-message-self", "&cYou cannot message yourself.");
    }

    public String getMessagingErrorNoReplyTarget() {
        return this.getPrivateMessagesString("error-no-reply-target", "&cYou have nobody to reply to.");
    }

    public String getMessagingErrorInvalidUsageMsg() {
        return this.getPrivateMessagesString("error-invalid-usage-msg", "&cUsage: /msg <player> <message>");
    }

    public String getMessagingErrorInvalidUsageReply() {
        return this.getPrivateMessagesString("error-invalid-usage-reply", "&cUsage: /reply <message>");
    }

    public String getMessagingSocialSpyEnabled() {
        return this.getPrivateMessagesString("socialspy-enabled", "&aSocial spy enabled. You will now see private messages.");
    }

    public String getMessagingSocialSpyDisabled() {
        return this.getPrivateMessagesString("socialspy-disabled", "&cSocial spy disabled. You will no longer see private messages.");
    }

    public String getMessagingToggleEnabled() {
        return this.getPrivateMessagesString("msgtoggle-enabled", "&aYou are now accepting private messages.");
    }

    public String getMessagingToggleDisabled() {
        return this.getPrivateMessagesString("msgtoggle-disabled", "&cYou are no longer accepting private messages.");
    }

    public String getMessagingErrorPlayerToggled() {
        return this.getPrivateMessagesString("error-player-msgtoggle", "&c{player} is not accepting private messages.");
    }

    public String getMessagingIgnoreAdded() {
        return this.getPrivateMessagesString("ignore-added", "&aYou are now ignoring {player}.");
    }

    public String getMessagingIgnoreRemoved() {
        return this.getPrivateMessagesString("ignore-removed", "&aYou are no longer ignoring {player}.");
    }

    public String getMessagingErrorAlreadyIgnoring() {
        return this.getPrivateMessagesString("error-already-ignoring", "&cYou are already ignoring {player}.");
    }

    public String getMessagingErrorNotIgnoring() {
        return this.getPrivateMessagesString("error-not-ignoring", "&cYou are not ignoring {player}.");
    }

    public String getMessagingErrorPlayerIgnored() {
        return this.getPrivateMessagesString("error-player-ignored", "&c{player} is ignoring you.");
    }

    public String getMessagingErrorInvalidUsageIgnore() {
        return this.getPrivateMessagesString("error-invalid-usage-ignore", "&cUsage: /ignore <add|remove|list> [player]");
    }

    public String getMessagingIgnoreListHeader() {
        return this.getPrivateMessagesString("ignore-list-header", "&6Players you are ignoring:");
    }

    public String getMessagingIgnoreListEntry() {
        return this.getPrivateMessagesString("ignore-list-entry", "&7- {player}");
    }

    public String getMessagingIgnoreListEmpty() {
        return this.getPrivateMessagesString("ignore-list-empty", "&7You are not ignoring any players.");
    }

    public String getLobbyTargetServer() {
        return this.getLobbyCommandString("target-server", "lobby");
    }

    public String getLobbyMainCommand() {
        return this.getLobbyCommandString("main-command", "lobby");
    }

    public List<String> getLobbyCommandAliases() {
        return this.getLobbyCommandStringList("aliases", Arrays.asList("hub", "spawn", "main", "l"));
    }

    public String getLobbyPermission() {
        return this.getLobbyUsePermission();
    }

    public String getLobbySuccessMessage() {
        return this.getLobbyCommandString("success-message", "&aTeleporting to lobby...");
    }

    public String getLobbyAlreadyOnServerMessage() {
        return this.getLobbyCommandString("already-on-server-message", "&eYou are already on the lobby server!");
    }

    public String getLobbyServerNotFoundMessage() {
        return this.getLobbyCommandString("server-not-found-message", "&cLobby server is currently unavailable. Please try again later.");
    }

    public String getLobbyTeleportFailedMessage() {
        return this.getLobbyCommandString("teleport-failed-message", "&cFailed to teleport to lobby. Please try again.");
    }

    public String getLobbyNoPermissionMessage() {
        return this.getLobbyCommandString("no-permission-message", "&cYou don't have permission to use this command.");
    }

    public int getLobbyCooldown() {
        return this.getLobbyCommandInt("cooldown", 3);
    }

    public String getLobbyCooldownMessage() {
        return this.getLobbyCommandString("cooldown-message", "&cYou must wait {time} seconds before using this command again.");
    }

    public String getLobbyCooldownBypassPermission() {
        return this.getLobbyCommandNestedString("permissions", "bypass-cooldown", "bmsproxycore.lobby.cooldown.bypass");
    }

    public String getStaffChatUsePermission() {
        return this.getStaffChatNestedString("permissions", "use", "bmsproxycore.staffchat.use");
    }

    public String getStaffChatTogglePermission() {
        return this.getStaffChatNestedString("permissions", "toggle", "bmsproxycore.staffchat.toggle");
    }

    public String getStaffChatReloadPermission() {
        return this.getStaffChatNestedString("permissions", "reload", "bmsproxycore.staffchat.reload");
    }

    public String getStaffChatActivityPermission() {
        return this.getStaffChatNestedString("permissions", "activity", "bmsproxycore.staffchat.activity");
    }

    public boolean isRedisEnabled() {
        return this.getStaffChatNestedBoolean("redis", "enabled", false);
    }

    public String getRedisHost() {
        return this.getStaffChatNestedString("redis", "host", "localhost");
    }

    public int getRedisPort() {
        return this.getStaffChatNestedInt("redis", "port", 6379);
    }

    public String getRedisPassword() {
        return this.getStaffChatNestedString("redis", "password", "");
    }

    public int getRedisDatabase() {
        return this.getStaffChatNestedInt("redis", "database", 0);
    }

    public int getRedisPoolMaxTotal() {
        return this.getStaffChatDoubleNestedInt("redis", "pool", "max-total", 8);
    }

    public int getRedisPoolMaxIdle() {
        return this.getStaffChatDoubleNestedInt("redis", "pool", "max-idle", 8);
    }

    public int getRedisPoolMinIdle() {
        return this.getStaffChatDoubleNestedInt("redis", "pool", "min-idle", 0);
    }

    public int getRedisPoolTimeout() {
        return this.getStaffChatDoubleNestedInt("redis", "pool", "timeout", 2000);
    }

    public String getRedisProxyId() {
        return this.getStaffChatDoubleNestedString("redis", "messaging", "proxy-id", "proxy-1");
    }

    public String getRedisChatChannel() {
        return this.getStaffChatDoubleNestedString("redis", "messaging", "chat-channel", "bmsproxycore:staffchat:messages");
    }

    public String getRedisActivityChannel() {
        return this.getStaffChatDoubleNestedString("redis", "messaging", "activity-channel", "bmsproxycore:staffchat:activity");
    }

    public String getCrossProxyMessageFormat() {
        return this.getStaffChatString("cross-proxy-format", "{prefix} &7[{proxy}:{server}] &f{player} &8\u00bb&r {message}");
    }

    public String getCrossProxyServerSwitchFormat() {
        return this.getStaffChatString("cross-proxy-server-switch-format", "{prefix} &e{player} &7switched from &6{from_server} &7to &6{to_server} &8(&7{proxy}&8)");
    }

    public String getCrossProxyConnectFormat() {
        return this.getStaffChatString("cross-proxy-connect-format", "{prefix} &e{player} &ajoined &7the network &8(&7{proxy}&8)");
    }

    public String getCrossProxyDisconnectFormat() {
        return this.getStaffChatString("cross-proxy-disconnect-format", "{prefix} &e{player} &cleft &7the network &8(&7{proxy}&8)");
    }

    public boolean isPrivateMessagesRedisEnabled() {
        return this.getPrivateMessagesNestedBoolean("redis", "enabled", false);
    }

    public String getPrivateMessagesRedisHost() {
        String host = this.getPrivateMessagesNestedString("redis", "host", "");
        return host.isEmpty() ? this.getRedisHost() : host;
    }

    public int getPrivateMessagesRedisPort() {
        int port = this.getPrivateMessagesNestedInt("redis", "port", 0);
        return port == 0 ? this.getRedisPort() : port;
    }

    public String getPrivateMessagesRedisPassword() {
        String password = this.getPrivateMessagesNestedString("redis", "password", "");
        return password.isEmpty() ? this.getRedisPassword() : password;
    }

    public int getPrivateMessagesRedisDatabase() {
        int database = this.getPrivateMessagesNestedInt("redis", "database", 0);
        return database == 0 ? this.getRedisDatabase() : database;
    }

    public String getPrivateMessagesRedisProxyId() {
        String proxyId = this.getPrivateMessagesDoubleNestedString("redis", "messaging", "proxy-id", "");
        return proxyId.isEmpty() ? this.getRedisProxyId() : proxyId;
    }

    public String getPrivateMessagesMessageChannel() {
        return this.getPrivateMessagesDoubleNestedString("redis", "messaging", "message-channel", "bmsproxycore:privatemessages:messages");
    }

    public String getPrivateMessagesLookupChannel() {
        return this.getPrivateMessagesDoubleNestedString("redis", "messaging", "lookup-channel", "bmsproxycore:privatemessages:lookup");
    }

    public String getPrivateMessagesLookupResponseChannel() {
        return this.getPrivateMessagesDoubleNestedString("redis", "messaging", "lookup-response-channel", "bmsproxycore:privatemessages:lookup-response");
    }

    public String getPrivateMessagesSocialSpyChannel() {
        return this.getPrivateMessagesDoubleNestedString("redis", "messaging", "socialspy-channel", "bmsproxycore:privatemessages:socialspy");
    }

    public String getPrivateMessagesReplyChannel() {
        return this.getPrivateMessagesDoubleNestedString("redis", "messaging", "reply-channel", "bmsproxycore:privatemessages:reply");
    }

    public String getCrossProxyPrivateMessageSenderFormat() {
        return this.getPrivateMessagesString("cross-proxy-sender-format", "&8[&7You &8\u2192 &7{receiver}&8@&6{proxy}&8] &f{message}");
    }

    public String getCrossProxyPrivateMessageReceiverFormat() {
        return this.getPrivateMessagesString("cross-proxy-receiver-format", "&8[&7{sender}&8@&6{proxy} &8\u2192 &7You&8] &f{message}");
    }

    public String getCrossProxyPrivateMessageSocialSpyFormat() {
        return this.getPrivateMessagesString("cross-proxy-socialspy-format", "&8[&cSPY&8] &7{sender}&8@&6{sender_proxy} &8\u2192 &7{receiver}&8@&6{receiver_proxy}&8: &f{message}");
    }

    public String getCrossProxyPlayerNotFoundMessage() {
        return this.getPrivateMessagesString("cross-proxy-player-not-found", "&cPlayer not found on any connected proxy.");
    }

    public String getCrossProxyDeliveryFailedMessage() {
        return this.getPrivateMessagesString("cross-proxy-delivery-failed", "&cFailed to deliver message to {player}. They may have disconnected.");
    }

    public String getCrossProxyLookupTimeoutMessage() {
        return this.getPrivateMessagesString("cross-proxy-lookup-timeout", "&cPlayer lookup timed out. Please try again.");
    }

    public String getPrivateMessagesSendPermission() {
        return this.getPrivateMessagesNestedString("permissions", "send", "bmsproxycore.message.send");
    }

    public String getPrivateMessagesReplyPermission() {
        return this.getPrivateMessagesNestedString("permissions", "reply", "bmsproxycore.message.reply");
    }

    public String getPrivateMessagesSocialSpyPermission() {
        return this.getPrivateMessagesNestedString("permissions", "socialspy", "bmsproxycore.message.socialspy");
    }

    public String getPrivateMessagesTogglePermission() {
        return this.getPrivateMessagesNestedString("permissions", "toggle", "bmsproxycore.message.toggle");
    }

    public String getPrivateMessagesIgnorePermission() {
        return this.getPrivateMessagesNestedString("permissions", "ignore", "bmsproxycore.message.ignore");
    }

    public String getPrivateMessagesBypassTogglePermission() {
        return this.getPrivateMessagesNestedString("permissions", "bypass-toggle", "bmsproxycore.message.bypass.toggle");
    }

    public String getPrivateMessagesBypassIgnorePermission() {
        return this.getPrivateMessagesNestedString("permissions", "bypass-ignore", "bmsproxycore.message.bypass.ignore");
    }

    public String getLobbyUsePermission() {
        return this.getLobbyCommandNestedString("permissions", "use", "bmsproxycore.lobby.use");
    }

    private String getAnnouncementString(String path, String defaultValue) {
        if (!this.isAnnouncementEnabled()) {
            return defaultValue;
        }
        Object value = this.announcementConfig.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private Map<String, Object> getAnnouncementSection(String path) {
        if (!this.isAnnouncementEnabled()) {
            return new HashMap<String, Object>();
        }
        Object value = this.announcementConfig.get(path);
        return value instanceof Map ? (Map)value : new HashMap();
    }

    private String getAnnouncementNestedString(String section, String path, String defaultValue) {
        if (!this.isAnnouncementEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getAnnouncementSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private boolean getAnnouncementNestedBoolean(String section, String path, boolean defaultValue) {
        if (!this.isAnnouncementEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getAnnouncementSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    private List<String> getAnnouncementStringList(String path, List<String> defaultValue) {
        if (!this.isAnnouncementEnabled()) {
            return defaultValue;
        }
        Object value = this.announcementConfig.get(path);
        return value instanceof List ? (List)value : defaultValue;
    }

    public String getAnnouncementMainCommand() {
        return this.getAnnouncementString("main-command", "announce");
    }

    public List<String> getAnnouncementCommandAliases() {
        return this.getAnnouncementStringList("aliases", Arrays.asList("announcement", "alert"));
    }

    public String getAnnouncementSendPermission() {
        return this.getAnnouncementNestedString("permissions", "send", "bmsproxycore.announcement.send");
    }

    public boolean isAnnouncementTitleEnabled() {
        return this.getAnnouncementNestedBoolean("title", "enabled", true);
    }

    public String getAnnouncementTitleMainTitle() {
        return this.getAnnouncementNestedString("title", "main-title", "&c&l< ALERT >");
    }

    public String getAnnouncementTitleSubtitle() {
        return this.getAnnouncementNestedString("title", "subtitle", "&f{announcement}");
    }

    public int getAnnouncementTitleFadeIn() {
        Map<String, Object> titleSection = this.getAnnouncementSection("title");
        Object timingObj = titleSection.get("timing");
        if (!(timingObj instanceof Map)) {
            return 10;
        }
        Map timingSection = (Map)timingObj;
        Object value = timingSection.get("fade-in");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return 10;
            }
        }
        return 10;
    }

    public int getAnnouncementTitleStay() {
        Map<String, Object> titleSection = this.getAnnouncementSection("title");
        Object timingObj = titleSection.get("timing");
        if (!(timingObj instanceof Map)) {
            return 60;
        }
        Map timingSection = (Map)timingObj;
        Object value = timingSection.get("stay");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return 60;
            }
        }
        return 60;
    }

    public int getAnnouncementTitleFadeOut() {
        Map<String, Object> titleSection = this.getAnnouncementSection("title");
        Object timingObj = titleSection.get("timing");
        if (!(timingObj instanceof Map)) {
            return 10;
        }
        Map timingSection = (Map)timingObj;
        Object value = timingSection.get("fade-out");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return 10;
            }
        }
        return 10;
    }

    public boolean isAnnouncementChatMessageEnabled() {
        return this.getAnnouncementNestedBoolean("chat-message", "enabled", true);
    }

    public String getAnnouncementChatMessageFormat() {
        return this.getAnnouncementNestedString("chat-message", "format", "&8[&c&lALERT&8] &f{announcement}");
    }

    public String getAnnouncementConsoleFormat() {
        return this.getAnnouncementNestedString("chat-message", "console-format", "&8[&c&lALERT&8] &7[Console] &f{announcement}");
    }

    public boolean isAnnouncementNetworkEnabled() {
        return this.getAnnouncementNestedBoolean("network", "enabled", true);
    }

    public boolean isAnnouncementShowSender() {
        return this.getAnnouncementNestedBoolean("network", "show-sender", false);
    }

    public String getAnnouncementSenderFormat() {
        return this.getAnnouncementNestedString("network", "sender-format", "&8[&c&lALERT&8] &7[{server}] &e{sender}&8: &f{announcement}");
    }

    public String getAnnouncementSuccessMessage() {
        return this.getAnnouncementString("success-message", "&aAnnouncement sent to all players across the network!");
    }

    public String getAnnouncementEmptyMessage() {
        return this.getAnnouncementString("empty-message", "&cPlease provide an announcement message.");
    }

    public String getAnnouncementNoPermissionMessage() {
        return this.getAnnouncementString("no-permission-message", "&cYou don't have permission to send announcements.");
    }

    public String getAnnouncementUsageMessage() {
        return this.getAnnouncementString("usage-message", "&cUsage: /{command} <message>");
    }

    public String getAnnouncementConsoleUsageMessage() {
        return this.getAnnouncementString("console-usage-message", "&7Usage: /{command} <message> - Send an announcement to all players");
    }

    private Map<String, Object> getChatControlSection(String path) {
        if (!this.isChatControlEnabled()) {
            return new HashMap<String, Object>();
        }
        Object value = this.chatControlConfig.get(path);
        return value instanceof Map ? (Map)value : new HashMap();
    }

    private String getChatControlNestedString(String section, String path, String defaultValue) {
        if (!this.isChatControlEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getChatControlSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private String getChatControlDoubleNestedString(String section, String subsection, String path, String defaultValue) {
        if (!this.isChatControlEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getChatControlSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object subsectionObj = sectionMap.get(subsection);
        if (!(subsectionObj instanceof Map)) {
            return defaultValue;
        }
        Map subsectionMap = (Map)subsectionObj;
        Object value = subsectionMap.get(path);
        return value instanceof String ? (String)value : defaultValue;
    }

    private int getChatControlNestedInt(String section, String path, int defaultValue) {
        if (!this.isChatControlEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getChatControlSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    private boolean getChatControlNestedBoolean(String section, String path, boolean defaultValue) {
        if (!this.isChatControlEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getChatControlSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object value = sectionMap.get(path);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public boolean isChatFilterEnabled() {
        return this.getChatControlNestedBoolean("components", "filter", true) && this.getChatControlNestedBoolean("components", "enabled", true);
    }

    public boolean isChatCooldownEnabled() {
        return this.getChatControlNestedBoolean("components", "cooldown", true) && this.getChatControlNestedBoolean("components", "enabled", true);
    }

    public String getChatFilterManagePermission() {
        return this.getChatControlDoubleNestedString("permissions", "filter", "manage", "bmsproxycore.chatcontrol.filter.manage");
    }

    public String getChatFilterBypassPermission() {
        return this.getChatControlDoubleNestedString("permissions", "filter", "bypass", "bmsproxycore.chatcontrol.filter.bypass");
    }

    public String getChatFilterReloadPermission() {
        return this.getChatControlDoubleNestedString("permissions", "filter", "reload", "bmsproxycore.chatcontrol.filter.reload");
    }

    public String getChatCooldownManagePermission() {
        return this.getChatControlDoubleNestedString("permissions", "cooldown", "manage", "bmsproxycore.chatcontrol.cooldown.manage");
    }

    public String getChatCooldownBypassPermission() {
        return this.getChatControlDoubleNestedString("permissions", "cooldown", "bypass", "bmsproxycore.chatcontrol.cooldown.bypass");
    }

    public String getChatCooldownReloadPermission() {
        return this.getChatControlDoubleNestedString("permissions", "cooldown", "reload", "bmsproxycore.chatcontrol.cooldown.reload");
    }

    public String getClearChatUsePermission() {
        return this.getChatControlDoubleNestedString("permissions", "clearchat", "use", "bmsproxycore.chatcontrol.clearchat.use");
    }

    public String getLockChatUsePermission() {
        return this.getChatControlDoubleNestedString("permissions", "lockchat", "use", "bmsproxycore.chatcontrol.lockchat.use");
    }

    public String getLockChatBypassPermission() {
        return this.getChatControlDoubleNestedString("permissions", "lockchat", "bypass", "bmsproxycore.chatcontrol.lockchat.bypass");
    }

    public String getChatFilterBypassPrivateMessagesPermission() {
        return this.getChatControlDoubleNestedString("permissions", "filter", "bypass-privatemessages", "bmsproxycore.chatcontrol.filter.bypass.privatemessages");
    }

    public List<String> getChatFilterRules() {
        Map<String, Object> filterSection = this.getChatControlSection("filter");
        Object rulesObj = filterSection.get("rules");
        if (rulesObj instanceof List) {
            return (List)rulesObj;
        }
        return new ArrayList<String>();
    }

    public String getChatFilterAction() {
        return this.getChatControlNestedString("filter", "action", "warn");
    }

    public String getChatFilterBlockedMessage() {
        return this.getChatControlNestedString("filter", "blocked-message", "&cYour message was blocked by the chat filter.");
    }

    public String getChatFilterReplacementText() {
        return this.getChatControlNestedString("filter", "replacement-text", "***");
    }

    public boolean isChatFilterLogEnabled() {
        return this.getChatControlNestedBoolean("filter", "log-filtered", true);
    }

    public String getChatFilterLogFormat() {
        return this.getChatControlNestedString("filter", "log-format", "[ChatFilter] {player} attempted to send: {message}");
    }

    public boolean isChatFilterCaseSensitive() {
        return this.getChatControlNestedBoolean("advanced", "case-sensitive", false);
    }

    public int getChatCooldownDuration() {
        return this.getChatControlNestedInt("cooldown", "duration", 3);
    }

    public String getChatCooldownMessage() {
        return this.getChatControlNestedString("cooldown", "cooldown-message", "&cYou must wait {time} seconds before sending another message.");
    }

    public boolean isChatCooldownPermissionBasedEnabled() {
        return this.getChatControlNestedBoolean("cooldown", "permission-based", "enabled", false);
    }

    public Map<String, Integer> getChatCooldownPermissionDurations() {
        if (!this.isChatControlEnabled()) {
            return new HashMap<String, Integer>();
        }
        Map<String, Object> cooldownSection = this.getChatControlSection("cooldown");
        Object permissionBasedObj = cooldownSection.get("permission-based");
        if (!(permissionBasedObj instanceof Map)) {
            return new HashMap<String, Integer>();
        }
        Map permissionBasedSection = (Map)permissionBasedObj;
        Object durationsObj = permissionBasedSection.get("durations");
        if (!(durationsObj instanceof Map)) {
            return new HashMap<String, Integer>();
        }
        Map durationsSection = (Map)durationsObj;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry entry : durationsSection.entrySet()) {
            if (!(entry.getValue() instanceof Integer)) continue;
            result.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return result;
    }

    public boolean isChatCooldownLogViolationsEnabled() {
        return this.getChatControlNestedBoolean("cooldown", "log-violations", false);
    }

    public String getChatCooldownViolationLogFormat() {
        return this.getChatControlNestedString("cooldown", "violation-log-format", "[ChatCooldown] {player} tried to send message too quickly");
    }

    public String getChatControlNoPermissionMessage() {
        return this.getChatControlNestedString("messages", "no-permission", "&cYou don't have permission to use this command.");
    }

    public String getChatControlModuleDisabledMessage() {
        return this.getChatControlNestedString("messages", "module-disabled", "&cThis feature is currently disabled.");
    }

    public String getChatControlReloadSuccessMessage() {
        return this.getChatControlNestedString("messages", "reload-success", "&aChat control configuration reloaded successfully.");
    }

    public String getChatControlReloadFailedMessage() {
        return this.getChatControlNestedString("messages", "reload-failed", "&cFailed to reload chat control configuration.");
    }

    public String getChatFilterRuleAddedMessage() {
        return this.getChatControlDoubleNestedString("messages", "filter", "rule-added", "&aFilter rule added: &7{rule}");
    }

    public String getChatFilterRuleRemovedMessage() {
        return this.getChatControlDoubleNestedString("messages", "filter", "rule-removed", "&aFilter rule removed: &7{rule}");
    }

    public String getChatFilterRuleNotFoundMessage() {
        return this.getChatControlDoubleNestedString("messages", "filter", "rule-not-found", "&cFilter rule not found: &7{rule}");
    }

    public String getChatFilterRuleAlreadyExistsMessage() {
        return this.getChatControlDoubleNestedString("messages", "filter", "rule-already-exists", "&cFilter rule already exists: &7{rule}");
    }

    public String getChatFilterInvalidRegexMessage() {
        return this.getChatControlDoubleNestedString("messages", "filter", "invalid-regex", "&cInvalid regex pattern: &7{rule}");
    }

    public String getChatFilterListHeaderMessage() {
        return this.getChatControlDoubleNestedString("messages", "filter", "list-header", "&6Active Filter Rules:");
    }

    public String getChatFilterListFormatMessage() {
        return this.getChatControlDoubleNestedString("messages", "filter", "list-format", "&7- {rule}");
    }

    public String getChatFilterListEmptyMessage() {
        return this.getChatControlDoubleNestedString("messages", "filter", "list-empty", "&7No filter rules are currently active.");
    }

    public String getChatCooldownDurationSetMessage() {
        return this.getChatControlDoubleNestedString("messages", "cooldown", "duration-set", "&aCooldown duration set to &7{duration} &aseconds.");
    }

    public String getChatCooldownDurationDisabledMessage() {
        return this.getChatControlDoubleNestedString("messages", "cooldown", "duration-disabled", "&aCooldown has been disabled.");
    }

    public String getChatCooldownInvalidDurationMessage() {
        return this.getChatControlDoubleNestedString("messages", "cooldown", "invalid-duration", "&cInvalid duration. Please enter a number.");
    }

    public String getChatCooldownStatusEnabledMessage() {
        return this.getChatControlDoubleNestedString("messages", "cooldown", "status-enabled", "&aCooldown is currently &aenabled &7({duration}s)");
    }

    public String getChatCooldownStatusDisabledMessage() {
        return this.getChatControlDoubleNestedString("messages", "cooldown", "status-disabled", "&aCooldown is currently &cdisabled");
    }

    public int getChatControlMaxFilterRules() {
        return this.getChatControlNestedInt("advanced", "max-filter-rules", 50);
    }

    public boolean isChatControlDebugEnabled() {
        return this.getChatControlNestedBoolean("advanced", "debug", false);
    }

    public String getChatControlDebugFormat() {
        return this.getChatControlNestedString("advanced", "debug-format", "[ChatControl-Debug] {component}: {message}");
    }

    public String getChatFilterMainCommand() {
        return this.getChatControlDoubleNestedString("commands", "filter", "main-command", "chatfilter");
    }

    public List<String> getChatFilterCommandAliases() {
        Map<String, Object> commandsSection = this.getChatControlSection("commands");
        Object filterObj = commandsSection.get("filter");
        if (!(filterObj instanceof Map)) {
            return Arrays.asList("cf", "filter");
        }
        Map filterSection = (Map)filterObj;
        Object aliasesObj = filterSection.get("aliases");
        if (aliasesObj instanceof List) {
            return (List)aliasesObj;
        }
        return Arrays.asList("cf", "filter");
    }

    public String getChatCooldownMainCommand() {
        return this.getChatControlDoubleNestedString("commands", "cooldown", "main-command", "chatcooldown");
    }

    public List<String> getChatCooldownCommandAliases() {
        Map<String, Object> commandsSection = this.getChatControlSection("commands");
        Object cooldownObj = commandsSection.get("cooldown");
        if (!(cooldownObj instanceof Map)) {
            return Arrays.asList("cc", "cooldown");
        }
        Map cooldownSection = (Map)cooldownObj;
        Object aliasesObj = cooldownSection.get("aliases");
        if (aliasesObj instanceof List) {
            return (List)aliasesObj;
        }
        return Arrays.asList("cc", "cooldown");
    }

    public boolean isClearChatEnabled() {
        return this.getChatControlNestedBoolean("commands", "clearchat", "enabled", true);
    }

    public String getClearChatMainCommand() {
        return this.getChatControlDoubleNestedString("commands", "clearchat", "main-command", "clearchat");
    }

    public List<String> getClearChatCommandAliases() {
        Map<String, Object> commandsSection = this.getChatControlSection("commands");
        Object clearchatObj = commandsSection.get("clearchat");
        if (!(clearchatObj instanceof Map)) {
            return Arrays.asList("cc", "chatclear");
        }
        Map clearchatSection = (Map)clearchatObj;
        Object aliasesObj = clearchatSection.get("aliases");
        if (aliasesObj instanceof List) {
            return (List)aliasesObj;
        }
        return Arrays.asList("cc", "chatclear");
    }

    public int getClearChatEmptyMessages() {
        return this.getChatControlDoubleNestedInt("commands", "clearchat", "empty-messages", 100);
    }

    public String getClearChatCompletionMessage() {
        return this.getChatControlDoubleNestedString("commands", "clearchat", "completion-message", "&aChat has been cleared by &7{player}&a.");
    }

    public boolean isLockChatEnabled() {
        return this.getChatControlNestedBoolean("commands", "lockchat", "enabled", true);
    }

    public String getLockChatMainCommand() {
        return this.getChatControlDoubleNestedString("commands", "lockchat", "main-command", "lockchat");
    }

    public List<String> getLockChatCommandAliases() {
        Map<String, Object> commandsSection = this.getChatControlSection("commands");
        Object lockchatObj = commandsSection.get("lockchat");
        if (!(lockchatObj instanceof Map)) {
            return Arrays.asList("lc", "chatlock");
        }
        Map lockchatSection = (Map)lockchatObj;
        Object aliasesObj = lockchatSection.get("aliases");
        if (aliasesObj instanceof List) {
            return (List)aliasesObj;
        }
        return Arrays.asList("lc", "chatlock");
    }

    public String getLockChatLockedMessage() {
        return this.getChatControlDoubleNestedString("commands", "lockchat", "locked-message", "&cChat is currently muted by staff.");
    }

    public String getLockChatUnlockedMessage() {
        return this.getChatControlDoubleNestedString("commands", "lockchat", "unlocked-message", "&aChat has been unlocked by &7{player}&a.");
    }

    public String getLockChatBlockedMessage() {
        return this.getChatControlDoubleNestedString("commands", "lockchat", "blocked-message", "&cYou cannot send messages while chat is locked.");
    }

    public boolean isPrivateMessageFilterEnabled() {
        return this.getChatControlNestedBoolean("privatemessages", "apply-filter", true);
    }

    public boolean isPrivateMessageChatLockRespected() {
        return this.getChatControlNestedBoolean("privatemessages", "respect-chatlock", true);
    }

    public String getPrivateMessageFilterBlockedMessage() {
        return this.getChatControlNestedString("privatemessages", "filter-blocked-message", "&cYour private message was blocked by the chat filter.");
    }

    public String getPrivateMessageChatLockBlockedMessage() {
        return this.getChatControlNestedString("privatemessages", "chatlock-blocked-message", "&cPrivate messages are disabled while chat is locked.");
    }

    private int getChatControlDoubleNestedInt(String section, String subsection, String path, int defaultValue) {
        if (!this.isChatControlEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getChatControlSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object subsectionObj = sectionMap.get(subsection);
        if (!(subsectionObj instanceof Map)) {
            return defaultValue;
        }
        Map subsectionMap = (Map)subsectionObj;
        Object value = subsectionMap.get(path);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public void addChatFilterRule(String rule) {
    }

    public void removeChatFilterRule(String rule) {
    }

    public void setChatCooldownDuration(int duration) {
    }

    private boolean getChatControlNestedBoolean(String section, String subsection, String path, boolean defaultValue) {
        if (!this.isChatControlEnabled()) {
            return defaultValue;
        }
        Map<String, Object> sectionMap = this.getChatControlSection(section);
        if (sectionMap == null) {
            return defaultValue;
        }
        Object subsectionObj = sectionMap.get(subsection);
        if (!(subsectionObj instanceof Map)) {
            return defaultValue;
        }
        Map subsectionMap = (Map)subsectionObj;
        Object value = subsectionMap.get(path);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }
}

