/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.redis;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisManager {
    private final BMSProxyCore plugin;
    private JedisPool jedisPool;
    private final AtomicBoolean isConnected = new AtomicBoolean(false);
    private final AtomicBoolean isShuttingDown = new AtomicBoolean(false);
    private ExecutorService pubSubExecutor;

    public RedisManager(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initialize() {
        if (this.isConnected.get()) {
            this.plugin.getLogger().warn("Redis manager is already initialized");
            return true;
        }
        try {
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(this.plugin.getConfigManager().getRedisPoolMaxTotal());
            poolConfig.setMaxIdle(this.plugin.getConfigManager().getRedisPoolMaxIdle());
            poolConfig.setMinIdle(this.plugin.getConfigManager().getRedisPoolMinIdle());
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            poolConfig.setTestWhileIdle(true);
            poolConfig.setBlockWhenExhausted(true);
            String host = this.plugin.getConfigManager().getRedisHost();
            int port = this.plugin.getConfigManager().getRedisPort();
            int timeout2 = this.plugin.getConfigManager().getRedisPoolTimeout();
            String password = this.plugin.getConfigManager().getRedisPassword();
            int database = this.plugin.getConfigManager().getRedisDatabase();
            this.jedisPool = password.isEmpty() ? new JedisPool((GenericObjectPoolConfig<Jedis>)poolConfig, host, port, timeout2, null, database) : new JedisPool((GenericObjectPoolConfig<Jedis>)poolConfig, host, port, timeout2, password, database);
            try (Jedis jedis = this.jedisPool.getResource();){
                String response = jedis.ping();
                if (!"PONG".equals(response)) {
                    this.plugin.getLogger().error("Redis ping test failed. Expected PONG, got: " + response);
                    boolean bl = false;
                    return bl;
                }
            }
            this.pubSubExecutor = Executors.newCachedThreadPool(r -> {
                Thread thread2 = new Thread(r, "BMSProxyCore-Redis-PubSub");
                thread2.setDaemon(true);
                return thread2;
            });
            this.isConnected.set(true);
            this.plugin.getLogger().info("Redis connection established successfully");
            this.plugin.getLogger().info("Connected to Redis " + this.getRedisVersion() + " at " + host + ":" + port);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to initialize Redis connection", e);
            this.cleanup();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRedisVersion() {
        try (Jedis jedis = this.jedisPool.getResource();){
            String info = jedis.info("server");
            String[] stringArray = info.split("\r\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith("redis_version:")) {
                    String string = line.substring("redis_version:".length());
                    return string;
                }
                ++n2;
            }
            return "unknown";
        }
        catch (Exception e) {
            this.plugin.getLogger().warn("Could not determine Redis version", e);
        }
        return "unknown";
    }

    public CompletableFuture<Boolean> publishMessage(String channel, String message) {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.isConnected.get() || this.isShuttingDown.get()) {
                return false;
            }
            Jedis jedis = this.jedisPool.getResource();
            try {
                jedis.publish(channel, message);
                Boolean bl = true;
                if (jedis != null) {
                    jedis.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JedisConnectionException e) {
                    this.plugin.getLogger().error("Failed to publish message to Redis channel: " + channel, e);
                    return false;
                }
            }
        });
    }

    public void subscribe(JedisPubSub listener, String ... channels) {
        if (!this.isConnected.get() || this.isShuttingDown.get()) {
            this.plugin.getLogger().warn("Cannot subscribe to Redis channels - not connected");
            return;
        }
        this.pubSubExecutor.submit(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                this.plugin.getLogger().info("Subscribing to Redis channels: " + String.join((CharSequence)", ", channels));
                jedis.subscribe(listener, channels);
            }
            catch (JedisConnectionException e) {
                if (!this.isShuttingDown.get()) {
                    this.plugin.getLogger().error("Redis subscription failed", e);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().error("Unexpected error in Redis subscription", e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeCommand(RedisCommand<T> command) {
        if (!this.isConnected.get()) return null;
        if (this.isShuttingDown.get()) {
            return null;
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            T t = command.execute(jedis);
            return t;
        }
        catch (JedisConnectionException e) {
            this.plugin.getLogger().error("Redis command execution failed", e);
            return null;
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Redis command execution failed with unexpected error", e);
            return null;
        }
    }

    public boolean isConnected() {
        return this.isConnected.get() && this.jedisPool != null && !this.jedisPool.isClosed();
    }

    public void shutdown() {
        this.isShuttingDown.set(true);
        this.plugin.getLogger().info("Shutting down Redis manager...");
        this.cleanup();
        this.plugin.getLogger().info("Redis manager shutdown complete");
    }

    private void cleanup() {
        this.isConnected.set(false);
        if (this.pubSubExecutor != null && !this.pubSubExecutor.isShutdown()) {
            this.pubSubExecutor.shutdown();
            this.pubSubExecutor = null;
        }
        if (this.jedisPool != null && !this.jedisPool.isClosed()) {
            this.jedisPool.close();
            this.jedisPool = null;
        }
    }

    @FunctionalInterface
    public static interface RedisCommand<T> {
        public T execute(Jedis var1) throws Exception;
    }
}

