/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.redis;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.redis.RedisManager;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.proxy.Player;
import net.kyori.adventure.text.Component;
import org.json.JSONObject;
import redis.clients.jedis.JedisPubSub;

public class CrossProxyStaffChatManager {
    private final BMSProxyCore plugin;
    private final RedisManager redisManager;
    private StaffChatPubSubListener pubSubListener;
    private static final String MESSAGE_TYPE_CHAT = "chat";
    private static final String MESSAGE_TYPE_ACTIVITY_CONNECT = "activity_connect";
    private static final String MESSAGE_TYPE_ACTIVITY_DISCONNECT = "activity_disconnect";
    private static final String MESSAGE_TYPE_ACTIVITY_SERVER_SWITCH = "activity_server_switch";

    public CrossProxyStaffChatManager(BMSProxyCore plugin, RedisManager redisManager) {
        this.plugin = plugin;
        this.redisManager = redisManager;
    }

    public void initialize() {
        if (!this.plugin.getConfigManager().isRedisEnabled()) {
            this.plugin.getLogger().info("Redis cross-proxy staff chat is disabled");
            return;
        }
        this.pubSubListener = new StaffChatPubSubListener();
        String chatChannel = this.plugin.getConfigManager().getRedisChatChannel();
        String activityChannel = this.plugin.getConfigManager().getRedisActivityChannel();
        this.redisManager.subscribe(this.pubSubListener, chatChannel, activityChannel);
        this.plugin.getLogger().info("Cross-proxy staff chat initialized");
        this.plugin.getLogger().info("Listening on channels: " + chatChannel + ", " + activityChannel);
    }

    public void broadcastStaffChatMessage(Player player, String message) {
        if (!this.redisManager.isConnected()) {
            return;
        }
        try {
            String serverName = player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("Unknown");
            JSONObject messageData = new JSONObject();
            messageData.put("type", MESSAGE_TYPE_CHAT);
            messageData.put("proxy_id", this.plugin.getConfigManager().getRedisProxyId());
            messageData.put("player_name", player.getUsername());
            messageData.put("player_uuid", player.getUniqueId().toString());
            messageData.put("server_name", serverName);
            messageData.put("message", message);
            messageData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getRedisChatChannel();
            this.redisManager.publishMessage(channel, messageData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to broadcast staff chat message", e);
        }
    }

    public void broadcastConsoleStaffChatMessage(String message) {
        if (!this.redisManager.isConnected()) {
            return;
        }
        try {
            JSONObject messageData = new JSONObject();
            messageData.put("type", MESSAGE_TYPE_CHAT);
            messageData.put("proxy_id", this.plugin.getConfigManager().getRedisProxyId());
            messageData.put("player_name", "Console");
            messageData.put("player_uuid", "00000000-0000-0000-0000-000000000000");
            messageData.put("server_name", "Console");
            messageData.put("message", message);
            messageData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getRedisChatChannel();
            this.redisManager.publishMessage(channel, messageData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to broadcast console staff chat message", e);
        }
    }

    public void broadcastPlayerConnect(Player player) {
        if (!this.redisManager.isConnected()) {
            return;
        }
        try {
            JSONObject messageData = new JSONObject();
            messageData.put("type", MESSAGE_TYPE_ACTIVITY_CONNECT);
            messageData.put("proxy_id", this.plugin.getConfigManager().getRedisProxyId());
            messageData.put("player_name", player.getUsername());
            messageData.put("player_uuid", player.getUniqueId().toString());
            messageData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getRedisActivityChannel();
            this.redisManager.publishMessage(channel, messageData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to broadcast player connect activity", e);
        }
    }

    public void broadcastPlayerDisconnect(Player player) {
        if (!this.redisManager.isConnected()) {
            return;
        }
        try {
            JSONObject messageData = new JSONObject();
            messageData.put("type", MESSAGE_TYPE_ACTIVITY_DISCONNECT);
            messageData.put("proxy_id", this.plugin.getConfigManager().getRedisProxyId());
            messageData.put("player_name", player.getUsername());
            messageData.put("player_uuid", player.getUniqueId().toString());
            messageData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getRedisActivityChannel();
            this.redisManager.publishMessage(channel, messageData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to broadcast player disconnect activity", e);
        }
    }

    public void broadcastPlayerServerSwitch(Player player, String fromServer, String toServer) {
        if (!this.redisManager.isConnected()) {
            return;
        }
        try {
            JSONObject messageData = new JSONObject();
            messageData.put("type", MESSAGE_TYPE_ACTIVITY_SERVER_SWITCH);
            messageData.put("proxy_id", this.plugin.getConfigManager().getRedisProxyId());
            messageData.put("player_name", player.getUsername());
            messageData.put("player_uuid", player.getUniqueId().toString());
            messageData.put("from_server", fromServer);
            messageData.put("to_server", toServer);
            messageData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getRedisActivityChannel();
            this.redisManager.publishMessage(channel, messageData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to broadcast player server switch activity", e);
        }
    }

    public void shutdown() {
        if (this.pubSubListener != null && this.pubSubListener.isSubscribed()) {
            this.pubSubListener.unsubscribe();
        }
        this.plugin.getLogger().info("Cross-proxy staff chat manager shutdown");
    }

    private void handleCrossProxyChatMessage(JSONObject messageData) {
        try {
            String playerName = messageData.getString("player_name");
            String serverName = messageData.getString("server_name");
            String messageText = messageData.getString("message");
            String sourceProxyId = messageData.getString("proxy_id");
            Component formattedMessage = "Console".equals(playerName) ? MessageUtils.formatMessage(this.plugin.getConfigManager().getCrossProxyMessageFormat().replace("{prefix}", this.plugin.getConfigManager().getStaffChatPrefix()).replace("{proxy}", sourceProxyId).replace("{server}", serverName).replace("{player}", playerName).replace("{message}", messageText)) : MessageUtils.formatMessage(this.plugin.getConfigManager().getCrossProxyMessageFormat().replace("{prefix}", this.plugin.getConfigManager().getStaffChatPrefix()).replace("{proxy}", sourceProxyId).replace("{server}", serverName).replace("{player}", playerName).replace("{message}", messageText));
            String usePermission = this.plugin.getConfigManager().getStaffChatUsePermission();
            MessageUtils.broadcastToPermission(this.plugin.getServer(), formattedMessage, usePermission);
            this.plugin.getLogger().info(MessageUtils.componentToPlainText(formattedMessage));
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle cross-proxy chat message", e);
        }
    }

    private void handleCrossProxyConnectActivity(JSONObject messageData) {
        try {
            String playerName = messageData.getString("player_name");
            String sourceProxyId = messageData.getString("proxy_id");
            Component formattedMessage = MessageUtils.formatMessage(this.plugin.getConfigManager().getCrossProxyConnectFormat().replace("{prefix}", this.plugin.getConfigManager().getStaffChatPrefix()).replace("{player}", playerName).replace("{proxy}", sourceProxyId));
            String activityPermission = this.plugin.getConfigManager().getStaffChatActivityPermission();
            MessageUtils.broadcastToPermission(this.plugin.getServer(), formattedMessage, activityPermission);
            this.plugin.getLogger().info(MessageUtils.componentToPlainText(formattedMessage));
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle cross-proxy connect activity", e);
        }
    }

    private void handleCrossProxyDisconnectActivity(JSONObject messageData) {
        try {
            String playerName = messageData.getString("player_name");
            String sourceProxyId = messageData.getString("proxy_id");
            Component formattedMessage = MessageUtils.formatMessage(this.plugin.getConfigManager().getCrossProxyDisconnectFormat().replace("{prefix}", this.plugin.getConfigManager().getStaffChatPrefix()).replace("{player}", playerName).replace("{proxy}", sourceProxyId));
            String activityPermission = this.plugin.getConfigManager().getStaffChatActivityPermission();
            MessageUtils.broadcastToPermission(this.plugin.getServer(), formattedMessage, activityPermission);
            this.plugin.getLogger().info(MessageUtils.componentToPlainText(formattedMessage));
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle cross-proxy disconnect activity", e);
        }
    }

    private void handleCrossProxyServerSwitchActivity(JSONObject messageData) {
        try {
            String playerName = messageData.getString("player_name");
            String fromServer = messageData.getString("from_server");
            String toServer = messageData.getString("to_server");
            String sourceProxyId = messageData.getString("proxy_id");
            Component formattedMessage = MessageUtils.formatMessage(this.plugin.getConfigManager().getCrossProxyServerSwitchFormat().replace("{prefix}", this.plugin.getConfigManager().getStaffChatPrefix()).replace("{player}", playerName).replace("{from_server}", fromServer).replace("{to_server}", toServer).replace("{proxy}", sourceProxyId));
            String activityPermission = this.plugin.getConfigManager().getStaffChatActivityPermission();
            MessageUtils.broadcastToPermission(this.plugin.getServer(), formattedMessage, activityPermission);
            this.plugin.getLogger().info(MessageUtils.componentToPlainText(formattedMessage));
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle cross-proxy server switch activity", e);
        }
    }

    private class StaffChatPubSubListener
    extends JedisPubSub {
        private StaffChatPubSubListener() {
        }

        @Override
        public void onMessage(String channel, String message) {
            try {
                String messageType;
                JSONObject messageData = new JSONObject(message);
                String sourceProxyId = messageData.getString("proxy_id");
                String currentProxyId = CrossProxyStaffChatManager.this.plugin.getConfigManager().getRedisProxyId();
                if (sourceProxyId.equals(currentProxyId)) {
                    return;
                }
                switch (messageType = messageData.getString("type")) {
                    case "chat": {
                        CrossProxyStaffChatManager.this.handleCrossProxyChatMessage(messageData);
                        break;
                    }
                    case "activity_connect": {
                        CrossProxyStaffChatManager.this.handleCrossProxyConnectActivity(messageData);
                        break;
                    }
                    case "activity_disconnect": {
                        CrossProxyStaffChatManager.this.handleCrossProxyDisconnectActivity(messageData);
                        break;
                    }
                    case "activity_server_switch": {
                        CrossProxyStaffChatManager.this.handleCrossProxyServerSwitchActivity(messageData);
                        break;
                    }
                    default: {
                        CrossProxyStaffChatManager.this.plugin.getLogger().warn("Unknown cross-proxy message type: " + messageType);
                        break;
                    }
                }
            }
            catch (Exception e) {
                CrossProxyStaffChatManager.this.plugin.getLogger().error("Failed to process cross-proxy message", e);
            }
        }

        @Override
        public void onSubscribe(String channel, int subscribedChannels) {
            CrossProxyStaffChatManager.this.plugin.getLogger().info("Subscribed to Redis channel: " + channel);
        }

        @Override
        public void onUnsubscribe(String channel, int subscribedChannels) {
            CrossProxyStaffChatManager.this.plugin.getLogger().info("Unsubscribed from Redis channel: " + channel);
        }
    }
}

