/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.redis;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.redis.RedisManager;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.json.JSONObject;
import redis.clients.jedis.JedisPubSub;

public class CrossProxyMessagingManager {
    private final BMSProxyCore plugin;
    private final RedisManager redisManager;
    private PrivateMessagePubSubListener pubSubListener;
    private final Map<String, CompletableFuture<PlayerLookupResult>> pendingLookups = new ConcurrentHashMap<String, CompletableFuture<PlayerLookupResult>>();
    private final Map<String, CrossProxyPlayer> crossProxyPlayers = new ConcurrentHashMap<String, CrossProxyPlayer>();
    private static final String MESSAGE_TYPE_PRIVATE_MESSAGE = "private_message";
    private static final String MESSAGE_TYPE_PLAYER_LOOKUP_REQUEST = "player_lookup_request";
    private static final String MESSAGE_TYPE_PLAYER_LOOKUP_RESPONSE = "player_lookup_response";
    private static final String MESSAGE_TYPE_SOCIAL_SPY = "social_spy";
    private static final String MESSAGE_TYPE_REPLY_TARGET_UPDATE = "reply_target_update";
    private static final String MESSAGE_TYPE_PLAYER_JOIN = "player_join";
    private static final String MESSAGE_TYPE_PLAYER_LEAVE = "player_leave";
    private static final String MESSAGE_TYPE_PLAYER_LIST_REQUEST = "player_list_request";
    private static final String MESSAGE_TYPE_PLAYER_LIST_RESPONSE = "player_list_response";
    private static final int LOOKUP_TIMEOUT_SECONDS = 5;

    public CrossProxyMessagingManager(BMSProxyCore plugin, RedisManager redisManager) {
        this.plugin = plugin;
        this.redisManager = redisManager;
    }

    public void initialize() {
        if (!this.plugin.getConfigManager().isPrivateMessagesRedisEnabled()) {
            this.plugin.getLogger().info("Redis cross-proxy private messaging is disabled");
            return;
        }
        this.pubSubListener = new PrivateMessagePubSubListener();
        String messageChannel = this.plugin.getConfigManager().getPrivateMessagesMessageChannel();
        String lookupChannel = this.plugin.getConfigManager().getPrivateMessagesLookupChannel();
        String lookupResponseChannel = this.plugin.getConfigManager().getPrivateMessagesLookupResponseChannel();
        String socialSpyChannel = this.plugin.getConfigManager().getPrivateMessagesSocialSpyChannel();
        String replyChannel = this.plugin.getConfigManager().getPrivateMessagesReplyChannel();
        this.redisManager.subscribe(this.pubSubListener, messageChannel, lookupChannel, lookupResponseChannel, socialSpyChannel, replyChannel);
        this.plugin.getLogger().info("Cross-proxy private messaging initialized");
        this.plugin.getLogger().info("Listening on channels: " + messageChannel + ", " + lookupChannel + ", " + lookupResponseChannel + ", " + socialSpyChannel + ", " + replyChannel);
        this.requestPlayerListFromAllProxies();
    }

    public CompletableFuture<Boolean> sendCrossProxyMessage(String senderName, UUID senderUUID, String targetName, String message) {
        if (!this.redisManager.isConnected()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.lookupPlayer(targetName).thenCompose(lookupResult -> {
            if (lookupResult == null || !lookupResult.found) {
                return CompletableFuture.completedFuture(false);
            }
            try {
                JSONObject messageData = new JSONObject();
                messageData.put("type", MESSAGE_TYPE_PRIVATE_MESSAGE);
                messageData.put("sender_proxy", this.plugin.getConfigManager().getPrivateMessagesRedisProxyId());
                messageData.put("target_proxy", lookupResult.proxyId);
                messageData.put("sender_name", senderName);
                messageData.put("sender_uuid", senderUUID.toString());
                messageData.put("target_name", targetName);
                messageData.put("target_uuid", lookupResult.playerUUID.toString());
                messageData.put("message", message);
                messageData.put("timestamp", System.currentTimeMillis());
                String channel = this.plugin.getConfigManager().getPrivateMessagesMessageChannel();
                return this.redisManager.publishMessage(channel, messageData.toString());
            }
            catch (Exception e) {
                this.plugin.getLogger().error("Failed to send cross-proxy private message", e);
                return CompletableFuture.completedFuture(false);
            }
        });
    }

    public CompletableFuture<PlayerLookupResult> lookupPlayer(String playerName) {
        if (!this.redisManager.isConnected()) {
            return CompletableFuture.completedFuture(new PlayerLookupResult(false, null, null));
        }
        String lookupId = UUID.randomUUID().toString();
        CompletableFuture<PlayerLookupResult> future = new CompletableFuture<PlayerLookupResult>();
        this.pendingLookups.put(lookupId, future);
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            CompletableFuture<PlayerLookupResult> pendingFuture = this.pendingLookups.remove(lookupId);
            if (pendingFuture != null && !pendingFuture.isDone()) {
                pendingFuture.complete(new PlayerLookupResult(false, null, null));
            }
        }).delay(5L, TimeUnit.SECONDS).schedule();
        try {
            JSONObject lookupData = new JSONObject();
            lookupData.put("type", MESSAGE_TYPE_PLAYER_LOOKUP_REQUEST);
            lookupData.put("lookup_id", lookupId);
            lookupData.put("requesting_proxy", this.plugin.getConfigManager().getPrivateMessagesRedisProxyId());
            lookupData.put("player_name", playerName);
            lookupData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getPrivateMessagesLookupChannel();
            this.redisManager.publishMessage(channel, lookupData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to send player lookup request", e);
            this.pendingLookups.remove(lookupId);
            future.complete(new PlayerLookupResult(false, null, null));
        }
        return future;
    }

    public void broadcastSocialSpyMessage(String senderName, UUID senderUUID, String receiverName, UUID receiverUUID, String message, String receiverProxy) {
        if (!this.redisManager.isConnected()) {
            return;
        }
        try {
            JSONObject spyData = new JSONObject();
            spyData.put("type", MESSAGE_TYPE_SOCIAL_SPY);
            spyData.put("sender_proxy", this.plugin.getConfigManager().getPrivateMessagesRedisProxyId());
            spyData.put("receiver_proxy", receiverProxy);
            spyData.put("sender_name", senderName);
            spyData.put("sender_uuid", senderUUID.toString());
            spyData.put("receiver_name", receiverName);
            spyData.put("receiver_uuid", receiverUUID.toString());
            spyData.put("message", message);
            spyData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getPrivateMessagesSocialSpyChannel();
            this.redisManager.publishMessage(channel, spyData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to broadcast social spy message", e);
        }
    }

    public void updateCrossProxyReplyTarget(UUID playerUUID, String playerName, UUID targetUUID, String targetName, String targetProxy) {
        if (!this.redisManager.isConnected()) {
            return;
        }
        try {
            JSONObject replyData = new JSONObject();
            replyData.put("type", MESSAGE_TYPE_REPLY_TARGET_UPDATE);
            replyData.put("source_proxy", this.plugin.getConfigManager().getPrivateMessagesRedisProxyId());
            replyData.put("target_proxy", targetProxy);
            replyData.put("player_uuid", playerUUID.toString());
            replyData.put("player_name", playerName);
            replyData.put("target_uuid", targetUUID.toString());
            replyData.put("target_name", targetName);
            replyData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getPrivateMessagesReplyChannel();
            this.redisManager.publishMessage(channel, replyData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to update cross-proxy reply target", e);
        }
    }

    public void broadcastPlayerJoin(Player player) {
        if (!this.redisManager.isConnected()) {
            return;
        }
        try {
            JSONObject joinData = new JSONObject();
            joinData.put("type", MESSAGE_TYPE_PLAYER_JOIN);
            joinData.put("proxy_id", this.plugin.getConfigManager().getPrivateMessagesRedisProxyId());
            joinData.put("player_name", player.getUsername());
            joinData.put("player_uuid", player.getUniqueId().toString());
            joinData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getPrivateMessagesMessageChannel();
            this.redisManager.publishMessage(channel, joinData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to broadcast player join", e);
        }
    }

    public void broadcastPlayerLeave(Player player) {
        if (!this.redisManager.isConnected()) {
            return;
        }
        try {
            JSONObject leaveData = new JSONObject();
            leaveData.put("type", MESSAGE_TYPE_PLAYER_LEAVE);
            leaveData.put("proxy_id", this.plugin.getConfigManager().getPrivateMessagesRedisProxyId());
            leaveData.put("player_name", player.getUsername());
            leaveData.put("player_uuid", player.getUniqueId().toString());
            leaveData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getPrivateMessagesMessageChannel();
            this.redisManager.publishMessage(channel, leaveData.toString());
            this.crossProxyPlayers.remove(player.getUsername().toLowerCase());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to broadcast player leave", e);
        }
    }

    public void requestPlayerListFromAllProxies() {
        if (!this.redisManager.isConnected()) {
            return;
        }
        try {
            JSONObject requestData = new JSONObject();
            requestData.put("type", MESSAGE_TYPE_PLAYER_LIST_REQUEST);
            requestData.put("requesting_proxy", this.plugin.getConfigManager().getPrivateMessagesRedisProxyId());
            requestData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getPrivateMessagesLookupChannel();
            this.redisManager.publishMessage(channel, requestData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to request player list", e);
        }
    }

    public List<String> getAllKnownPlayerNames() {
        ArrayList<String> allPlayers = new ArrayList<String>();
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            allPlayers.add(player.getUsername());
        }
        long maxAge = 300000L;
        this.crossProxyPlayers.entrySet().removeIf(entry -> ((CrossProxyPlayer)entry.getValue()).isExpired(maxAge));
        for (CrossProxyPlayer crossProxyPlayer : this.crossProxyPlayers.values()) {
            if (allPlayers.contains(crossProxyPlayer.name)) continue;
            allPlayers.add(crossProxyPlayer.name);
        }
        return allPlayers;
    }

    public List<String> getFilteredPlayerNames(String partialName) {
        String lowerPartial = partialName.toLowerCase();
        return this.getAllKnownPlayerNames().stream().filter(name -> name.toLowerCase().startsWith(lowerPartial)).sorted().collect(Collectors.toList());
    }

    public void shutdown() {
        if (this.pubSubListener != null && this.pubSubListener.isSubscribed()) {
            this.pubSubListener.unsubscribe();
        }
        for (CompletableFuture<PlayerLookupResult> future : this.pendingLookups.values()) {
            if (future.isDone()) continue;
            future.complete(new PlayerLookupResult(false, null, null));
        }
        this.pendingLookups.clear();
        this.plugin.getLogger().info("Cross-proxy messaging manager shutdown");
    }

    private void handleCrossProxyPrivateMessage(JSONObject messageData) {
        try {
            String targetProxy = messageData.getString("target_proxy");
            String currentProxy = this.plugin.getConfigManager().getPrivateMessagesRedisProxyId();
            if (!targetProxy.equals(currentProxy)) {
                return;
            }
            String senderName = messageData.getString("sender_name");
            UUID senderUUID = UUID.fromString(messageData.getString("sender_uuid"));
            String targetName = messageData.getString("target_name");
            UUID targetUUID = UUID.fromString(messageData.getString("target_uuid"));
            String message = messageData.getString("message");
            String senderProxy = messageData.getString("sender_proxy");
            Player targetPlayer = this.plugin.getServer().getPlayer(targetUUID).orElse(null);
            if (targetPlayer == null) {
                this.sendDeliveryFailureNotification(senderProxy, senderName, targetName);
                return;
            }
            if (this.plugin.getMessagingManager().isMessageToggleDisabled(targetUUID)) {
                // empty if block
            }
            if (this.plugin.getMessagingManager().isPlayerIgnoring(targetUUID, senderUUID)) {
                return;
            }
            this.plugin.getMessagingManager().setReplyTarget(targetUUID, senderUUID);
            String receiverFormat = this.plugin.getConfigManager().getCrossProxyPrivateMessageReceiverFormat().replace("{sender}", senderName).replace("{proxy}", senderProxy).replace("{message}", message);
            targetPlayer.sendMessage(MessageUtils.formatMessage(receiverFormat));
            this.broadcastLocalSocialSpy(senderName, senderUUID, targetName, targetUUID, message, senderProxy);
            this.sendDeliveryConfirmation(senderProxy, senderName, targetName);
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle cross-proxy private message", e);
        }
    }

    private void handlePlayerLookupRequest(JSONObject messageData) {
        try {
            String lookupId = messageData.getString("lookup_id");
            String requestingProxy = messageData.getString("requesting_proxy");
            String playerName = messageData.getString("player_name");
            String currentProxy = this.plugin.getConfigManager().getPrivateMessagesRedisProxyId();
            if (requestingProxy.equals(currentProxy)) {
                return;
            }
            Player player = this.plugin.getServer().getPlayer(playerName).orElse(null);
            JSONObject responseData = new JSONObject();
            responseData.put("type", MESSAGE_TYPE_PLAYER_LOOKUP_RESPONSE);
            responseData.put("lookup_id", lookupId);
            responseData.put("requesting_proxy", requestingProxy);
            responseData.put("responding_proxy", currentProxy);
            responseData.put("player_name", playerName);
            responseData.put("found", player != null);
            if (player != null) {
                responseData.put("player_uuid", player.getUniqueId().toString());
            }
            responseData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getPrivateMessagesLookupResponseChannel();
            this.redisManager.publishMessage(channel, responseData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle player lookup request", e);
        }
    }

    private void handlePlayerLookupResponse(JSONObject messageData) {
        try {
            boolean found;
            String lookupId = messageData.getString("lookup_id");
            String requestingProxy = messageData.getString("requesting_proxy");
            String currentProxy = this.plugin.getConfigManager().getPrivateMessagesRedisProxyId();
            if (!requestingProxy.equals(currentProxy)) {
                return;
            }
            CompletableFuture<PlayerLookupResult> future = this.pendingLookups.remove(lookupId);
            if (future != null && !future.isDone() && (found = messageData.getBoolean("found"))) {
                String respondingProxy = messageData.getString("responding_proxy");
                UUID playerUUID = UUID.fromString(messageData.getString("player_uuid"));
                future.complete(new PlayerLookupResult(true, playerUUID, respondingProxy));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle player lookup response", e);
        }
    }

    private void handleCrossProxySocialSpy(JSONObject messageData) {
        try {
            String senderName = messageData.getString("sender_name");
            String receiverName = messageData.getString("receiver_name");
            String message = messageData.getString("message");
            String senderProxy = messageData.getString("sender_proxy");
            String receiverProxy = messageData.getString("receiver_proxy");
            String socialSpyFormat = this.plugin.getConfigManager().getCrossProxyPrivateMessageSocialSpyFormat().replace("{sender}", senderName).replace("{sender_proxy}", senderProxy).replace("{receiver}", receiverName).replace("{receiver_proxy}", receiverProxy).replace("{message}", message);
            Component formattedMessage = MessageUtils.formatMessage(socialSpyFormat);
            for (Player player : this.plugin.getServer().getAllPlayers()) {
                if (!this.plugin.getMessagingManager().isSocialSpyEnabled(player.getUniqueId())) continue;
                player.sendMessage(formattedMessage);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle cross-proxy social spy message", e);
        }
    }

    private void handleReplyTargetUpdate(JSONObject messageData) {
        try {
            String targetProxy = messageData.getString("target_proxy");
            String currentProxy = this.plugin.getConfigManager().getPrivateMessagesRedisProxyId();
            if (!targetProxy.equals(currentProxy)) {
                return;
            }
            UUID playerUUID = UUID.fromString(messageData.getString("player_uuid"));
            UUID targetUUID = UUID.fromString(messageData.getString("target_uuid"));
            this.plugin.getMessagingManager().setReplyTarget(playerUUID, targetUUID);
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle reply target update", e);
        }
    }

    private void broadcastLocalSocialSpy(String senderName, UUID senderUUID, String receiverName, UUID receiverUUID, String message, String senderProxy) {
        String socialSpyFormat = this.plugin.getConfigManager().getCrossProxyPrivateMessageSocialSpyFormat().replace("{sender}", senderName).replace("{sender_proxy}", senderProxy).replace("{receiver}", receiverName).replace("{receiver_proxy}", this.plugin.getConfigManager().getPrivateMessagesRedisProxyId()).replace("{message}", message);
        Component formattedMessage = MessageUtils.formatMessage(socialSpyFormat);
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            if (!this.plugin.getMessagingManager().isSocialSpyEnabled(player.getUniqueId()) || player.getUniqueId().equals(senderUUID) || player.getUniqueId().equals(receiverUUID)) continue;
            player.sendMessage(formattedMessage);
        }
    }

    private void sendDeliveryConfirmation(String senderProxy, String senderName, String targetName) {
        this.plugin.getLogger().debug("Message delivered from " + senderName + " to " + targetName + " via proxy " + senderProxy);
    }

    private void sendDeliveryFailureNotification(String senderProxy, String senderName, String targetName) {
        this.plugin.getLogger().warn("Failed to deliver message from " + senderName + " to " + targetName + " - player not found on proxy " + senderProxy);
    }

    private void handlePlayerJoin(JSONObject messageData) {
        try {
            String proxyId = messageData.getString("proxy_id");
            String currentProxy = this.plugin.getConfigManager().getPrivateMessagesRedisProxyId();
            if (proxyId.equals(currentProxy)) {
                return;
            }
            String playerName = messageData.getString("player_name");
            UUID playerUUID = UUID.fromString(messageData.getString("player_uuid"));
            this.crossProxyPlayers.put(playerName.toLowerCase(), new CrossProxyPlayer(playerName, playerUUID, proxyId));
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle player join notification", e);
        }
    }

    private void handlePlayerLeave(JSONObject messageData) {
        try {
            String proxyId = messageData.getString("proxy_id");
            String currentProxy = this.plugin.getConfigManager().getPrivateMessagesRedisProxyId();
            if (proxyId.equals(currentProxy)) {
                return;
            }
            String playerName = messageData.getString("player_name");
            this.crossProxyPlayers.remove(playerName.toLowerCase());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle player leave notification", e);
        }
    }

    private void handlePlayerListRequest(JSONObject messageData) {
        try {
            String requestingProxy = messageData.getString("requesting_proxy");
            String currentProxy = this.plugin.getConfigManager().getPrivateMessagesRedisProxyId();
            if (requestingProxy.equals(currentProxy)) {
                return;
            }
            JSONObject responseData = new JSONObject();
            responseData.put("type", MESSAGE_TYPE_PLAYER_LIST_RESPONSE);
            responseData.put("requesting_proxy", requestingProxy);
            responseData.put("responding_proxy", currentProxy);
            ArrayList<String> playerNames = new ArrayList<String>();
            ArrayList<String> playerUUIDs = new ArrayList<String>();
            for (Player player : this.plugin.getServer().getAllPlayers()) {
                playerNames.add(player.getUsername());
                playerUUIDs.add(player.getUniqueId().toString());
            }
            responseData.put("player_names", playerNames);
            responseData.put("player_uuids", playerUUIDs);
            responseData.put("timestamp", System.currentTimeMillis());
            String channel = this.plugin.getConfigManager().getPrivateMessagesLookupResponseChannel();
            this.redisManager.publishMessage(channel, responseData.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle player list request", e);
        }
    }

    private void handlePlayerListResponse(JSONObject messageData) {
        try {
            String requestingProxy = messageData.getString("requesting_proxy");
            String currentProxy = this.plugin.getConfigManager().getPrivateMessagesRedisProxyId();
            if (!requestingProxy.equals(currentProxy)) {
                return;
            }
            String respondingProxy = messageData.getString("responding_proxy");
            List playerNames = (List)messageData.get("player_names");
            List playerUUIDs = (List)messageData.get("player_uuids");
            for (int i = 0; i < playerNames.size() && i < playerUUIDs.size(); ++i) {
                String playerName = (String)playerNames.get(i);
                UUID playerUUID = UUID.fromString((String)playerUUIDs.get(i));
                this.crossProxyPlayers.put(playerName.toLowerCase(), new CrossProxyPlayer(playerName, playerUUID, respondingProxy));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to handle player list response", e);
        }
    }

    private class PrivateMessagePubSubListener
    extends JedisPubSub {
        private PrivateMessagePubSubListener() {
        }

        @Override
        public void onMessage(String channel, String message) {
            try {
                String messageType;
                JSONObject messageData = new JSONObject(message);
                switch (messageType = messageData.getString("type")) {
                    case "private_message": {
                        CrossProxyMessagingManager.this.handleCrossProxyPrivateMessage(messageData);
                        break;
                    }
                    case "player_lookup_request": {
                        CrossProxyMessagingManager.this.handlePlayerLookupRequest(messageData);
                        break;
                    }
                    case "player_lookup_response": {
                        CrossProxyMessagingManager.this.handlePlayerLookupResponse(messageData);
                        break;
                    }
                    case "social_spy": {
                        CrossProxyMessagingManager.this.handleCrossProxySocialSpy(messageData);
                        break;
                    }
                    case "reply_target_update": {
                        CrossProxyMessagingManager.this.handleReplyTargetUpdate(messageData);
                        break;
                    }
                    case "player_join": {
                        CrossProxyMessagingManager.this.handlePlayerJoin(messageData);
                        break;
                    }
                    case "player_leave": {
                        CrossProxyMessagingManager.this.handlePlayerLeave(messageData);
                        break;
                    }
                    case "player_list_request": {
                        CrossProxyMessagingManager.this.handlePlayerListRequest(messageData);
                        break;
                    }
                    case "player_list_response": {
                        CrossProxyMessagingManager.this.handlePlayerListResponse(messageData);
                        break;
                    }
                    default: {
                        CrossProxyMessagingManager.this.plugin.getLogger().warn("Unknown cross-proxy message type: " + messageType);
                        break;
                    }
                }
            }
            catch (Exception e) {
                CrossProxyMessagingManager.this.plugin.getLogger().error("Failed to process cross-proxy message", e);
            }
        }

        @Override
        public void onSubscribe(String channel, int subscribedChannels) {
            CrossProxyMessagingManager.this.plugin.getLogger().info("Subscribed to Redis channel: " + channel);
        }

        @Override
        public void onUnsubscribe(String channel, int subscribedChannels) {
            CrossProxyMessagingManager.this.plugin.getLogger().info("Unsubscribed from Redis channel: " + channel);
        }
    }

    public static class PlayerLookupResult {
        public final boolean found;
        public final UUID playerUUID;
        public final String proxyId;

        public PlayerLookupResult(boolean found, UUID playerUUID, String proxyId) {
            this.found = found;
            this.playerUUID = playerUUID;
            this.proxyId = proxyId;
        }
    }

    public static class CrossProxyPlayer {
        public final String name;
        public final UUID uuid;
        public final String proxyId;
        public final long lastSeen;

        public CrossProxyPlayer(String name, UUID uuid, String proxyId) {
            this.name = name;
            this.uuid = uuid;
            this.proxyId = proxyId;
            this.lastSeen = System.currentTimeMillis();
        }

        public boolean isExpired(long maxAgeMs) {
            return System.currentTimeMillis() - this.lastSeen > maxAgeMs;
        }
    }
}

