/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.messaging;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.proxy.Player;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;

public class MessagingManager {
    private final BMSProxyCore plugin;
    private final Map<UUID, UUID> replyTargets = new ConcurrentHashMap<UUID, UUID>();
    private final Set<UUID> socialSpyEnabled = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<UUID> messageToggleDisabled = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<UUID, Set<UUID>> ignoredPlayers = new ConcurrentHashMap<UUID, Set<UUID>>();

    public MessagingManager(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public boolean sendMessage(Player sender, Player receiver, String message) {
        String bypassPermission;
        UUID receiverUUID;
        UUID senderUUID = sender.getUniqueId();
        if (senderUUID.equals(receiverUUID = receiver.getUniqueId())) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorMessageSelf()));
            return false;
        }
        if (this.isMessageToggleDisabled(receiverUUID)) {
            String errorMessage = this.plugin.getConfigManager().getMessagingErrorPlayerToggled().replace("{player}", receiver.getUsername());
            sender.sendMessage(MessageUtils.formatMessage(errorMessage));
            return false;
        }
        if (this.isPlayerIgnoring(receiverUUID, senderUUID)) {
            String errorMessage = this.plugin.getConfigManager().getMessagingErrorPlayerIgnored().replace("{player}", receiver.getUsername());
            sender.sendMessage(MessageUtils.formatMessage(errorMessage));
            return false;
        }
        if (this.plugin.getConfigManager().isPrivateMessageChatLockRespected() && this.plugin.getChatControlManager().isChatLocked() && ((bypassPermission = this.plugin.getConfigManager().getLockChatBypassPermission()).isEmpty() || !sender.hasPermission(bypassPermission))) {
            String errorMessage = this.plugin.getConfigManager().getPrivateMessageChatLockBlockedMessage();
            sender.sendMessage(MessageUtils.formatMessage(errorMessage));
            return false;
        }
        if (this.plugin.getConfigManager().isPrivateMessageFilterEnabled()) {
            String filteredMessage = this.plugin.getChatControlManager().applyMessageFilter(message, sender);
            if (filteredMessage == null) {
                String errorMessage = this.plugin.getConfigManager().getPrivateMessageFilterBlockedMessage();
                sender.sendMessage(MessageUtils.formatMessage(errorMessage));
                return false;
            }
            message = filteredMessage;
        }
        this.setReplyTarget(senderUUID, receiverUUID);
        this.setReplyTarget(receiverUUID, senderUUID);
        String senderFormat = this.plugin.getConfigManager().getMessagingSenderFormat().replace("{receiver}", receiver.getUsername()).replace("{message}", message);
        sender.sendMessage(MessageUtils.formatMessage(senderFormat));
        String receiverFormat = this.plugin.getConfigManager().getMessagingReceiverFormat().replace("{sender}", sender.getUsername()).replace("{message}", message);
        receiver.sendMessage(MessageUtils.formatMessage(receiverFormat));
        this.broadcastToSocialSpies(sender, receiver, message);
        return true;
    }

    public boolean sendCrossProxyMessage(Player sender, String targetName, String message) {
        if (this.plugin.getCrossProxyMessagingManager() == null || !this.plugin.getConfigManager().isPrivateMessagesRedisEnabled()) {
            return false;
        }
        UUID senderUUID = sender.getUniqueId();
        String senderName = sender.getUsername();
        if (senderName.equalsIgnoreCase(targetName)) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorMessageSelf()));
            return false;
        }
        ((CompletableFuture)this.plugin.getCrossProxyMessagingManager().sendCrossProxyMessage(senderName, senderUUID, targetName, message).thenAccept(success -> {
            if (success.booleanValue()) {
                String senderFormat = this.plugin.getConfigManager().getCrossProxyPrivateMessageSenderFormat().replace("{receiver}", targetName).replace("{proxy}", "cross-proxy").replace("{message}", message);
                sender.sendMessage(MessageUtils.formatMessage(senderFormat));
                this.broadcastLocalCrossProxySocialSpy(senderName, senderUUID, targetName, message);
            } else {
                sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getCrossProxyPlayerNotFoundMessage()));
            }
        })).exceptionally(throwable -> {
            this.plugin.getLogger().error("Error during cross-proxy messaging", (Throwable)throwable);
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getCrossProxyLookupTimeoutMessage()));
            return null;
        });
        return true;
    }

    private void broadcastToSocialSpies(Player sender, Player receiver, String message) {
        String spyFormat = this.plugin.getConfigManager().getMessagingSocialSpyFormat().replace("{sender}", sender.getUsername()).replace("{receiver}", receiver.getUsername()).replace("{message}", message);
        Component spyMessage = MessageUtils.formatMessage(spyFormat);
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            UUID playerUUID = player.getUniqueId();
            if (playerUUID.equals(sender.getUniqueId()) || playerUUID.equals(receiver.getUniqueId()) || !this.isSocialSpyEnabled(playerUUID) || !player.hasPermission("bmsproxycore.socialspy.view")) continue;
            player.sendMessage(spyMessage);
        }
    }

    public void setReplyTarget(UUID player, UUID target) {
        this.replyTargets.put(player, target);
    }

    public UUID getReplyTarget(UUID player) {
        return this.replyTargets.get(player);
    }

    public void removeReplyTarget(UUID player) {
        this.replyTargets.remove(player);
    }

    public boolean toggleSocialSpy(UUID player) {
        if (this.socialSpyEnabled.contains(player)) {
            this.socialSpyEnabled.remove(player);
            return false;
        }
        this.socialSpyEnabled.add(player);
        return true;
    }

    public boolean isSocialSpyEnabled(UUID player) {
        return this.socialSpyEnabled.contains(player);
    }

    public boolean toggleMessageAcceptance(UUID player) {
        if (this.messageToggleDisabled.contains(player)) {
            this.messageToggleDisabled.remove(player);
            return true;
        }
        this.messageToggleDisabled.add(player);
        return false;
    }

    public boolean isMessageToggleDisabled(UUID player) {
        return this.messageToggleDisabled.contains(player);
    }

    public boolean addIgnoredPlayer(UUID player, UUID ignored) {
        Set ignored_set = this.ignoredPlayers.computeIfAbsent(player, k -> new HashSet());
        if (ignored_set.contains(ignored)) {
            return false;
        }
        ignored_set.add(ignored);
        return true;
    }

    public boolean removeIgnoredPlayer(UUID player, UUID ignored) {
        Set<UUID> ignored_set = this.ignoredPlayers.get(player);
        if (ignored_set == null || !ignored_set.contains(ignored)) {
            return false;
        }
        ignored_set.remove(ignored);
        return true;
    }

    public boolean isPlayerIgnoring(UUID player, UUID ignored) {
        Set<UUID> ignored_set = this.ignoredPlayers.get(player);
        return ignored_set != null && ignored_set.contains(ignored);
    }

    public Set<UUID> getIgnoredPlayers(UUID player) {
        return this.ignoredPlayers.getOrDefault(player, new HashSet());
    }

    public void handlePlayerDisconnect(UUID player) {
        this.socialSpyEnabled.remove(player);
        this.messageToggleDisabled.remove(player);
        this.replyTargets.entrySet().removeIf(entry -> ((UUID)entry.getValue()).equals(player));
        this.replyTargets.remove(player);
    }

    private void broadcastLocalCrossProxySocialSpy(String senderName, UUID senderUUID, String receiverName, String message) {
        String socialSpyFormat = this.plugin.getConfigManager().getCrossProxyPrivateMessageSocialSpyFormat().replace("{sender}", senderName).replace("{sender_proxy}", this.plugin.getConfigManager().getPrivateMessagesRedisProxyId()).replace("{receiver}", receiverName).replace("{receiver_proxy}", "cross-proxy").replace("{message}", message);
        Component formattedMessage = MessageUtils.formatMessage(socialSpyFormat);
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            if (!this.isSocialSpyEnabled(player.getUniqueId()) || player.getUniqueId().equals(senderUUID)) continue;
            player.sendMessage(formattedMessage);
        }
    }
}

