/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.listeners;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.util.Optional;
import net.kyori.adventure.text.Component;

public class ServerSwitchListener {
    private final BMSProxyCore plugin;

    public ServerSwitchListener(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    @Subscribe(order=PostOrder.NORMAL)
    public void onServerSwitch(ServerPostConnectEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.isStaffChatModuleEnabled()) {
            return;
        }
        String activityPermission = this.plugin.getConfigManager().getStaffChatActivityPermission();
        if (!activityPermission.isEmpty() && !player.hasPermission(activityPermission)) {
            return;
        }
        Optional<ServerInfo> previousServer = Optional.ofNullable(event.getPreviousServer()).map(serverConnection -> serverConnection.getServerInfo());
        Optional<ServerInfo> currentServer = player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo());
        if (previousServer.isPresent() && currentServer.isPresent()) {
            String prevServerName = previousServer.get().getName();
            String currentServerName = currentServer.get().getName();
            Component formattedMessage = MessageUtils.formatStaffServerSwitchMessage(player, prevServerName, currentServerName, this.plugin.getConfigManager());
            MessageUtils.broadcastToPermission(this.plugin.getServer(), formattedMessage, activityPermission);
            this.plugin.sendStaffServerSwitchMessage(player, prevServerName, currentServerName);
            this.plugin.getLogger().info(MessageUtils.componentToPlainText(formattedMessage));
        }
    }
}

