/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.listeners;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.proxy.Player;
import net.kyori.adventure.text.Component;

public class ConnectionListener {
    private final BMSProxyCore plugin;
    private static final String PERMISSION = "bmsproxycore.staffchat.use";

    public ConnectionListener(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    @Subscribe(order=PostOrder.NORMAL)
    public void onPlayerConnect(PostLoginEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getCrossProxyMessagingManager() != null && this.plugin.getConfigManager().isPrivateMessagesRedisEnabled()) {
            this.plugin.getCrossProxyMessagingManager().broadcastPlayerJoin(player);
        }
        if (!player.hasPermission(PERMISSION)) {
            return;
        }
        Component formattedMessage = MessageUtils.formatStaffConnectMessage(player, this.plugin.getConfigManager());
        MessageUtils.broadcastToPermission(this.plugin.getServer(), formattedMessage, PERMISSION);
        this.plugin.sendStaffConnectMessage(player);
        this.plugin.getLogger().info(MessageUtils.componentToPlainText(formattedMessage));
    }

    @Subscribe(order=PostOrder.NORMAL)
    public void onPlayerDisconnect(DisconnectEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission(PERMISSION)) {
            return;
        }
        Component formattedMessage = MessageUtils.formatStaffDisconnectMessage(player, this.plugin.getConfigManager());
        MessageUtils.broadcastToPermission(this.plugin.getServer(), formattedMessage, PERMISSION);
        this.plugin.sendStaffDisconnectMessage(player);
        this.plugin.getLogger().info(MessageUtils.componentToPlainText(formattedMessage));
    }
}

