/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.listeners;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.proxy.Player;
import net.kyori.adventure.text.Component;

public class ChatListener {
    private final BMSProxyCore plugin;

    public ChatListener(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    @Subscribe(order=PostOrder.NORMAL)
    public void onPlayerChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.isStaffChatModuleEnabled()) {
            return;
        }
        String usePermission = this.plugin.getConfigManager().getStaffChatUsePermission();
        if (this.plugin.isStaffChatToggled(player.getUniqueId()) && (usePermission.isEmpty() || player.hasPermission(usePermission))) {
            event.setResult(PlayerChatEvent.ChatResult.denied());
            Component formattedMessage = MessageUtils.formatStaffChatMessage(player, event.getMessage(), this.plugin.getConfigManager(), this.plugin.getServer());
            MessageUtils.broadcastToPermission(this.plugin.getServer(), formattedMessage, usePermission);
            this.plugin.sendStaffChatMessage(player, event.getMessage());
            this.plugin.getLogger().info(MessageUtils.componentToPlainText(formattedMessage));
        }
    }
}

