/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.listeners;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.proxy.Player;

public class ChatControlListener {
    private final BMSProxyCore plugin;

    public ChatControlListener(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    @Subscribe(order=PostOrder.EARLY)
    public void onPlayerChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (!this.plugin.isChatControlModuleEnabled()) {
            return;
        }
        if (this.plugin.isStaffChatModuleEnabled() && this.plugin.isStaffChatToggled(player.getUniqueId())) {
            return;
        }
        if (!this.checkChatLock(player, event)) {
            return;
        }
        if (this.plugin.getConfigManager().isChatCooldownEnabled() && !this.checkCooldown(player, event)) {
            return;
        }
        if (this.plugin.getConfigManager().isChatFilterEnabled() && !this.checkFilter(player, message, event)) {
            return;
        }
        if (this.plugin.getConfigManager().isChatCooldownEnabled()) {
            this.plugin.getChatControlManager().setLastMessageTime(player);
        }
    }

    private boolean checkCooldown(Player player, PlayerChatEvent event) {
        String bypassPermission = this.plugin.getConfigManager().getChatCooldownBypassPermission();
        if (!bypassPermission.isEmpty() && player.hasPermission(bypassPermission)) {
            return true;
        }
        if (!this.plugin.getChatControlManager().canSendMessage(player)) {
            event.setResult(PlayerChatEvent.ChatResult.denied());
            long remainingTime = this.plugin.getChatControlManager().getRemainingCooldown(player);
            String cooldownMessage = this.plugin.getConfigManager().getChatCooldownMessage().replace("{time}", String.valueOf(remainingTime));
            player.sendMessage(MessageUtils.formatMessage(cooldownMessage));
            if (this.plugin.getConfigManager().isChatCooldownLogViolationsEnabled()) {
                String logMessage = this.plugin.getConfigManager().getChatCooldownViolationLogFormat().replace("{player}", player.getUsername());
                this.plugin.getLogger().info(logMessage);
            }
            if (this.plugin.getConfigManager().isChatControlDebugEnabled()) {
                String debugMessage = "Player " + player.getUsername() + " blocked by cooldown (" + remainingTime + "s remaining)";
                String logFormat = this.plugin.getConfigManager().getChatControlDebugFormat().replace("{component}", "Cooldown").replace("{message}", debugMessage);
                this.plugin.getLogger().info(logFormat);
            }
            return false;
        }
        return true;
    }

    private boolean checkFilter(Player player, String message, PlayerChatEvent event) {
        String bypassPermission = this.plugin.getConfigManager().getChatFilterBypassPermission();
        if (!bypassPermission.isEmpty() && player.hasPermission(bypassPermission)) {
            return true;
        }
        if (this.plugin.getChatControlManager().shouldFilterMessage(message)) {
            String action = this.plugin.getConfigManager().getChatFilterAction();
            switch (action.toLowerCase()) {
                case "block": {
                    event.setResult(PlayerChatEvent.ChatResult.denied());
                    break;
                }
                case "warn": {
                    event.setResult(PlayerChatEvent.ChatResult.denied());
                    String warningMessage = this.plugin.getConfigManager().getChatFilterBlockedMessage();
                    player.sendMessage(MessageUtils.formatMessage(warningMessage));
                    break;
                }
                case "replace": {
                    String replacementText = this.plugin.getConfigManager().getChatFilterReplacementText();
                    String filteredMessage = this.replaceFilteredContent(message, replacementText);
                    event.setResult(PlayerChatEvent.ChatResult.message((String)filteredMessage));
                    break;
                }
                default: {
                    event.setResult(PlayerChatEvent.ChatResult.denied());
                    player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatFilterBlockedMessage()));
                }
            }
            if (this.plugin.getConfigManager().isChatFilterLogEnabled()) {
                String logMessage = this.plugin.getConfigManager().getChatFilterLogFormat().replace("{player}", player.getUsername()).replace("{message}", message);
                this.plugin.getLogger().info(logMessage);
            }
            if (this.plugin.getConfigManager().isChatControlDebugEnabled()) {
                String debugMessage = "Message from " + player.getUsername() + " filtered: " + message;
                String logFormat = this.plugin.getConfigManager().getChatControlDebugFormat().replace("{component}", "Filter").replace("{message}", debugMessage);
                this.plugin.getLogger().info(logFormat);
            }
            return false;
        }
        return true;
    }

    private String replaceFilteredContent(String message, String replacementText) {
        String result = message;
        for (String rule : this.plugin.getChatControlManager().getFilterRules()) {
            try {
                Object pattern = this.plugin.getConfigManager().isChatFilterCaseSensitive() ? rule : "(?i)" + rule;
                result = result.replaceAll((String)pattern, replacementText);
            }
            catch (Exception e) {
                if (!this.plugin.getConfigManager().isChatControlDebugEnabled()) continue;
                this.plugin.getLogger().warn("[ChatControl-Debug] Failed to apply replacement for rule: " + rule);
            }
        }
        return result;
    }

    private boolean checkChatLock(Player player, PlayerChatEvent event) {
        if (!this.plugin.getChatControlManager().canSendMessageWithChatLock(player)) {
            event.setResult(PlayerChatEvent.ChatResult.denied());
            String blockedMessage = this.plugin.getConfigManager().getLockChatBlockedMessage();
            player.sendMessage(MessageUtils.formatMessage(blockedMessage));
            return false;
        }
        return true;
    }
}

