/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class StaffChatToggleCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;

    public StaffChatToggleCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source2 = invocation.source();
        if (!this.plugin.isStaffChatModuleEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getModuleDisabledMessage()));
            return;
        }
        if (!(source2 instanceof Player)) {
            source2.sendMessage(MessageUtils.formatMessage("&cThis command can only be executed by a player."));
            return;
        }
        Player player = (Player)source2;
        String togglePermission = this.plugin.getConfigManager().getStaffChatTogglePermission();
        if (!togglePermission.isEmpty() && !player.hasPermission(togglePermission)) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getNoPermissionMessage()));
            return;
        }
        this.plugin.toggleStaffChat(player.getUniqueId());
        if (this.plugin.isStaffChatToggled(player.getUniqueId())) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getToggleOnMessage()));
        } else {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getToggleOffMessage()));
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.completedFuture(List.of());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        String togglePermission = this.plugin.getConfigManager().getStaffChatTogglePermission();
        return togglePermission.isEmpty() || invocation.source().hasPermission(togglePermission);
    }
}

