/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;

public class StaffChatCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;

    public StaffChatCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source2 = invocation.source();
        CharSequence[] args2 = (String[])invocation.arguments();
        if (!this.plugin.isStaffChatModuleEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getModuleDisabledMessage()));
            return;
        }
        if (!(source2 instanceof Player) && !(source2 instanceof ConsoleCommandSource)) {
            source2.sendMessage(MessageUtils.formatMessage("&cThis command can only be executed by a player or the console."));
            return;
        }
        String usePermission = this.plugin.getConfigManager().getStaffChatUsePermission();
        if (source2 instanceof Player && !usePermission.isEmpty() && !source2.hasPermission(usePermission)) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getNoPermissionMessage()));
            return;
        }
        if (args2.length == 0) {
            source2.sendMessage(MessageUtils.formatMessage("&cUsage: /staffchat <message>"));
            return;
        }
        String message = String.join((CharSequence)" ", args2);
        if (source2 instanceof Player) {
            Player player = (Player)source2;
            Component formattedMessage = MessageUtils.formatStaffChatMessage(player, message, this.plugin.getConfigManager(), this.plugin.getServer());
            MessageUtils.broadcastToPermission(this.plugin.getServer(), formattedMessage, usePermission);
            this.plugin.sendStaffChatMessage(player, message);
            this.plugin.getLogger().info(MessageUtils.componentToPlainText(formattedMessage));
        } else {
            Component formattedMessage = MessageUtils.formatConsoleStaffChatMessage(message, this.plugin.getConfigManager());
            String staffPermission = this.plugin.getConfigManager().getStaffChatUsePermission();
            MessageUtils.broadcastToPermission(this.plugin.getServer(), formattedMessage, staffPermission);
            this.plugin.sendConsoleStaffChatMessage(message);
            this.plugin.getLogger().info(MessageUtils.componentToPlainText(formattedMessage));
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.completedFuture(List.of());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        if (invocation.source() instanceof ConsoleCommandSource) {
            return true;
        }
        String usePermission = this.plugin.getConfigManager().getStaffChatUsePermission();
        return usePermission.isEmpty() || invocation.source().hasPermission(usePermission);
    }
}

