/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class SocialSpyCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;
    private static final String TOGGLE_PERMISSION = "bmsproxycore.socialspy.toggle";
    private static final String VIEW_PERMISSION = "bmsproxycore.socialspy.view";

    public SocialSpyCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source2 = invocation.source();
        if (!(source2 instanceof Player)) {
            source2.sendMessage(MessageUtils.formatMessage("&cThis command can only be executed by a player."));
            return;
        }
        Player player = (Player)source2;
        if (!player.hasPermission(TOGGLE_PERMISSION)) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getNoPermissionMessage()));
            return;
        }
        if (!player.hasPermission(VIEW_PERMISSION)) {
            player.sendMessage(MessageUtils.formatMessage("&cYou need the permission to view social spy messages."));
            return;
        }
        boolean enabled = this.plugin.getMessagingManager().toggleSocialSpy(player.getUniqueId());
        if (enabled) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingSocialSpyEnabled()));
        } else {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingSocialSpyDisabled()));
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.completedFuture(new ArrayList());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission(TOGGLE_PERMISSION);
    }
}

