/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class ReplyCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;
    private static final String PERMISSION = "bmsproxycore.message.reply";

    public ReplyCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source2 = invocation.source();
        String[] args2 = (String[])invocation.arguments();
        if (!(source2 instanceof Player)) {
            source2.sendMessage(MessageUtils.formatMessage("&cThis command can only be executed by a player."));
            return;
        }
        Player sender = (Player)source2;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getNoPermissionMessage()));
            return;
        }
        if (args2.length == 0) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorInvalidUsageReply()));
            return;
        }
        UUID replyTargetUUID = this.plugin.getMessagingManager().getReplyTarget(sender.getUniqueId());
        if (replyTargetUUID == null) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorNoReplyTarget()));
            return;
        }
        Optional targetOptional = this.plugin.getServer().getPlayer(replyTargetUUID);
        if (targetOptional.isEmpty()) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorPlayerNotFound()));
            return;
        }
        Player target = (Player)targetOptional.get();
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 0; i < args2.length; ++i) {
            messageBuilder.append(args2[i]).append(" ");
        }
        String message = messageBuilder.toString().trim();
        this.plugin.getMessagingManager().sendMessage(sender, target, message);
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.completedFuture(new ArrayList());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission(PERMISSION);
    }
}

