/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class MessageToggleCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;
    private static final String PERMISSION = "bmsproxycore.message.toggle";

    public MessageToggleCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source2 = invocation.source();
        if (!(source2 instanceof Player)) {
            source2.sendMessage(MessageUtils.formatMessage("&cThis command can only be executed by a player."));
            return;
        }
        Player player = (Player)source2;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getNoPermissionMessage()));
            return;
        }
        boolean accepting = this.plugin.getMessagingManager().toggleMessageAcceptance(player.getUniqueId());
        if (accepting) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingToggleEnabled()));
        } else {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingToggleDisabled()));
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.completedFuture(new ArrayList());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission(PERMISSION);
    }
}

